<?php

declare(strict_types=1);

namespace Application;

use Laminas\Mvc\MvcEvent;
use Application\Library\Listener\MvcListener;

class Module
{
    public function getConfig(): array
    {
        /** @var array $config */
        $config = include __DIR__ . '/../config/module.config.php';
        return $config;
    }
    
    public function onBootstrap(MvcEvent $event) : void
    {
        // Get application instance.
        $application = $event->getApplication();
        
        // Get template map resolver.
        $templateMapResolver = $application->getServiceManager()->get('ViewTemplateMapResolver');
        
        // Create and register MVC listener.
        $listener = new MvcListener($templateMapResolver);
        $listener->attach($application->getEventManager());
        
    }
}
