<?php

namespace Application\Library\postRelacionados;

use Application\Library\Api\Api;
use Laminas\Http\Request;

class SectionsModules
{
    static function generatePostRelacionados($idSection)
    {

        $menu = $_SESSION['menuPublico'];
        /* Procesamos las opciones del menú para obtener solo las de la sección */
        $items = [];
        for ($i = 1; $i < count($menu); $i++) {
            /*  El número de array está en múltiplo de 100 */
            $newIterador = $i * 100;
            if ($menu[$newIterador]['parent'] == $idSection and $menu[$newIterador]['link'] != $_SERVER["REQUEST_URI"]) {
                $items[] = $menu[$newIterador];
            }
        }

        $itemsExtrac = [];
        for ($j = 0; $j < count($items); $j++) {

            $itemsExtrac[] = $items[$j];

            if ($j == 2) {
                break;
            }
        }


        $result = SectionsModules::getUrlApiSection($itemsExtrac);

        return $result;
    }

    static function getUrlApiSection($url)
    {
        for ($i = 0; $i < count($url); $i++) {

            $params = [
                'where' => 'frmIdIdioma eq ' . $_COOKIE['idIdioma']
            ];

            if ($url[$i]['link'] == "/emergencias/emergencias") {

                $fetch = Api::request('/emergencias', Request::METHOD_GET, $params);
                $json = json_decode($fetch->getBody(), true);
                $data = $json['data'][0];

                $img = '/img/content/078-Asistencia-vial.jpeg';
                $tittle = $data['frmContenidoEmergencias']['subMenu'];
                $text1 = $data['frmContenidoEmergencias']['contenido'][0]['subtitulo'][0]['listado'][0]['parrafoUnion'][0]['valor'];
                $text2 =  substr($data['frmContenidoEmergencias']['contenido'][0]['subtitulo'][0]['listado'][0]['parrafoUnion'][1]['valor'], 0,100) . "...";

                $body = "<b>".$text1."</b>".$text2;

                $urlPost = $url[$i]['link'];

                $result .= SectionsModules::generateHtmlSection($img,$tittle,$body,$urlPost);

            }elseif ($url[$i]['link'] ==  "/emergencias/policia-federal") {

                $fetch = Api::request('/policia-federal', Request::METHOD_GET, $params);
                $json = json_decode($fetch->getBody(), true);
                $data = $json['data'][0];

                $img = '/img/content/image-arresto.jpg';
                $tittle = $data['frmContenidoPoliciaFederal']['subMenu'];
                $body =  substr($data['frmContenidoPoliciaFederal']['contenido'][0]['subtitulo'][0]['valor'], 0,120) . "...";
                $urlPost = $url[$i]['link'];

                $result .= SectionsModules::generateHtmlSection($img,$tittle,$body,$urlPost);

            }elseif ($url[$i]['link'] ==  "/emergencias/denuncia-anonima") {

                $fetch = Api::request('/denuncia-anonima', Request::METHOD_GET, $params);
                $json = json_decode($fetch->getBody(), true);
                $data = $json['data'][0];

                $img = '/img/content/image-denuncia.jpg';
                $tittle = $data['frmContenidoDenunciaAnonima']['subMenu'];
                $body =  substr($data['frmContenidoDenunciaAnonima']['contenido'][0]['subtitulo'][0]['valor'], 0,120) . "...";
                $urlPost = $url[$i]['link'];

                $result .= SectionsModules::generateHtmlSection($img,$tittle,$body,$urlPost);

            }elseif ($url[$i]['link'] ==  "/emergencias/informacion-turistica") {

                $fetch = Api::request('/informacion-turistica', Request::METHOD_GET, $params);
                $json = json_decode($fetch->getBody(), true);
                $data = $json['data'][0];

                $img = '/img/content/078-Asistencia-vial.jpeg';
                $tittle = $data['frmContenidoAsistenciaVial']['subMenu'];
                $body =  substr($data['frmContenidoAsistenciaVial']['contenido'][0]['subtitulo'][0]['valor'], 0,120) . "...";
                $urlPost = $url[$i]['link'];

                $result .= SectionsModules::generateHtmlSection($img,$tittle,$body,$urlPost);

            }elseif ($url[$i]['link'] ==  "/emergencias/call-center") {

                $fetch = Api::request('/call-center', Request::METHOD_GET, $params);
                $json = json_decode($fetch->getBody(), true);
                $data = $json['data'][0];

                $img = '/img/content/image-g5.jpg';
                $tittle = $data['frmContenidoCallCenter']['subMenu'];
                $body =  substr($data['frmContenidoCallCenter']['contenido'][0]['subtitulo'][0]['valor'], 0,120) . "...";
                $urlPost = $url[$i]['link'];

                $result .= SectionsModules::generateHtmlSection($img,$tittle,$body,$urlPost);

            }
        }

        return $result;
    }

    static function generateHtmlSection($img,$tittle,$body,$url)
    {
        $textUrl =  "";
        switch ($_COOKIE['idIdioma']){
            case "1": //Español
                $textUrl = "Saber más";
                break;
            case "2": //English
                $textUrl = "Know more";
                break;
            case "3": //Français
                $textUrl = "Savoir plus";
                break;
            case "4": //Deutsch
                $textUrl = "Mehr wissen";
                break;
            case "5": //Português
                $textUrl = "Saber mais";
                break;
            case "6": //Русский
                $textUrl = "Узнать больше";
                break;
        }



        $result = "";
        $result .= '<div class=" col-md-4 col-sm-12 d-flex align-items-center justify-content-center my-3">';
        $result .= '<div class="card shadow-sm border-0 card-post">';
        $result .= '<img src="'. $img .'" class="card-img-top" alt="...">';
        $result .= '<div class="card-body">';
        $result .= '<div class="container-tittle-card" ><h5 class="title-card-post" >'. $tittle .'</h5></div>';
        $result .= '<div class="container-text-card" ><p class="text-div-post">'. $body .'</p></div>';
        $result .= '<p class="text-div"><a href="'. $url  .'" target="_blank" class="over-div-enlaces">'.$textUrl.'</a></p>';
        $result .= '</div></div></div>';

        return $result;
    }


}
