<?php

namespace Application\Library\postRelacionados;

use Application\Library\Api\Api;
use Laminas\Http\Request;

class SectionServicios
{
    static function generatePostRelacionados($idSection)
    {

        $menu = $_SESSION['menuPublico'];
        /* Procesamos las opciones del menú para obtener solo las de la sección */
        $items = [];
        for ($i = 1; $i < count($menu); $i++) {
            /*  El número de array está en múltiplo de 100 */
            $newIterador = $i * 100;
            if ($menu[$newIterador]['parent'] == $idSection and $menu[$newIterador]['link'] != $_SERVER["REQUEST_URI"]) {
                $items[] = $menu[$newIterador];
            }
        }

        $itemsExtrac = [];
        $e = 1;
        for ($j = 0; $j < count($items); $j++) {

            if($items[$j]['link'] != "/servicios/robo-extravio" and $items[$j]['link'] != "/servicios/quejas-prestadores" and $items[$j]['link'] != "/servicios/asesoria-legal") {

//                echo $items[$j]['link'];
                $itemsExtrac[] = $items[$j];
                $e ++;
                if ($e > 3) {
                    break;
                }
            }

        }

        $result = SectionServicios::getUrlApiSection($itemsExtrac);

        return $result;
    }

    static function getUrlApiSection($url)
    {
        $params = [
            'where' => 'frmIdIdioma eq ' . $_COOKIE['idIdioma']
        ];

        for ($i = 0; $i < count($url); $i++) {

            $urlPost = $url[$i]['link'];

            if ($url[$i]['link'] ==  "/servicios/quejas-fraude-cibernetico") {

                $fetch = Api::request('/quejas-fraude-cibernetico', Request::METHOD_GET, $params);
                $json = json_decode($fetch->getBody(), true);
                $data = $json['data'][0];

                $img = '/img/content/image-cyber.jpg';
                $tittle = $data['frmContenidoQuejasFraudeCibernetico']['subMenu'];
                $body =  substr($data['frmContenidoQuejasFraudeCibernetico']['contenido'][0]['subtitulo'][0]['valor'], 0,120) . "...";

                $result .= SectionServicios::generateHtmlSection($img,$tittle,$body,$urlPost);

            }elseif ($url[$i]['link'] ==  "/servicios/reporte-robo") {


                $fetch = Api::request('/reporte-robo', Request::METHOD_GET);
                $json = json_decode($fetch->getBody(), true);
//                $data = $json['data'][0];

                foreach ($json['data'] as $t => $v){
                    if ($v['frmIdIdioma'] == $_COOKIE['idIdioma']){
                        $data = $v;
                    }
                    if(!$_COOKIE['idIdioma']){
                        $data = $v;
                        continue;
                    }
                }
                $img = '/img/content/image-robo.jpg';
                $tittle = $data['frmContenidoReportesRobo']['subMenu'];
                $body =  substr($data['frmContenidoReportesRobo']['contenido'][0]['subtitulo'][0]['valor'], 0,120) . "...";
                $result .= SectionServicios::generateHtmlSection($img,$tittle,$body,$urlPost);

            }elseif ($url[$i]['link'] ==  "/servicios/tarjeta-clonada") {

                $fetch = Api::request('/tarjeta-credito-clonada', Request::METHOD_GET, $params);
                $json = json_decode($fetch->getBody(), true);
                $data = $json['data'][0];

                $img = '/img/content/image-clon.jpg';
                $tittle = $data['frmContenidoTarjetaCreditoClonada']['subMenu'];

                $textAdd = SectionServicios::addtext();

                $body =  substr($data['frmContenidoTarjetaCreditoClonada']['contenido'][0]['subtitulo'][0]['valor'], 0,120) . "..."."<br>".$textAdd;
                $result .= SectionServicios::generateHtmlSection($img,$tittle,$body,$urlPost);

            }elseif ($url[$i]['link'] ==  "/servicios/informacion-medica") {

                $fetch = Api::request('/asistencia-medica', Request::METHOD_GET);
                $json = json_decode($fetch->getBody(), true);
//                $data = $json['data'][0];

                foreach ($json['data'] as $i => $v){
                    if ($v['frmIdIdioma'] == $_COOKIE['idIdioma']){
                        $data = $v;
                    }
                    if(!$_COOKIE['idIdioma']){
                        $data = $v;
                        continue;
                    }
                }
                $img = '/img/content/asistencia_medica.jpeg';
                $tittle = $data['frmContenidoAsistenciaMedica']['subMenu'];
                $body =  substr($data['frmContenidoAsistenciaMedica']['contenido'][0]['subtitulo'][0]['listado'][0]['valor'], 0,120) . "...";

                $result .= SectionServicios::generateHtmlSection($img,$tittle,$body,$urlPost);

            }
        }

        return $result;
    }

    static function generateHtmlSection($img,$tittle,$body,$url)
    {
        $textUrl =  "";
        switch ($_COOKIE['idIdioma']){
            case "1": //Español
                $textUrl = "Saber más";
                break;
            case "2": //English
                $textUrl = "Know more";
                break;
            case "3": //Français
                $textUrl = "Savoir plus";
                break;
            case "4": //Deutsch
                $textUrl = "Mehr wissen";
                break;
            case "5": //Português
                $textUrl = "Saber mais";
                break;
            case "6": //Русский
                $textUrl = "Узнать больше";
                break;
        }

        $result = "";
        $result .= '<div class=" col-md-4 col-sm-12 d-flex align-items-center justify-content-center my-3">';
        $result .= '<div class="card shadow-sm border-0 card-post" >';
        $result .= '<img src="'. $img .'" class="card-img-top" alt="...">';
        $result .= '<div class="card-body">';
        $result .= '<div class="container-tittle-card" ><h5 class="title-card-post" >'. $tittle .'</h5></div>';
        $result .= '<div class="container-text-card" ><p class="text-div-post">'. $body .'</p></div>';
        $result .= '<p class="text-div"><a href="'. $url  .'" target="_blank" class="over-div-enlaces">'.$textUrl.'</a></p>';
        $result .= '</div></div></div>';

        return $result;
    }

    static function addtext()
    {
        $textUrl =  "";
        switch ($_COOKIE['idIdioma']){
            case "1": //Español
                $textUrl = "Llama al banco correspondiente y reporta el delito. Hay bancos que ofrecen seguros contra fraude, robo y asalto en cajeros automáticos.";
                break;
            case "2": //English
                $textUrl = "Call the corresponding bank and report the crime. There are banks that offer insurance against fraud, theft and assault at ATMs.";
                break;
            case "3": //Français
                $textUrl = "Contacter votre banque correspondante et dénoncer les faits. Certaines banques offrent des assurances contre fraude, vol ou aggression en guichet automatique.";
                break;
            case "4": //Deutsch
                $textUrl = "Sperren Sie Ihre Karte und rufen Sie die zuständige Bank an und melden Sie das Verbrechen. Einige Banken bieten eine Versicherung gegen Betrug, Diebstahl und Geldautomatenüberfall an.";
                break;
            case "5": //Português
                $textUrl = "Entre em contato com o banco relevante e denuncie o crime. Alguns bancos oferecem seguro contra fraude, furto e roubo de caixas eletrônicos";
                break;
            case "6": //Русский
                $textUrl = "Позвоните в соответствующий банк и сообщите о преступлении. Есть банки, которые предлагают страховку от мошенничества, кражи и нападения в банкоматах. Спросите свой банк.";
                break;
        }

        return $textUrl;

    }


}
