<?php
namespace Application\Library\SocialNetworks;

use Application\Library\Api\Api;
use Application\Library\Complements\MyLogger;
use DateTime;
use Exception;
use Google\Service\Oauth2;
use Google\Service\PeopleService;
use Google\Service\PeopleService\Date;
use Google_Client;
use Laminas\Http\Request;


/**
 * It manages login google Account.
 * @author desarrollo01
 */
class GoogleHandler
{
    private $clientID;
    private $clientSecret;
    private $redirectUri;
    private $client;

    public function __construct(
        $clientID = '593083509632-pg1j91pmoghec1e3k8fsa2ni2vgioslf.apps.googleusercontent.com',
        $clientSecret = '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',
        $redirectUri = 'auth-social-network/google-successfull'
    ) {
        $this->clientID = $clientID;
        $this->clientSecret = $clientSecret;
        $this->redirectUri = (empty($_SERVER['HTTPS']) ? 'http' : 'https') . "://$_SERVER[HTTP_HOST]/" . $redirectUri;
        $this->client = new Google_Client();
        $this->client->setClientId($this->clientID);
        $this->client->setClientSecret($this->clientSecret);
        $this->client->setRedirectUri($this->redirectUri);
        $this->client->addScope("email");
        $this->client->addScope("profile");
        $this->client->addScope('https://www.googleapis.com/auth/user.birthday.read');
        $this->client->addScope('https://www.googleapis.com/auth/user.gender.read');
    }

    public function generateAuthorizationUrl()
    {
        return $this->client->createAuthUrl();
    }

    public function handleSignInResponse()
    {
        if (isset($_GET['code'])) {
            try {
                $token = $this->client->fetchAccessTokenWithAuthCode($_GET['code']);
                $this->client->setAccessToken($token['access_token']);
                $googleOauth = new Oauth2($this->client);
                $userInfo = $googleOauth->userinfo->get();
                try {
                    $peopleService = new PeopleService($this->client);
                    $person = $peopleService->people->get('people/me', ['personFields' => 'birthdays,genders']);
                } catch (Exception $e) {
                    MyLogger::info($e);
                }                
                $idRedSocial = 3;
                $uId = $userInfo->id;
                $nombre = $userInfo->given_name;
                $apellido = $userInfo->family_name;
                $correoElectronico = $userInfo->email;
                $fechaNacimiento = null;
                $genero = null;
                try {
                    $birthdays = $person->getBirthdays();
                } catch (Exception $e) {
                    MyLogger::info($e);
                }

                try {
                    $genders = $person->getGenders();
                } catch (Exception $e) {
                    MyLogger::info($e);
                }

                if (!empty($birthdays) && isset($birthdays[0]) && $birthdays[0]->getDate() instanceof Date) {
                    try {
                        $birthday = $birthdays[0]->getDate();
                        if($birthday->getDay() != NULL && $birthday->getMonth() != NULL && $birthday->getYear() != NULL){
                            $fechaNacimiento = $birthday->getDay() . "/" . $birthday->getMonth() . "/" . $birthday->getYear();
                            $fechaNacimiento = DateTime::createFromFormat('j/n/Y', $fechaNacimiento)->format('Y-m-d');  
                        }
                    } catch (Exception $e) {
                        $fechaNacimiento = null;
                        MyLogger::info($e);
                    }
                }

                if (!empty($genders) && isset($genders[0]) && $genders[0]->getValue() !== null) {
                    try {
                        $genero = !empty($genders) ? $genders[0]->getValue() : '';
                    } catch (Exception $e) {
                        $genero = null;
                        MyLogger::info($e);
                    }
                    
                }
                $params = [
                    'where' => 'frmUidUsuariosRedesSociales eq ' . $uId .
                    '|or|frmIdNombreUsuarioUsuario eq '.$correoElectronico
                ];
                $existente = Api::request('/validate-uid', request::METHOD_GET, $params);
                $body = json_decode($existente->getBody(), true);
                if($genero != null){
                    $genero = $genero == 'male' ? '1' : '2' ;
                }

                $loginData = [
                    'frmCorreo' => $correoElectronico,
                    'frmContraseña' => null,
                    'frmIdRedSocial' => $idRedSocial,
                    'frmNombre' => $nombre,
                    'frmApellidoPaterno' => $apellido,
                    'frmApellidoMaterno' => null,
                    'frmIdGenero' => $genero,
                    'frmFechaNacimiento' => $fechaNacimiento,
                    'frmUidRedSocial' => $uId
                ];
                foreach (@$body['data']  as $k => $v) {
                    if (@$v['frmUidUsuariosRedesSociales'] == $uId) {
                        $loginResult = Api::request('/login', request::METHOD_POST, $loginData, false);
                        $login = json_decode($loginResult->getBody(), true);
                        setcookie('datosUsuario', serialize($login['datosUsuario']), 0, '/');
                        $response = [
                            'code' => '1',
                            'message' => 'Inicio de sesion exitoso'
                        ];
                        return $response;
                    }
                }
                $registroApiResult = Api::request('/registro', Request::METHOD_POST, $loginData, false);
                $registroResult = json_decode($registroApiResult->getBody(), true);
                if (isset($registroResult['error'])) {
                    $response = [
                        'code' => '-1',
                        'message' => $registroResult['error']['message']
                    ];

                    return $response;
                }
                $loginResult = Api::request('/login', request::METHOD_POST, $loginData, false);
                $login = json_decode($loginResult->getBody(), true);

                setcookie('datosUsuario', serialize($login['datosUsuario']), 0, '/');
                $response = [
                    'code' => '1',
                    'message' => 'Inicio de sesion exitoso'
                ];
                return $response;
            } catch (Exception $e) {
                $response = [
                    'code' => '-1',
                    'message' => 'Inicio de sesion incorrecto'
                ];
            }
        } else
            return $response = [
                'code' => '-1',
                'message' => 'Inicio de sesion incorrecto'
            ];
    }
}
