<?php
namespace Application\Library\SocialNetworks;

use Application\Library\Api\Api;
use Application\Library\Complements\MyLogger;
use Laminas\Http\Request;
use PhpParser\Node\Expr\Isset_;

/**
 * It manages login with email.
 * @author desarrollo01
 */
class EmailHandler
{
    private $email;
    private $password;
    private $nombre;
    private $apellidoPaterno;
    private $apellidoMaterno;
    private $idGenero;
    private $fechaNacimiento;

    public function __construct($email , $password, $nombre = null, $apellidoPaterno = null, $apellidoMaterno = null, $idGenero = null, $fechaNacimiento = null)
    {
        $this->email = $email;
        $this->password = $password;
        $this->nombre = $nombre;
        $this->apellidoPaterno = $apellidoPaterno;
        $this->apellidoMaterno = $apellidoMaterno;
        $this->idGenero = $idGenero;
        $this->fechaNacimiento = $fechaNacimiento;    
    } 

    public function inciarSesion(){
        try{
            $loginData = [
                'frmCorreo' => $this->email,
                'frmContraseña' => $this->password,
                'frmUidRedSocial' => null
            ];
            $loginResult = Api::request('/login', Request::METHOD_POST, $loginData, false);
            $login = json_decode($loginResult->getBody(), true);
            setcookie('datosUsuario',serialize($login['datosUsuario']),0,'/');
            $response = [
                'code' => '1',
                'message' => 'Inicio de sesion exitoso'
            ];
            return $response;
        }catch (\Exception $e) {
            $response = [
                'code' => '-1',
                'message' => 'Error: ' . $e 
            ];
            return $response;
        }
    }

    public function registrar() {
        try {
            $loginData = [
                'frmCorreo' => $this->email,
                'frmContraseña' => $this->password,
                'frmIdRedSocial' => '1',
                'frmNombre' => $this->nombre,
                'frmApellidoPaterno' => $this->apellidoPaterno,
                'frmApellidoMaterno' => $this->apellidoMaterno,
                'frmIdGenero' => $this->idGenero,
                'frmFechaNacimiento' => $this->fechaNacimiento,
                'frmUidRedSocial' => null
            ];
            $registroApiResult = Api::request('/registro', request::METHOD_POST, $loginData, false);
            $registroResult = json_decode($registroApiResult->getBody(),true);
            if(isset($registroResult['error'])){
                $response = [
                    'code' => '-1',
                    'message' => $registroResult['error']['message']
                ];
                return $response;
            }
            $loginResult = Api::request('/login', request::METHOD_POST, $loginData, false);
            $login = json_decode($loginResult->getBody(), true);
            setcookie('datosUsuario',serialize($login['datosUsuario']),0,'/');
            $response = [
                'code' => '1',
                'message' => 'Inicio de sesion exitoso'
            ];
            return $response;
        } catch (\Exception $e) {
            $response = [
                'code' => '-1',
                'message' => 'Error: ' . $e 
            ];
            return $response;
        }
    }
}
?>