<?php

namespace Application\Library\Data;

class InformationTours {
    /**
     * @var array $data Lista con el contenido para la página de Info Tours por idioma
     */
    private $data;

    /**
     * 
     */
    const LANG_ESP = 1;
    const LANG_ENG = 2;
    const LANG_FRA = 3;
    const LANG_DEU = 4;
    const LANG_POR = 5;
    const LANG_RUS = 6;
    const LANG_FALLBACK = 1;

    const BASE_PATH = "https://apiga.bemira.mx:443/";

    /**
     * __contruct
     * [Inicializar la variable $data que tiene el contenido de la página en diferentes idiomas]
     */
    function __construct()
    {
        $this->data =
        [
            [
                "frmIdIdioma" => self::LANG_ESP,
                "frmBasePath" => self::BASE_PATH,
                "frmInfo" => [
                    "subMenu" => "INFORMACIÓN TURÍSTICA",
                    "contenido" => [
                        "texto1" => "El Caribe Mexicano es un destino turístico extraordinario, con una amplia variedad de atractivos turísticos culturales y naturales, con diversos sitios históricos, una cultura maya viva y gran biodiversidad. Un destino turístico dónde todas las personas, de todas las edades encuentran opciones atractivas para cualquier tipo de viaje. \n\nLas vacaciones son un buen momento para desconectar de la rutina, descansar y recargar energía. Recuerda que, sin importar el destino, debes informarte y tomar las medidas de precaución e higiene que sean necesarias para protegerte a ti y a tus seres queridos.\n\nSin duda alguna, la mejor forma de conocer y disfrutar del Caribe Mexicano es siendo un turista responsable, promoviendo el respeto hacia los destinos, sus habitantes y su medioambiente, así ayudando en la conservación de estos y beneficiándose mutuamente\n\nEn la página del Caribe Mexicano vas a encontrar todo lo que necesitas saber para que tengas unas vacaciones inolvidables",

                        "texto2" =>  [
                            "¡Conoce todo lo que el Caribe Mexicano tiene para ti! Entra a ",
                            "https://www.caribemexicano.travel/"
                        ]   
                    ]
                ]
            ],
            [
                "frmIdIdioma" => self::LANG_ENG,
                "frmBasePath" => self::BASE_PATH,
                "frmInfo" => [
                    "subMenu" => "TOURIST INFORMATION",
                    "contenido" => [
                        "texto1" => "The Mexican Caribbean is an extraordinary tourist destination, with a wide variety of cultural and natural tourist attractions, with diverse historical sites, a living Mayan culture and great biodiversity. A tourist destination where people of all ages can find attractive options for any type of trip.\n\nVacations are a good time to disconnect from routine, rest and recharge energy. Remember that, regardless of the destination, you should inform yourself and take the necessary precautionary and hygienic measures to protect yourself and your loved ones.\n\nUndoubtedly, the best way to know and enjoy the Mexican Caribbean is to be a responsible tourist, promoting respect for the destinations, its inhabitants and its environment, thus helping in the conservation of these and benefiting each other.\n\nIn the Mexican Caribbean page you will find everything you need to know to have an unforgettable vacation.",

                        "texto2" => [
                            "Get to know everything the Mexican Caribbean has for you! Visit ",
                            "https://www.caribemexicano.travel/",
                        ],
                    ]
                ]
            ],
            [
                "frmIdIdioma" => self::LANG_POR,
                "frmBasePath" => self::BASE_PATH,
                "frmInfo" => [
                    "subMenu" => "INFORMAÇÃO TURÍSTICA",
                    "contenido" => [
                        "texto1" => "O Caribe Mexicano é um destino turístico extraordinário, com uma ampla variedade de atrações turísticas culturais e naturais, incluindo diversos locais históricos, uma cultura maia viva e uma grande biodiversidade.É um destino turístico onde pessoas de todas as idades encontram opções atrativas para qualquer tipo de viagem.\n\nAs férias são um bom momento para desconectar da rotina, descansar e recarregar energias.Lembre - se de que, não importa o destino, é importante se informar e tomar as medidas de precaução e higiene necessárias para proteger a si mesmo e aos seus entes queridos.\n\nSem dúvida, a melhor maneira de conhecer e desfrutar do Caribe Mexicano é sendo um turista responsável, promovendo o respeito pelos destinos, seus habitantes e seu meio ambiente, contribuindo assim para sua conservação e beneficiando - se mutuamente.\n\nNo site do Caribe Mexicano, você encontrará tudo o que precisa saber para ter férias inesquecíveis!",

                        "texto2" => [
                            "Conheça tudo o que o Caribe Mexicano tem para você! Acesse:  ",
                            "https://www.caribemexicano.travel/",
                        ],
                    ]
                ]
            ],
            [
                "frmIdIdioma" => self::LANG_FRA,
                "frmBasePath" => self::BASE_PATH,
                "frmInfo" => [
                    "subMenu" => "INFORMATIONS TOURISTIQUES",
                    "contenido" => [
                        "texto1" => "La région des Caraïbes mexicaines est une destination touristique exceptionnelle, offrant une grande variété dattractions culturelles et naturelles, avec de nombreux sites historiques, une culture maya vivante et une grande biodiversité. Cest une destination où les personnes de tous âges trouvent des options attrayantes pour tout type de voyage.\n\nLes vacances sont un excellent moment pour se déconnecter de la routine, se reposer et recharger les batteries. Noubliez pas que, quelle que soit la destination, vous devez vous informer et prendre les mesures de précaution et dhygiène nécessaires pour vous protéger, vous et vos proches.\n\nSans aucun doute, la meilleure façon de connaître et de profiter des Caraïbes mexicaines est d’être un touriste responsable, en promouvant le respect des destinations, de leurs habitants et de leur environnement, contribuant ainsi à leur conservation et bénéficiant mutuellement.\n\nSur le site des Caraïbes mexicaines, vous trouverez tout ce que vous devez savoir pour passer des vacances inoubliables.",

                        "texto2" => [
                            "Découvrez tout ce que les Caraïbes mexicaines ont à vous offrir ! Visitez",
                            "https://www.caribemexicano.travel/",
                        ],
                    ]
                ]
            ],
            [
                "frmIdIdioma" => self::LANG_DEU,
                "frmBasePath" => self::BASE_PATH,
                "frmInfo" => [
                    "subMenu" => "TOURISTENINFORMATION",
                    "contenido" => [
                        "texto1" => "Die mexikanische Karibik ist ein außergewöhnliches Reiseziel mit einer Vielzahl von kulturellen und natürlichen Sehenswürdigkeiten, darunter zahlreiche historische Stätten, eine lebendige Maya-Kultur und eine große Biodiversität. Es ist ein Reiseziel, wo Menschen aller Altersgruppen attraktive Optionen für jede Art von Reise finden.\n\nUrlaub ist eine gute Gelegenheit, um sich von der Routine zu trennen, sich auszuruhen und Energie zu tanken. Denken Sie daran, dass Sie sich unabhängig vom Ziel informieren und die notwendigen Vorsichts- und Hygienemaßnahmen ergreifen sollten, um sich und Ihre Lieben zu schützen.\n\nZweifellos ist die beste Art, die mexikanische Karibik zu entdecken und zu genießen, ein verantwortungsbewusster Tourist zu sein, der den Respekt vor den Reisezielen, ihren Bewohnern und ihrer Umwelt fördert und so zur Erhaltung beiträgt und gegenseitig profitiert.\n\nAuf der Seite der mexikanischen Karibik finden Sie alles, was Sie für einen unvergesslichen Urlaub wissen müssen.",

                        "texto2" => [
                            "Erfahren Sie alles, was die mexikanische Karibik für Sie bereithält! Besuchen Sie",
                            "https://www.caribemexicano.travel/",
                        ],
                    ]
                ]
            ],
            [
                "frmIdIdioma" => self::LANG_RUS,
                "frmBasePath" => self::BASE_PATH,
                "frmInfo" => [
                    "subMenu" => "ТУРИСТИЧЕСКАЯ ИНФОРМАЦИЯ",
                    "contenido" => [
                        "texto1" => "Мексиканские Карибы - это выдающееся туристическое направление с широким спектром культурных и природных достопримечательностей, включая многочисленные исторические места, живую майскую культуру и большое биоразнообразие. Это туристическое направление, где люди всех возрастов находят привлекательные варианты для любого типа поездки.\n\nОтпуск - это отличная возможность отключиться от рутины, отдохнуть и восстановить силы. Помните, что независимо от пункта назначения, вам следует узнавать информацию и принимать необходимые меры предосторожности и гигиены, чтобы защитить себя и своих близких.\n\nБез сомнения, лучший способ познакомиться и насладиться Мексиканскими Карибами - быть ответственным туристом, способствуя уважению к местам назначения, их жителям и окружающей среде, тем самым помогая в их сохранении и получая взаимную выгоду.\n\nНа странице Мексиканских Карибов вы найдете всю необходимую информацию для незабываемого отпуска.",

                        "texto2" => [
                            "Узнайте все, что Мексиканские Карибы могут вам предложить! Посетите ",
                            "https://www.caribemexicano.travel/",
                        ],
                    ]
                ]
            ],
        ];
    }

    /**
     * getData
     * [Busca el contenido por idioma]
     */
    public function getData($langId = null) {
        if (empty($langId))
            return $this->data;

        // Búsqueda de index del contenido en el idioma elegido 
        $dataIndex = array_search($langId, array_column($this->data,"frmIdIdioma"));
        // Si se eligió un idioma

        if ($dataIndex === false)
            $dataIndex = array_search(self::LANG_FALLBACK, array_column($this->data, "frmIdIdioma"));

        return $this->data[$dataIndex];
    }

}

