<?php

namespace Application\Library\Complements;

use Exception;
use Laminas\Log\Logger;
use Laminas\Log\Writer\Stream;

class MyLogger
{
    const LOG = './public/data/system.log';

    public static function info($data)
    {
        try{
            $logger = new Logger();
            $writer = new Stream(self::LOG);
            $logger->addWriter($writer);
            if(is_array($data) || is_object($data)){
                $logger->info([$data]);
            } else{
                $logger->info($data);
            }
        } catch (Exception $e){}
    }

    public static function error(Exception $e)
    {
        try{
            $error = 'Error ('. $e->getCode().') - '. $e->getMessage();
            $error .= ' en '. $e->getFile(). ' - linea '. $e->getLine();
            self::info($error);
        } catch(Exception $e){
            self::info($e->getMessage());
        }
    }
}