<?php

declare(strict_types=1);

namespace Application;

use Laminas\Router\Http\Literal;
use Laminas\Mvc\Controller\LazyControllerAbstractFactory;

return [
    'controllers' => [
        'factories' => [
            Controller\IndexController::class => LazyControllerAbstractFactory::class,
        ],
    ],
    'router' => [
        'routes' => [
            'home' => [
                'type'    => Literal::class,
                'options' => [
                    'route'    => '/app/home',
                    'defaults' => [
                        'controller' => Controller\IndexController::class,
                        'action'     => 'index',
                    ],
                ],
            ]
        ],
    ],
    'view_manager' => [
        'display_not_found_reason' => true,
        'display_exceptions'       => true,
        'doctype'                  => 'HTML5',
        'not_found_template'       => 'error/404',
        'exception_template'       => 'error/index',
        'template_map' => [
            'layout/layout'           => __DIR__ . '/../view/layout/layout.phtml',
            'layout/affiliate'           => __DIR__ . '/../view/layout/affiliate.phtml',
            'application/index/index' => __DIR__ . '/../view/application/index/index.phtml',
            'error/404'               => __DIR__ . '/../view/error/404.phtml',
            'error/index'             => __DIR__ . '/../view/error/index.phtml',
            'application/partial/menu'=> __DIR__ . '/../view/partial/menu.phtml',
            'general/layout'          => __DIR__ . '/../view/general/header.phtml',
            'general/banner-morena'         => __DIR__ . '/../view/general/banner-morena.phtml',
            'general/banner-morena-principal'         => __DIR__ . '/../view/general/banner-morena-principal.phtml',
            'general/promocion-footer'          => __DIR__ . '/../view/general/promocion-footer.phtml',
            'general/footer'          => __DIR__ . '/../view/general/footer.phtml',
            'general/banner'          => __DIR__ . '/../view/general/banner.phtml',
            'general/banner-fondo'          => __DIR__ . '/../view/general/banner-fondo.phtml',
            'general/accesos-directos'          => __DIR__ . '/../view/general/accesos-directos.phtml',
            'general/menu-publico'          => __DIR__ . '/../view/general/menu-publico.phtml',
        ],
        'template_path_stack' => [
            __DIR__ . '/../view',
        ],
        
    ],
];
