<?php

use App\Http\Controllers\ProfileController;
use App\Http\Controllers\MessageController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/', function () {
    return view('auth/login');
    // return view('welcome');
});

Route::get('/dashboard', [MessageController::class, 'message_table'])
    ->middleware(['auth', 'verified'])
    ->name('dashboard');

Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    // Guardar mensaje
    Route::post('/messages', [MessageController::class, 'messaje_send'])->name('messages.messaje_send');

    Route::get('/messages/list', function () {
        $messages = \App\Models\Message::orderBy('created_at', 'desc')->paginate(10);
        return view('element.messages_table_rows', compact('messages'));
    })->name('messages.list');
});

require __DIR__.'/auth.php';
