<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\DeviceRegisterController;
use App\Http\Controllers\MessageController;
use App\Http\Controllers\FirebaseController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});
// NUEVAS RUTAS
Route::get('/device_register_get', [DeviceRegisterController::class, 'register_get']);
Route::post('/device_register_post', [DeviceRegisterController::class, 'register_post']);
Route::post('/send_message', [FirebaseController::class, 'send']);
Route::get('/messages', [MessageController::class, 'message']);