<script>
    function modalMensaje() {
        return {
            showModal: false,
            showSuccessModal: false,
            title: '',
            body: '',
            isLoading: false,
            submitForm() {
                this.isLoading = true;

                enviarMensaje(
                    this.title,
                    this.body,
                    () => {
                        this.title = '';
                        this.body = '';
                        this.showModal = false;
                        this.showSuccessModal = true;
                        this.recargarTabla();
                    },
                    (errorMsg) => {
                        alert(errorMsg);
                    },
                    () => {
                        this.isLoading = false;
                    }
                );
            },
            recargarTabla() {
                fetch('{{ url("/messages/list") }}')
                    .then(response => response.text())
                    .then(html => {
                        document.getElementById('messages-table-body').innerHTML = html;
                    })
                    .catch(() => alert('Error al cargar la tabla de mensajes'));
            }
        }
    }

    function enviarMensaje(title, body, onSuccess, onError, onFinally) {
        fetch('{{ url("/messages") }}', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '{{ csrf_token() }}',
            },
            body: JSON.stringify({ title, body })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                onSuccess && onSuccess(data);
            } else {
                onError && onError('Error al guardar');
            }
        })
        .catch(() => {
            onError && onError('Error de red');
        })
        .finally(() => {
            onFinally && onFinally();
        });
    }
</script>
