@forelse ($messages as $message)
<tr>
    <td class="px-4 py-2">{{ $message->title }}</td>
    <td class="px-4 py-2">{{ $message->body }}</td>
    <td class="px-4 py-2">
        <span class="px-2 py-1 rounded text-xs font-medium
            {{ $message->status === 'pendiente' ? 'pending_status_custom' : 'sending_status_custom' }}">
            {{ $message->status }}
        </span>
    </td>
    <td>{{ \Carbon\Carbon::parse($message->created_at)->format('d/m/Y H:i') }}</td>
</tr>
@empty
<tr>
    <td colspan="4" class="px-4 py-4 text-center text-gray-500 dark:text-gray-400">
        No hay mensajes.
    </td>
</tr>
@endforelse

<style>
    .pending_status_custom{
        color: #ff0000;
    }
    .sending_status_custom{
        color: #008000;
    }
</style>