<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 dark:text-gray-200 leading-tight">
            {{ __('Inicio') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white dark:bg-gray-800 shadow-sm sm:rounded-lg">  
                <div x-data="modalMensaje()"> <!-- aquí está el único x-data -->
                    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                        <div class="flex justify-between h-16">
                            <div class="flex"></div>

                            <div class="sm:flex sm:items-center sm:ml-6">
                                <!-- Botón que abre el modal -->
                                <x-primary-button class="ml-3" @click="showModal = true">
                                    {{ __('Crear mensaje') }}
                                </x-primary-button>
                            </div>
                        </div>
                    </div>

                    @include('element.modal_mensaje')
                    @include('element.modal_mensaje_success')
                </div>
                @include('element.script_modal_mensaje') <!-- aquí metes el <script> -->
                
                

                <div class="p-6 text-gray-900 dark:text-gray-100">
                    <!-- Filtros -->
                    <form method="GET" action="{{ route('dashboard') }}" class="flex flex-wrap gap-4 mb-4">
                        <input type="text" name="title" placeholder="Buscar por título" value="{{ request('title') }}"
                            class="border rounded px-3 py-2" />
                        <input type="date" name="date" value="{{ request('date') }}"
                            class="border rounded px-3 py-2" />
                        <button type="submit"
                            class="fill_custom">
                            Filtrar
                        </button>
                    </form>

                    <!-- Tabla -->
                    <div class="overflow-x-auto bg-white dark:bg-gray-900 rounded shadow">
                        <table class="w-full divide-y divide-gray-200">
                            <thead class="bg-gray-100 dark:bg-gray-700 text-gray-700 dark:text-gray-200">
                                <tr>
                                    <th class="px-4 py-2 text-left">Título</th>
                                    <th class="px-4 py-2 text-left">Mensaje</th>
                                    <th class="px-4 py-2 text-left">Estado</th>
                                    <th class="px-4 py-2 text-left">Fecha</th>
                                </tr>
                            </thead>                            
                            <tbody id="messages-table-body">
                                @include('element.messages_table_rows', ['messages' => $messages])
                            </tbody>
                        </table>
                    </div>
                    <!-- Paginación -->
                    <div class="mt-4">
                        {{ $messages->appends(request()->query())->links() }}
                    </div>
                </div>

            </div>
        </div>
    </div>
</x-app-layout>
<style>
.fill_custom{
    color: #8e002d;
    background: #fff;
    border-width: 1px;
    border-color: #8e002d;
    padding: 0.5rem;
    border-radius: 0.4rem;
}
</style>
