<?php

namespace App\Services;

use Kreait\Firebase\Factory;
use Kreait\Firebase\Messaging\CloudMessage;
use Kreait\Firebase\Messaging\Notification;

class FirebaseService
{
    protected $messaging;

    public function __construct()
    {
        $factory = (new Factory)->withServiceAccount(storage_path('app/firebase/firebase_credentials.json'));
        $this->messaging = $factory->createMessaging();
    }

    public function enviarNotificacionATopico(string $topico, string $titulo, string $mensaje)
    {
        $iconUrl = 'https://hostyourgeek.com/guestassist_panel/public/images/icon_message.png';
        $notification = Notification::create($titulo, $mensaje);

        $message = CloudMessage::withTarget('topic', $topico)
            ->withNotification($notification)
            ->withData(['icon' => $iconUrl]);

        return $this->messaging->send($message);
    }
}
