<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Message;
use App\Services\FirebaseService;
use Exception;

class MessageController extends Controller
{
    public function messaje_send(Request $request)
    {
        $request->validate([
            'title' => 'required|string|max:255',
            'body' => 'required|string',
        ]);

        try {
            // 1. Enviar notificación al tópico
            $firebase = new FirebaseService();
            $firebase->enviarNotificacionATopico(
                'general', // Tópico fijo o dinámico
                $request->title,
                $request->body
            );

            // 2. Si la notificación fue exitosa, guardar como 'enviado'
            Message::create([
                'title' => $request->title,
                'body' => $request->body,
                'status' => 'enviado',
            ]);

            return response()->json([
                'success' => true,
                'firebase_response' => 'Mensaje enviado y guardado exitosamente'
            ]);

        } catch (Exception $e) {
            // 3. Si ocurre un error, guardar como 'pendiente'
            Message::create([
                'title' => $request->title,
                'body' => $request->body,
                'status' => 'pendiente',
            ]);

            return response()->json([
                'success' => false,
                'firebase_response' => 'Error al enviar o guardar el mensaje'
            ], 500);
        }
    }

    public function message_table(Request $request)
    {
        $query = Message::query();

        // Filtrar por título
        if ($request->filled('title')) {
            $query->where('title', 'like', '%' . $request->title . '%');
        }

        // Filtrar por fecha
        if ($request->filled('date')) {
            $query->whereDate('created_at', $request->date);
        }

        // Ordenar y paginar
        $messages = $query->orderBy('created_at', 'desc')->paginate(10);

        return view('dashboard', compact('messages'));
    }

    public function message(Request $request)
    {
        $messages = Message::orderBy('created_at', 'desc')->get();

        if ($messages->isEmpty()) {
            return response()->json([
                'success' => true,
                'messages' => 'No hay mensajes'
            ]);
        }

        return response()->json([
            'success' => true,
            'messages' => $messages
        ]);
    }
}
