<?php

namespace App\Http\Controllers;

use App\Services\FirebaseService;
use Illuminate\Http\Request;
use Exception;

class FirebaseController extends Controller
{
    public function send(Request $request)
    {
        $request->validate([
            'topico' => 'required|string',
            'titulo' => 'required|string',
            'mensaje' => 'required|string',
        ]);

        try {
            $firebase = new FirebaseService();
            $firebase->enviarNotificacionATopico(
                $request->topico,
                $request->titulo,
                $request->mensaje
            );

            return response()->json([
                'success' => true,
                'firebase_response' => 'Mensaje se a enviado',
            ]);
        } catch (Exception $e) {
            return response()->json([
                'success' => false,
                'firebase_response' => 'Mensaje no se envio al destino',
            ], 500);
        }
    }
}
