<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\DeviceRegister;

class DeviceRegisterController extends Controller
{
    // GET: /api/device_register_get
    public function register_get()
    {
        $devices = DeviceRegister::all();
        return response()->json($devices);
    }

    // POST: /api/device_register_post
    public function register_post(Request $request)
    {
        $validated = $request->validate([
            'fmc_token' => 'required|string',
            'platform' => 'required|string',
            'lang_device' => 'required|string',
            'active' => 'required|boolean',
        ]);

        // Buscar si ya existe un registro con el mismo fmc_token, platform y lang_device
        $device = DeviceRegister::where('fmc_token', $validated['fmc_token'])
            ->where('platform', $validated['platform'])
            ->where('lang_device', $validated['lang_device'])
            ->first();

        // Si no existe, lo creamos
        if (!$device) {
            $device = DeviceRegister::create($validated);

            return response()->json([
                'message' => 'Dispositivo registrado exitosamente',
                'device' => $device,
            ], 201);
        }

        // Si ya existe, no lo insertamos
        return response()->json([
            'message' => 'Dispositivo ya registrado',
            'device' => $device,
        ], 200);
    }

}
