<?php
namespace Application\Model\Service\ProvidersComplaints;

use Application\Library\Model\Table;
use Laminas\Db\TableGateway\TableGateway;
use Laminas\ServiceManager\ServiceManager;
use Laminas\Db\Sql\Select;

class ProvidersComplaintsTable extends Table
{
    
    /**
     * Constructor
     * @param TableGateway $tableGateway
     * @param ServiceManager $sm
     */
    public function __construct($tableGateway, $sm)
    {
        parent::__construct($tableGateway, $sm);
    }
    
    /**
     * Fetch all data.
     * @param array $params
     * @param \Countable $resultSetPrototype
     * @return \Countable
     */
    public function fetchAll($params = [])
    {
        $select = new Select($this->tableGateway->table);
        $select->columns([
            'frmIdQuejasPrestadores' => 'id',
            'frmIdIdioma' => 'id_idioma',
            'frmBasePath' => null,
            'frmContenidoQuejasPrestadores' => 'contenido',
            'frmActivoQuejasPrestadores' => 'activo'
        ]);
        
        return $this->selectCollection($this->tableGateway, $select, $params);
    }
    
    public function fetch($id)
    {
        $select = new Select($this->tableGateway->table);
        $select->columns([
            'frmIdQuejasPrestadores' => 'id',
            'frmIdIdioma' => 'id_idioma',
            'frmContenidoQuejasPrestadores' => 'contenido',
            'frmActivoQuejasPrestadores' => 'activo'
        ]);
        
        $select->where->equalTo($this->column('id'), $id);
        
        return $this->selectEntity($this->tableGateway, $select);
    }

}