<?php
namespace Application\Model\Service\ClonedCreditCards;

use Application\Library\Model\Table;
use Laminas\Db\TableGateway\TableGateway;
use Laminas\ServiceManager\ServiceManager;
use Laminas\Db\Sql\Select;

class ClonedCreditCardsTable extends Table
{
    
    /**
     * Constructor
     * @param TableGateway $tableGateway
     * @param ServiceManager $sm
     */
    public function __construct($tableGateway, $sm)
    {
        parent::__construct($tableGateway, $sm);
    }
    
    /**
     * Fetch all data.
     * @param array $params
     * @param \Countable $resultSetPrototype
     * @return \Countable
     */
    public function fetchAll($params = [])
    {
        $select = new Select($this->tableGateway->table);
        $select->columns([
            'frmIdTarjetaCreditoClonada' => 'id',
            'frmIdIdioma' => 'id_idioma',
            'frmBasePath' => null,
            'frmContenidoTarjetaCreditoClonada' => 'contenido',
            'frmActivoTarjetaCreditoClonada' => 'activo'
        ]);
        
        return $this->selectCollection($this->tableGateway, $select, $params);
    }
    
    public function fetch($id)
    {
        $select = new Select($this->tableGateway->table);
        $select->columns([
            'frmIdTarjetaCreditoClonada' => 'id',
            'frmIdIdioma' => 'id_idioma',
            'frmContenidoTarjetaCreditoClonada' => 'contenido',
            'frmActivoTarjetaCreditoClonada' => 'activo'
        ]);
        
        $select->where->equalTo($this->column('id'), $id);
        
        return $this->selectEntity($this->tableGateway, $select);
    }

}