<?php
namespace Application\Model\Security\UsersSocialNetworks;

use Application\Library\Complements\MyLogger;
use Application\Library\Model\Table;
use Application\Model\Catalog\Employees\EmployeesTable;
use Laminas\Db\TableGateway\TableGateway;
use Laminas\ServiceManager\ServiceManager;
use Laminas\Db\Sql\Select;
use Laminas\Db\Sql\Insert;
use Laminas\Db\Sql\Delete;
use Application\Model\Security\Menus\MenusTable;
use Application\Model\Security\Users\UsersTable;

class UsersSocialNetworksTable extends Table
{
    /**
     * Constructor
     * @param TableGateway $tableGateway
     * @param ServiceManager $sm
     */
    public function __construct($tableGateway, $sm)
    {
        parent::__construct($tableGateway, $sm);
    }

    /**
     * Fetch all data.
     * @param array $params
     * @return \Application\Library\Model\Result
     */
    public function fetchAll($params = [])
    {
        $select = new Select($this->tableGateway->table);
        $select->columns([
            'frmIdUsuariosRedesSociales' => 'id',
            'frmIdUsuarioUsuariosRedesSociales' => 'id_usuario',
            'frmIdRedSocialUsuariosRedesSociales' => 'id_red_social',
            'frmUidUsuariosRedesSociales' => 'uid',
        ]);
        
        $userTable = $this->sm->get(UsersTable::class);
        $select->join($userTable->tableGateway->table,
            $this->on($this->column('id_usuario'), $userTable->column('id')), [
                'frmIdUsuario' => 'id'
            ]);

        $employeesTable = $this->sm->get(EmployeesTable::class);
        $select->join($employeesTable->tableGateway->table,
            $this->on($userTable->column('id_empleado'), $employeesTable->column('id')), [
                'frmIdEmpleado' => 'id',
                'frmNombreEmpleado' => 'nombre',
                'frmApellidosEmpleado' => 'apellidos'
            ]);
        return $this->selectCollection($this->tableGateway, $select, $params);
    }
    
    /**
     * Returns all privileges of a user.
     * @param int $id
     * @return \Laminas\Db\ResultSet\ResultSetInterface
     */
    public function selectByUserId($id)
    {
        $select = new Select($this->tableGateway->table);
        $select->columns([
            'frmMenuIdUserPrivilege' => 'id_menu'
        ]);
        $select->where->equalTo($this->column('user_id'), $id);
        return $this->tableGateway->selectWith($select);
    }
    
    /**
     * Creates a new resource.
     * @param array $data
     */
    public function insert($data)
    {
        $insert = new Insert($this->tableGateway->table);
        $insert->values([
            'id_usuario_creacion' => 1,
            'id_usuario' => $data['frmIdUsuarioUsuariosRedesSociales'],
            'id_red_social' => $data['frmIdRedSocialUsuariosRedesSociales'],
            'uid' => $data['frmUidUsuariosRedesSociales']
        ]);
        $this->tableGateway->insertWith($insert);
    }
    
    /**
     * Delete all privileges of a user.
     * @param int $id
     */
    public function deleteByUserId($id)
    {
        $delete = new Delete($this->tableGateway->table);
        $delete->where->equalTo($this->column('user_id'), $id);
        $this->tableGateway->deleteWith($delete);
    }

    public function selectByUid($uid){
        $select = new Select($this->tableGateway->table);
        $select->columns([
            'frmIdUsuariosRedesSociales' => 'id',
            'frmIdUsuarioUsuariosRedesSociales' => 'id_usuario',
            'frmIdRedSocialUsuariosRedesSociales' => 'id_red_social',
            'frmUidUsuariosRedesSociales' => 'uid',
        ]);
        $select->where->equalTo($this->column('uid'), $uid);
        return $this->tableGateway->selectWith($select)->current();
    }
    
}