<?php
namespace Application\Model\Security\Tokens;

use Application\Library\Model\Table;
use Laminas\Db\TableGateway\TableGateway;
use Laminas\ServiceManager\ServiceManager;
use Laminas\Db\Sql\Select;

class TokensTable extends Table
{
    /**
     * Constructor
     * @param TableGateway $tableGateway
     * @param ServiceManager $sm
     */
    public function __construct($tableGateway, $sm)
    {
        parent::__construct($tableGateway, $sm);
    }

    /**
     * Fetch a collection.
     * @param array $params
     * @param \Countable $resultSetPrototype
     * @return \Countable
     */
    public function fetchAll($params = [])
    {
        $select = new Select($this->tableGateway->table);
        $select->columns([
            'frmIdToken' => 'id',
            'frmApiKeyToken' => 'apikey',
            'frmNotasToken' => 'notas'
        ]);
                
        return $this->selectCollection($this->tableGateway, $select, $params);
    }
    
    /**
     * Fetch a resource.
     * @param int $id
     * @return \Application\Library\Model\Result
     */
    public function fetch($id)
    {
        $select = new Select($this->tableGateway->table);
        $select->columns([
            'frmIdToken' => 'id',
            'frmApiKeyToken' => 'apikey',
            'frmNotasToken' => 'notas'
        ]);
        
        $select->where->equalTo($this->column('id'), $id);
        
        return $this->selectEntity($this->tableGateway, $select);
    }
    
    /**
     * Fetch a resource.
     * @param int $id
     * @return \Application\Library\Model\Result
     */
    public function fetchByToken($apiKey)
    {
        $select = new Select($this->tableGateway->table);
        $select->columns([
            'frmIdToken' => 'id',
            'frmApiKeyToken' => 'apikey',
            'frmNotasToken' => 'notas'
        ]);
        
        $select->where->equalTo($this->column('apikey'), $apiKey);
        
        return $this->selectEntity($this->tableGateway, $select);
    }
}