<?php
namespace Application\Model\Security\Menus;

use Application\Library\Model\Table;
use Laminas\Db\TableGateway\TableGateway;
use Laminas\ServiceManager\ServiceManager;
use Laminas\Db\Sql\Select;

class MenusTable extends Table
{
    /**
     * Constructor
     * @param TableGateway $tableGateway
     * @param ServiceManager $sm
     */
    public function __construct($tableGateway, $sm)
    {
        parent::__construct($tableGateway, $sm);
    }

    /**
     * Fetch all data.
     * @param array $params
     * @param \Countable $resultSetPrototype
     * @return \Countable
     */
    public function fetchAll($params = [])
    {
        $select = new Select($this->tableGateway->table);
        $select->columns([
            'frmIdMenu' => 'id',
            'frmLabelMenu' => 'etiqueta',
            'frmParentMenu' => 'padre',
            'frmOrderMenu' => 'order',
            'frmVisibleMenu' => 'visible'
        ]);
        
        $select->order($this->asc('parent'));
        $select->order($this->asc('order'));
        
        return $this->selectCollection($this->tableGateway, $select, $params);
    }
    
}