<?php
namespace Application\Model\Report\Traceability;

use Application\Library\Model\Table;
use Laminas\Db\Sql\Insert;
use Laminas\Db\TableGateway\TableGateway;
use Laminas\ServiceManager\ServiceManager;
use Laminas\Db\Sql\Select;

class TraceabilityTable extends Table
{
    
    /**
     * Constructor
     * @param TableGateway $tableGateway
     * @param ServiceManager $sm
     */
    public function __construct($tableGateway, $sm)
    {
        parent::__construct($tableGateway, $sm);
    }
    
    /**
     * Fetch all data.
     * @param array $params
     * @param \Countable $resultSetPrototype
     * @return \Countable
     */
    public function fetchAll($params = [])
    {
        $select = new Select($this->tableGateway->table);
        $select->columns([
            'frmIdTrazabilidad' => 'id',
            'frmFechaCapturaTrazabilidad' => 'fecha',
            'frmHoraCapturaTrazabilidad' => 'hora',
            'frmNombreTuristaTrazabilidad' => 'nombre',
            'frmCorreoElectronicoTrazabilidad' => 'correo',
            'frmFormularioTrazabilidad' => 'formulario',
            'frmEstatusTrazabilidad' => 'estatus',
        ]);
        
//         print_r($select->getSqlString());
//         exit();
        
        return $this->selectCollection($this->tableGateway, $select, $params);
    }
    
    public function create($data)
    {
        try {
            $this->connection->beginTransaction();
                        
            $insert = new Insert($this->tableGateway->table);
            $insert->values([
                'fecha' => date('Y-m-d'),
                'hora' => date('H:i:s'),
                'nombre' => $data['frmNombreTuristaTrazabilidad'],
                'correo' => $data['frmCorreoElectronicoTrazabilidad'],
                'formulario' => $data['frmFormularioTrazabilidad'],
                'estatus' => $data['frmEstatusTrazabilidad']
            ]);
            $id = $this->insertWith($insert);
            
            $this->connection->commit();
            return $id;
        } catch (\Exception $e) {
            $this->connection->rollback();
            throw new \Exception($e->getMessage());
        }
    }

}