<?php
namespace Application\Model\PostalAddress\Neighborhoods;

use Application\Library\Model\Table;
use Laminas\Db\TableGateway\TableGateway;
use Laminas\ServiceManager\ServiceManager;
use Laminas\Db\Sql\Select;
use Laminas\Db\Sql\Join;
use Application\Model\PostalAddress\ZipCodes\ZipCodesTable;
use Application\Model\PostalAddress\States\StatesTable;
use Application\Model\PostalAddress\Municipalities\MunicipalitiesTable;
use Application\Model\PostalAddress\Cities\CitiesTable;

class NeighborhoodsTable extends Table
{
    
    /**
     * Constructor
     * @param TableGateway $tableGateway
     * @param ServiceManager $sm
     */
    public function __construct($tableGateway, $sm)
    {
        parent::__construct($tableGateway, $sm);
    }

    /**
     * Fetch a collection.
     * @param array $params
     * @param \Countable $resultSetPrototype
     * @return \Countable
     */
    public function fetchAll($params = [])
    {
        $select = new Select($this->tableGateway->table);
        $select->columns([
            'frmIdColonia' => 'id',
            'frmNombreColonia' => 'nombre'
        ]);
        
        $zipCodesTable = $this->sm->get(ZipCodesTable::class);
        $select->join($zipCodesTable->tableGateway->table,
            $this->on($this->column('id_codigo_postal'), $zipCodesTable->column('id')), [
                'frmNombreCodigoPostal' => 'nombre'
            ]);
        
        $statesTable = $this->sm->get(StatesTable::class);
        $select->join($statesTable->tableGateway->table,
            $this->on($zipCodesTable->column('id_estado'), $statesTable->column('id')), [
                'frmNameState' => 'nombre'
            ], Join::JOIN_LEFT);
        
        $municipalitiesTable = $this->sm->get(MunicipalitiesTable::class);
        $select->join($municipalitiesTable->tableGateway->table,
            $this->on($zipCodesTable->column('id_municipio'), $municipalitiesTable->column('id')), [
                'frmNameMunicipality' => 'nombre'
            ], Join::JOIN_LEFT);
        
        $citiesTable = $this->sm->get(CitiesTable::class);
        $select->join($citiesTable->tableGateway->table,
            $this->on($zipCodesTable->column('id_ciudad'), $citiesTable->column('id')), [
                'frmNameCity' => 'nombre'
            ], Join::JOIN_LEFT);
        
        $select->order($this->asc('nombre'));
        
        return $this->selectCollection($this->tableGateway, $select, $params);
    }
    
}