<?php
namespace Application\Model\Notice\TravelTips;

use Application\Library\Model\Table;
use Laminas\Db\TableGateway\TableGateway;
use Laminas\ServiceManager\ServiceManager;
use Laminas\Db\Sql\Select;

class TravelTipsTable extends Table
{
    
    /**
     * Constructor
     * @param TableGateway $tableGateway
     * @param ServiceManager $sm
     */
    public function __construct($tableGateway, $sm)
    {
        parent::__construct($tableGateway, $sm);
    }
    
    /**
     * Fetch all data.
     * @param array $params
     * @param \Countable $resultSetPrototype
     * @return \Countable
     */
    public function fetchAll($params = [])
    {
        $select = new Select($this->tableGateway->table);
        $select->columns([
            'frmIdRecomendaciones' => 'id',
            'frmIdIdioma' => 'id_idioma',
            'frmBasePath' => null,
            'frmContenidoRecomendaciones' => 'contenido',
            'frmActivoRecomendaciones' => 'activo'
        ]);
        
        return $this->selectCollection($this->tableGateway, $select, $params);
    }
    
    /**
     * Fetch a resource.
     * @param int $id
     * @return \Application\Library\Model\Result
     */
    public function fetch($id)
    {
        $select = new Select($this->tableGateway->table);
        $select->columns([
            'frmIdRecomendaciones' => 'id',
            'frmIdIdioma' => 'id_idioma',
            'frmContenidoRecomendaciones' => 'contenido',
            'frmActivoRecomendaciones' => 'activo'
        ]);
        
        $select->where->equalTo($this->column('id'), $id);
        
        return $this->selectEntity($this->tableGateway, $select);
    }

}