<?php
namespace Application\Model\Notice\TermsCoditions;

use Application\Library\Model\Table;
use Laminas\Db\TableGateway\TableGateway;
use Laminas\ServiceManager\ServiceManager;
use Laminas\Db\Sql\Select;

class TermsCoditionsTable extends Table
{
    
    /**
     * Constructor
     * @param TableGateway $tableGateway
     * @param ServiceManager $sm
     */
    public function __construct($tableGateway, $sm)
    {
        parent::__construct($tableGateway, $sm);
    }
    
    /**
     * Fetch all data.
     * @param array $params
     * @param \Countable $resultSetPrototype
     * @return \Countable
     */
    public function fetchAll($params = [])
    {
        $select = new Select($this->tableGateway->table);
        $select->columns([
            'frmIdTerminosCondiciones' => 'id',
            'frmIdIdioma' => 'id_idioma',
            'frmContenidoTerminosCondiciones' => 'contenido',
            'frmActivoTerminosCondiciones' => 'activo'
        ]);
        
        return $this->selectCollection($this->tableGateway, $select, $params);
    }
    
    /**
     * Fetch a resource.
     * @param int $id
     * @return \Application\Library\Model\Result
     */
    public function fetch($id)
    {
        $select = new Select($this->tableGateway->table);
        $select->columns([
            'frmIdTerminosCondiciones' => 'id',
            'frmIdIdioma' => 'id_idioma',
            'frmContenidoTerminosCondiciones' => 'contenido',
            'frmActivoTerminosCondiciones' => 'activo'
        ]);
        
        $select->where->equalTo($this->column('id'), $id);
        
        return $this->selectEntity($this->tableGateway, $select);
    }

}