<?php
namespace Application\Model\Home\Shortcuts;

use Application\Library\Model\Table;
use Laminas\Db\TableGateway\TableGateway;
use Laminas\ServiceManager\ServiceManager;
use Laminas\Db\Sql\Select;

class ShortcutsTable extends Table
{
    
    /**
     * Constructor
     * @param TableGateway $tableGateway
     * @param ServiceManager $sm
     */
    public function __construct($tableGateway, $sm)
    {
        parent::__construct($tableGateway, $sm);
    }
    
    /**
     * Fetch all data.
     * @param array $params
     * @param \Countable $resultSetPrototype
     * @return \Countable
     */
    public function fetchAll($params = [])
    {
        $select = new Select($this->tableGateway->table);
        $select->columns([
            'frmIdShortcuts' => 'id',
            'frmEtiquetaShortcuts' => 'etiqueta',
            'frmIconoShortcuts' => 'icono',
            'frmUrlShortcuts' => 'url',
            'frmOrdenShortcuts' => 'orden',
            'frmI18nShortcuts' => 'i18n',
            'frmVisibleShortcuts' => 'visible'
        ]);
        
        $select->where->equalTo($this->column('visible'), '1');
        
        return $this->selectCollection($this->tableGateway, $select, $params);
    }
    
    public function fetch($id)
    {
        $select = new Select($this->tableGateway->table);
        $select->columns([
            'frmIdShortcuts' => 'id',
            'frmEtiquetaShortcuts' => 'etiqueta',
            'frmIconoShortcuts' => 'icono',
            'frmUrlShortcuts' => 'url',
            'frmOrdenShortcuts' => 'orden',
            'frmI18nShortcuts' => 'i18n',
            'frmVisibleShortcuts' => 'visible'
        ]);
        
        $select->where->equalTo($this->column('id'), $id);
        
        return $this->selectEntity($this->tableGateway, $select);
    }

}