<?php
namespace Application\Model\Home\MenuPublic;

use Application\Library\Model\Table;
use Laminas\Db\TableGateway\TableGateway;
use Laminas\ServiceManager\ServiceManager;
use Laminas\Db\Sql\Select;

class MenuPublicTable extends Table
{
    
    /**
     * Constructor
     * @param TableGateway $tableGateway
     * @param ServiceManager $sm
     */
    public function __construct($tableGateway, $sm)
    {
        parent::__construct($tableGateway, $sm);
    }
    
    /**
     * Fetch all data.
     * @param array $params
     * @param \Countable $resultSetPrototype
     * @return \Countable
     */
    public function fetchAll($params = [])
    {
        $select = new Select($this->tableGateway->table);
        $select->columns([
            'frmIdMenuPublico' => 'id',
            'frmEtiquetaMenuPublico' => 'etiqueta',
            'frmPadreMenuPublico' => 'padre',
            'frmIconoMenuPublico' => 'icono',
            'frmUrlMenuPublico' => 'url',
            'frmOperacionMenuPublico' => 'operacion',
            'frmOrdenMenuPublico' => 'orden',
            'frmI18nMenuPublico' => 'i18n',
            'frmVisibleMenuPublico' => 'visible'
        ]);
        
        return $this->selectCollection($this->tableGateway, $select, $params);
    }
    
    public function fetch($id)
    {
        $select = new Select($this->tableGateway->table);
        $select->columns([
            'frmIdMenuPublic' => 'id',
            'frmEtiquetaMenuPublic' => 'etiqueta',
            'frmIconoMenuPublic' => 'icono',
            'frmUrlMenuPublic' => 'url',
            'frmOrdenMenuPublic' => 'orden',
            'frmI18nMenuPublic' => 'i18n',
            'frmVisibleMenuPublic' => 'visible'
        ]);
        
        $select->where->equalTo($this->column('id'), $id);
        
        return $this->selectEntity($this->tableGateway, $select);
    }

}