<?php
namespace Application\Model\Home\Labels;

use Application\Library\Model\Table;
use Laminas\Db\TableGateway\TableGateway;
use Laminas\ServiceManager\ServiceManager;
use Laminas\Db\Sql\Select;

class LabelsTable extends Table
{
    
    /**
     * Constructor
     * @param TableGateway $tableGateway
     * @param ServiceManager $sm
     */
    public function __construct($tableGateway, $sm)
    {
        parent::__construct($tableGateway, $sm);
    }
    
    /**
     * Fetch all data.
     * @param array $params
     * @param \Countable $resultSetPrototype
     * @return \Countable
     */
    public function fetchAll($params = [])
    {
        $select = new Select($this->tableGateway->table);
        $select->columns([
            'frmIdLabel' => 'id',
            'frmEtiquetaLabel' => 'etiqueta',
            'frmI18nLabel' => 'i18n',
            'frmVisibleLabel' => 'visible'
        ]);
        
        return $this->selectCollection($this->tableGateway, $select, $params);
    }
    
    public function fetch($id)
    {
        $select = new Select($this->tableGateway->table);
        $select->columns([
            'frmIdLabel' => 'id',
            'frmEtiquetaLabel' => 'etiqueta',
            'frmI18nLabel' => 'i18n',
            'frmVisibleLabel' => 'visible'
        ]);
        
        $select->where->equalTo($this->column('etiqueta'), $id);
        
        return $this->selectEntity($this->tableGateway, $select);
    }

}