<?php
namespace Application\Model\Emergency\AnonymousComplaints;

use Application\Library\Model\Table;
use Laminas\Db\TableGateway\TableGateway;
use Laminas\ServiceManager\ServiceManager;
use Laminas\Db\Sql\Select;

class AnonymousComplaintsTable extends Table
{
    
    /**
     * Constructor
     * @param TableGateway $tableGateway
     * @param ServiceManager $sm
     */
    public function __construct($tableGateway, $sm)
    {
        parent::__construct($tableGateway, $sm);
    }
    
    /**
     * Fetch all data.
     * @param array $params
     * @param \Countable $resultSetPrototype
     * @return \Countable
     */
    public function fetchAll($params = [])
    {
        $select = new Select($this->tableGateway->table);
        $select->columns([
            'frmIdDenunciaAnonima' => 'id',
            'frmIdIdioma' => 'id_idioma',
            'frmContenidoDenunciaAnonima' => 'contenido',
            'frmActivoDenunciaAnonima' => 'activo'
        ]);
        
        return $this->selectCollection($this->tableGateway, $select, $params);
    }
    
    public function fetch($id)
    {
        $select = new Select($this->tableGateway->table);
        $select->columns([
            'frmIdDenunciaAnonima' => 'id',
            'frmIdIdioma' => 'id_idioma',
            'frmContenidoDenunciaAnonima' => 'contenido',
            'frmActivoDenunciaAnonima' => 'activo'
        ]);
        
        $select->where->equalTo($this->column('id'), $id);
        
        return $this->selectEntity($this->tableGateway, $select);
    }

}