<?php
namespace Application\Model\Config\JobPositionsCommittees;

use Application\Library\Model\Table;
use Laminas\Db\TableGateway\TableGateway;
use Laminas\ServiceManager\ServiceManager;
use Laminas\Db\Sql\Select;
use Laminas\Db\Sql\Join;
use Application\Model\Catalog\JobPositions\JobPositionsTable;

class JobPositionsCommitteesTable extends Table
{
    
    /**
     * Constructor
     * @param TableGateway $tableGateway
     * @param ServiceManager $sm
     */
    public function __construct($tableGateway, $sm)
    {
        parent::__construct($tableGateway, $sm);
    }

    /**
     * Fetch all data.
     * @param array $params
     * @param \Countable $resultSetPrototype
     * @return \Countable
     */
    public function fetchAll($params = [])
    {
        $select = new Select($this->tableGateway->table);
        $select->columns([]);
        
        $jobPositionsTable = $this->sm->get(JobPositionsTable::class);
        $select->join($jobPositionsTable->tableGateway->table,
            $this->on($this->column('job_position_id'), $jobPositionsTable->column('id')), [
                'frmIdJobPosition' => 'id',
                'frmTitleJobPosition' => 'title'
            ]);
        
        $select->order($jobPositionsTable->asc('title'));
        
        return $this->selectCollection($this->tableGateway, $select, $params);
    }
    
}