<?php
namespace Application\Model\Catalog\Languages;

use Application\Library\Model\Table;
use Laminas\Db\TableGateway\TableGateway;
use Laminas\ServiceManager\ServiceManager;
use Laminas\Db\Sql\Select;
use Laminas\Db\Sql\Join;
use Application\Model\Security\Users\UsersTable;
use Application\Model\PostalAddress\Neighborhoods\NeighborhoodsTable;
use Application\Model\PostalAddress\ZipCodes\ZipCodesTable;
use Laminas\Db\Sql\Update;
use Laminas\Db\Sql\Insert;
use Laminas\Db\Sql\Expression;

class LanguagesTable extends Table
{
    /**
     * Constructor
     * @param TableGateway $tableGateway
     * @param ServiceManager $sm
     */
    public function __construct($tableGateway, $sm)
    {
        parent::__construct($tableGateway, $sm);
    }
    
    /**
     * Fetch all data.
     * @param array $params
     * @param \Countable $resultSetPrototype
     * @return \Countable
     */
    public function fetchAll($params = [])
    {
        $select = new Select($this->tableGateway->table);
        $select->columns([
            'frmIdIdioma' => 'id',
            'frmNombreIdioma' => 'nombre',
            'frmActivoIdioma' => 'activo' ,
            'frmCodigoIdioma' => 'codigo'
        ]);

        $select->order($this->asc('id'));
        
        return $this->selectCollection($this->tableGateway, $select, $params);
    }
    
}