<?php
namespace Application\Model\Catalog\Hospitals;

use Application\Library\Model\Table;
use Laminas\Db\TableGateway\TableGateway;
use Laminas\ServiceManager\ServiceManager;
use Laminas\Db\Sql\Select;
use Laminas\Db\Sql\Join;
use Application\Model\Security\Users\UsersTable;
use Application\Model\PostalAddress\Neighborhoods\NeighborhoodsTable;
use Application\Model\PostalAddress\ZipCodes\ZipCodesTable;
use Laminas\Db\Sql\Update;
use Laminas\Db\Sql\Insert;
use Laminas\Db\Sql\Expression;

class HospitalsTable extends Table
{
    /**
     * Constructor
     * @param TableGateway $tableGateway
     * @param ServiceManager $sm
     */
    public function __construct($tableGateway, $sm)
    {
        parent::__construct($tableGateway, $sm);
    }
    
    /**
     * Fetch all data.
     * @param array $params
     * @param \Countable $resultSetPrototype
     * @return \Countable
     */
    public function fetchAll($params = [])
    {
        $select = new Select($this->tableGateway->table);
        $select->columns([
            'frmIdHospital' => 'id_hospital',
            'frmIdIdioma' => 'id_idioma',
            'frmNombreHospital' => 'nombre',
            'frmDireccionHospital' => 'direccion',
            'frmTelefonoHospital' => 'telefono' ,
            'frmLatitudHospital' => 'latitud' ,
            'frmLongitudHospital' => 'longitud' ,
            'frmActivoHospital' => 'activo' 
        ]);

        $select->order($this->asc('id'));
        
        return $this->selectCollection($this->tableGateway, $select, $params);
    }

    /**
     * Fetch a resource.
     * @param int $id
     * @return \Application\Library\Model\Result
     */
    public function fetch($id, $params = [])
    {
        $select = new Select($this->tableGateway->table);
        $select->columns([
            'frmIdHospital' => 'id_hospital',
            'frmIdIdioma' => 'id_idioma',
            'frmNombreHospital' => 'nombre',
            'frmDireccionHospital' => 'direccion',
            'frmTelefonoHospital' => 'telefono' ,
            'frmLatitudHospital' => 'latitud' ,
            'frmLongitudHospital' => 'longitud' ,
            'frmActivoHospital' => 'activo' 
        ]);
        
        $select->where->equalTo($this->column('id_hospital'), $id);

        return $this->selectCollection($this->tableGateway, $select, $params);
    }
    
}