<?php
namespace Application\Model\Catalog\ConsulatesEmbassies;

use Application\Library\Complements\MyLogger;
use Application\Library\Model\Table;
use Laminas\Db\TableGateway\TableGateway;
use Laminas\ServiceManager\ServiceManager;
use Laminas\Db\Sql\Select;
use Laminas\Db\Sql\Join;
use Application\Model\Security\Users\UsersTable;
use Application\Model\PostalAddress\Neighborhoods\NeighborhoodsTable;
use Application\Model\PostalAddress\ZipCodes\ZipCodesTable;
use Laminas\Db\Sql\Update;
use Laminas\Db\Sql\Insert;
use Laminas\Db\Sql\Expression;

class ConsulatesEmbassiesTable extends Table
{
    /**
     * Constructor
     * @param TableGateway $tableGateway
     * @param ServiceManager $sm
     */
    public function __construct($tableGateway, $sm)
    {
        parent::__construct($tableGateway, $sm);
    }
    
    /**
     * Fetch all data.
     * @param array $params
     * @param \Countable $resultSetPrototype
     * @return \Countable
     */
    public function fetchAll($params = [])
    {
        $select = new Select($this->tableGateway->table);
        $select->columns([
            'frmIdConsuladoEmbajada' => 'id',
            'frmIdIdioma' => 'id_idioma',
            'frmNombreConsuladoEmbajada' => 'nombre',
            'frmJurisdiccionConsuladoEmbajada' => 'jurisdiccion',
            'frmDireccionConsuladoEmbajada' => 'direccion',
            'frmHorarioConsuladoEmbajada' => 'horario',
            'frmCorreoConsuladoEmbajada' => 'correo' ,
            'frmWebsiteConsuladoEmbajada' => 'website' ,
            'frmTelefonoConsuladoEmbajada' => 'telefono' ,
            'frmTelefonoEmergenciaConsuladoEmbajada' => 'telefono_emergencia' ,
            'frmLatitudConsuladoEmbajada' => 'latitud' ,
            'frmLongitudConsuladoEmbajada' => 'longitud' ,
            'frmBanderaConsuladoEmbajada' => 'bandera' ,
            'frmActivoConsuladoEmbajada' => 'activo' 
        ]);

        $select->order($this->asc('nombre'));
        
        return $this->selectCollection($this->tableGateway, $select, $params);
    }
    
    /**
     * Fetch all data.
     * @param array $params
     * @param \Countable $resultSetPrototype
     * @return \Countable
     */
    public function fetchAllPais($params = [])
    {
        $select = new Select($this->tableGateway->table);
        $select->columns([
            'frmIdPaisConsuladoEmbajada' => new Expression('DISTINCT id_pais'),
            'frmNombreConsuladoEmbajada' => 'nombre',
            'frmBanderaConsuladoEmbajada' => 'bandera' ,
            'frmIdIdioma' => 'id_idioma',
        ]);

        $select->order($this->asc('nombre'));
        
        return $this->selectCollection($this->tableGateway, $select, $params);
    }

    /**
     * Fetch a resource.
     * @param int $id
     * @return \Application\Library\Model\Result
     */
    public function fetch($id, $params = [])
    {
        $select = new Select($this->tableGateway->table);
        $select->columns([
            'frmIdConsuladoEmbajada' => 'id',
            'frmIdIdioma' => 'id_idioma',
            'frmIdPaisConsuladoEmbajada' => 'id_pais',
            'frmNombreConsuladoEmbajada' => 'nombre',
            'frmJurisdiccionConsuladoEmbajada' => 'jurisdiccion',
            'frmDireccionConsuladoEmbajada' => 'direccion',
            'frmHorarioConsuladoEmbajada' => 'horario',
            'frmCorreoConsuladoEmbajada' => 'correo' ,
            'frmWebsiteConsuladoEmbajada' => 'website' ,
            'frmTelefonoConsuladoEmbajada' => 'telefono' ,
            'frmTelefonoEmergenciaConsuladoEmbajada' => 'telefono_emergencia' ,
            'frmLatitudConsuladoEmbajada' => 'latitud' ,
            'frmLongitudConsuladoEmbajada' => 'longitud' ,
            'frmBanderaConsuladoEmbajada' => 'bandera' ,
            'frmActivoConsuladoEmbajada' => 'activo' 
        ]);
        
        $select->where->equalTo($this->column('id_pais'), $id);

        return $this->selectCollection($this->tableGateway, $select, $params);
    }
    
}