<?php
declare(strict_types = 1);
namespace Application;

use Laminas\ServiceManager\Factory\InvokableFactory;
use Laminas\Db\ResultSet\ResultSet;
use Laminas\Db\Sql\TableIdentifier;
use Laminas\Db\TableGateway\TableGateway;
use Laminas\Db\Adapter\Adapter;
use Application\Model\Security\Logs\LogsTable;
use Application\Model\Security\Logs\Log;
use Application\Model\Security\Menus\MenusTable;
use Application\Model\Security\Menus\Menu;
use Application\Model\PostalAddress\Municipalities\MunicipalitiesTable;
use Application\Model\PostalAddress\Municipalities\Municipality;
use Application\Model\Security\Profiles\ProfilesTable;
use Application\Model\Security\Profiles\Profile;
use Application\Model\Security\ProfilesPrivileges\ProfilesPrivilegesTable;
use Application\Model\Security\ProfilesPrivileges\ProfilePrivilege;
use Application\Model\PostalAddress\States\StatesTable;
use Application\Model\PostalAddress\States\State;
use Application\Model\Security\Users\UsersTable;
use Application\Model\Security\Users\User;
use Application\Model\Security\UsersPrivileges\UsersPrivilegesTable;
use Application\Model\Security\UsersPrivileges\UserPrivilege;
use Application\Model\PostalAddress\Neighborhoods\NeighborhoodsTable;
use Application\Model\PostalAddress\Neighborhoods\Neighborhood;
use Application\Model\PostalAddress\ZipCodes\ZipCodesTable;
use Application\Model\PostalAddress\ZipCodes\ZipCode;
use Application\Model\Catalog\JobPositions\JobPositionsTable;
use Application\Model\Catalog\JobPositions\JobPosition;
use Application\Model\PostalAddress\Cities\CitiesTable;
use Application\Model\PostalAddress\Cities\City;
use Application\Library\Storage\Storage;
use Application\Model\Catalog\ConsulatesEmbassies\ConsulatesEmbassies;
use Application\Model\Catalog\ConsulatesEmbassies\ConsulatesEmbassiesTable;
use Application\Model\Security\Tokens\TokensTable;
use Application\Model\Security\Tokens\Token;
use Application\Model\Catalog\Employees\EmployeesTable;
use Application\Model\Catalog\Employees\Employee;
use Application\Model\Catalog\Genders\Genders;
use Application\Model\Catalog\Genders\GendersTable;
use Application\Model\Catalog\Hospitals\Hospitals;
use Application\Model\Catalog\Hospitals\HospitalsTable;
use Application\Model\Catalog\Languages\Language;
use Application\Model\Catalog\Languages\LanguagesTable;
use Application\Model\Catalog\Nationalities\Nationalities;
use Application\Model\Catalog\Nationalities\NationalitiesTable;
use Application\Model\Catalog\Prosecutors\Prosecutors;
use Application\Model\Catalog\Prosecutors\ProsecutorsTable;
use Application\Model\Catalog\ReasonsComplaint\ReasonComplaint;
use Application\Model\Catalog\ReasonsComplaint\ReasonsComplaintTable;
use Application\Model\Catalog\ServiceProviders\ServiceProvider;
use Application\Model\Catalog\ServiceProviders\ServiceProvidersTable;
use Application\Model\Catalog\TouristicDestinations\TouristicDestination;
use Application\Model\Catalog\TouristicDestinations\TouristicDestinationsTable;
use Application\Model\Catalog\UsersData\UserData;
use Application\Model\Catalog\UsersData\UsersDataTable;
use Application\Model\Covid\CallCenter\CallCenter;
use Application\Model\Covid\CallCenter\CallCenterTable;
use Application\Model\Covid\CovidTests\CovidTests;
use Application\Model\Covid\CovidTests\CovidTestsTable;
use Application\Model\Covid\General\GeneralTable as GeneralGeneralTable;
use Application\Model\Covid\GeneralCovid\GeneralCovid;
use Application\Model\Covid\GeneralCovid\GeneralCovidTable;
use Application\Model\Covid\PreventiveMeasures\PreventiveMeasures;
use Application\Model\Covid\PreventiveMeasures\PreventiveMeasuresTable;
use Application\Model\Covid\SanitaryCertification\SanitaryCertification;
use Application\Model\Covid\SanitaryCertification\SanitaryCertificationTable;
use Application\Model\Notice\About\AboutTable;
use Application\Model\Notice\About\About;
use Application\Model\Notice\TravelTips\TravelTipsTable;
use Application\Model\Notice\TravelTips\TravelTip;
use Application\Model\Notice\PrivacyNotices\PrivacyNoticesTable;
use Application\Model\Notice\PrivacyNotices\PrivacyNotice;
use Application\Model\Notice\TermsCoditions\TermsCoditionsTable;
use Application\Model\Notice\TermsCoditions\TermsCodition;
use Application\Model\Service\LossPassports\LossPassportsTable;
use Application\Model\Service\LossPassports\LossPassport;
use Application\Model\Service\ProvidersComplaints\ProvidersComplaintsTable;
use Application\Model\Service\ProvidersComplaints\ProvidersComplaint;
use Application\Model\Service\ComplaintsCyberFrauds\ComplaintsCyberFraudsTable;
use Application\Model\Service\ComplaintsCyberFrauds\ComplaintsCyberFraud;
use Application\Model\Service\ReportsTheftIncidents\ReportsTheftIncidentsTable;
use Application\Model\Service\ReportsTheftIncidents\ReportsTheftIncident;
use Application\Model\Service\ClonedCreditCards\ClonedCreditCardsTable;
use Application\Model\Service\ClonedCreditCards\ClonedCreditCard;
use Application\Model\Service\LegalAdvice\LegalAdviceTable;
use Application\Model\Service\LegalAdvice\LegalAdvice;
use Application\Model\Service\MedicalAssistance\MedicalAssistanceTable;
use Application\Model\Service\MedicalAssistance\MedicalAssistance;
use Application\Model\Emergency\General\GeneralTable;
use Application\Model\Emergency\General\General;
use Application\Model\Emergency\FederalPolice\FederalPoliceTable;
use Application\Model\Emergency\FederalPolice\FederalPolice;
use Application\Model\Emergency\AnonymousComplaints\AnonymousComplaintsTable;
use Application\Model\Emergency\AnonymousComplaints\AnonymousComplaint;
use Application\Model\Emergency\RoadAssistance\RoadAssistanceTable;
use Application\Model\Emergency\RoadAssistance\RoadAssistance;
use Application\Model\Home\Banner\Banner;
use Application\Model\Home\Banner\BannerTable;
use Application\Model\Home\ConsulatesAndEmbasiesTitle\ConsulatesAndEmbasiesTitle;
use Application\Model\Home\ConsulatesAndEmbasiesTitle\ConsulatesAndEmbasiesTitleTable;
use Application\Model\Home\Footer\Footer;
use Application\Model\Home\Footer\FooterTable;
use Application\Model\Home\HomePage\HomePage;
use Application\Model\Home\HomePage\HomePageTable;
use Application\Model\Home\HospitalsTitle\HospitalsTitle;
use Application\Model\Home\HospitalsTitle\HospitalsTitleTable;
use Application\Model\Home\Labels\Label;
use Application\Model\Home\Labels\LabelsTable;
use Application\Model\Home\MenuPublic\MenuPublic;
use Application\Model\Home\MenuPublic\MenuPublicTable;
use Application\Model\Home\ProsecutorsTitle\ProsecutorsTitle;
use Application\Model\Home\ProsecutorsTitle\ProsecutorsTitleTable;
use Application\Model\Home\Shortcuts\Shortcuts;
use Application\Model\Home\Shortcuts\ShortcutsTable;
use Application\Model\Report\Traceability\Traceability;
use Application\Model\Report\Traceability\TraceabilityTable;
use Application\Model\Security\UsersSocialNetworks\UsersSocialNetwork;
use Application\Model\Security\UsersSocialNetworks\UsersSocialNetworksTable;
use Application\Model\Service\SedeturComplaintsForm\SedeturComplaintsForm;
use Application\Model\Service\SedeturComplaintsForm\SedeturComplaintsFormTable;

return [
    'router' => [
        'routes' => [
            'home' => [
                'type' => 'Literal',
                'options' => [
                    'route' => '/',
                    'defaults' => [
                        'controller' => Controller\IndexController::class,
                        'action' => 'index'
                    ]
                ]
            ]
        ]
    ],
    'controllers' => [
        'factories' => [
            Controller\IndexController::class => InvokableFactory::class
        ]
    ],
    'view_manager' => [
        'display_not_found_reason' => true,
        'display_exceptions' => true,
        'doctype' => 'HTML5',
        'not_found_template' => 'error/404',
        'exception_template' => 'error/index',
        'template_map' => [
            'layout/layout' => __DIR__ . '/../view/layout/layout.phtml',
            'application/index/index' => __DIR__ . '/../view/application/index/index.phtml',
            'error/404' => __DIR__ . '/../view/error/404.phtml',
            'error/index' => __DIR__ . '/../view/error/index.phtml'
        ],
        'template_path_stack' => [
            __DIR__ . '/../view'
        ]
    ],
    'service_manager' => [
        'factories' => [
            Storage::class => function ($sm) {
                return new Storage($sm);
            },
            CitiesTable::class => function ($sm) {
                $resultSetPrototype = new ResultSet(ResultSet::TYPE_ARRAYOBJECT, new City());
                $tableIdentifier = new TableIdentifier('sepomex_ciudades',$_SESSION['db']['database']);
                $tableGateway = new TableGateway($tableIdentifier, $sm->get(Adapter::class), null, $resultSetPrototype);
                return new CitiesTable($tableGateway, $sm);
            },
            EmployeesTable::class => function ($sm) {
                $resultSetPrototype = new ResultSet(ResultSet::TYPE_ARRAYOBJECT, new Employee());
                $tableIdentifier = new TableIdentifier('catalogo_empleados',$_SESSION['db']['database']);
                $tableGateway = new TableGateway($tableIdentifier, $sm->get(Adapter::class), null, $resultSetPrototype);
                return new EmployeesTable($tableGateway, $sm);
            },
            JobPositionsTable::class => function ($sm) {
                $resultSetPrototype = new ResultSet(ResultSet::TYPE_ARRAYOBJECT, new JobPosition());
                $tableIdentifier = new TableIdentifier('catalogo_puestos',$_SESSION['db']['database']);
                $tableGateway = new TableGateway($tableIdentifier, $sm->get(Adapter::class), null, $resultSetPrototype);
                return new JobPositionsTable($tableGateway, $sm);
            },
            LogsTable::class => function ($sm) {
                $resultSetPrototype = new ResultSet(ResultSet::TYPE_ARRAYOBJECT, new Log());
                $tableIdentifier = new TableIdentifier('seguridad_logs',$_SESSION['db']['database']);
                $tableGateway = new TableGateway($tableIdentifier, $sm->get(Adapter::class), null, $resultSetPrototype);
                return new LogsTable($tableGateway, $sm);
            },
            MenusTable::class => function ($sm) {
                $resultSetPrototype = new ResultSet(ResultSet::TYPE_ARRAYOBJECT, new Menu());
                $tableIdentifier = new TableIdentifier('seguridad_menus',$_SESSION['db']['database']);
                $tableGateway = new TableGateway($tableIdentifier, $sm->get(Adapter::class), null, $resultSetPrototype);
                return new MenusTable($tableGateway, $sm);
            },
            MunicipalitiesTable::class => function ($sm) {
                $resultSetPrototype = new ResultSet(ResultSet::TYPE_ARRAYOBJECT, new Municipality());
                $tableIdentifier = new TableIdentifier('sepomex_municipios',$_SESSION['db']['database']);
                $tableGateway = new TableGateway($tableIdentifier, $sm->get(Adapter::class), null, $resultSetPrototype);
                return new MunicipalitiesTable($tableGateway, $sm);
            },
            NeighborhoodsTable::class => function ($sm) {
                $resultSetPrototype = new ResultSet(ResultSet::TYPE_ARRAYOBJECT, new Neighborhood());
                $tableIdentifier = new TableIdentifier('sepomex_colonias',$_SESSION['db']['database']);
                $tableGateway = new TableGateway($tableIdentifier, $sm->get(Adapter::class), null, $resultSetPrototype);
                return new NeighborhoodsTable($tableGateway, $sm);
            },
            ProfilesTable::class => function ($sm) {
                $resultSetPrototype = new ResultSet(ResultSet::TYPE_ARRAYOBJECT, new Profile());
                $tableIdentifier = new TableIdentifier('seguridad_perfiles',$_SESSION['db']['database']);
                $tableGateway = new TableGateway($tableIdentifier, $sm->get(Adapter::class), null, $resultSetPrototype);
                return new ProfilesTable($tableGateway, $sm);
            },
            ProfilesPrivilegesTable::class => function ($sm) {
                $resultSetPrototype = new ResultSet(ResultSet::TYPE_ARRAYOBJECT, new ProfilePrivilege());
                $tableIdentifier = new TableIdentifier('seguridad_perfiles_privilegios',$_SESSION['db']['database']);
                $tableGateway = new TableGateway($tableIdentifier, $sm->get(Adapter::class), null, $resultSetPrototype);
                return new ProfilesPrivilegesTable($tableGateway, $sm);
            },
            StatesTable::class => function ($sm) {
                $resultSetPrototype = new ResultSet(ResultSet::TYPE_ARRAYOBJECT, new State());
                $tableIdentifier = new TableIdentifier('sepomex_estados',$_SESSION['db']['database']);
                $tableGateway = new TableGateway($tableIdentifier, $sm->get(Adapter::class), null, $resultSetPrototype);
                return new StatesTable($tableGateway, $sm);
            },
            UsersTable::class => function ($sm) {
                $resultSetPrototype = new ResultSet(ResultSet::TYPE_ARRAYOBJECT, new User());
                $tableIdentifier = new TableIdentifier('seguridad_usuarios',$_SESSION['db']['database']);
                $tableGateway = new TableGateway($tableIdentifier, $sm->get(Adapter::class), null, $resultSetPrototype);
                return new UsersTable($tableGateway, $sm);
            },
            UsersPrivilegesTable::class => function ($sm) {
                $resultSetPrototype = new ResultSet(ResultSet::TYPE_ARRAYOBJECT, new UserPrivilege());
                $tableIdentifier = new TableIdentifier('seguridad_usuarios_privilegios',$_SESSION['db']['database']);
                $tableGateway = new TableGateway($tableIdentifier, $sm->get(Adapter::class), null, $resultSetPrototype);
                return new UsersPrivilegesTable($tableGateway, $sm);
            },
            ZipCodesTable::class => function ($sm) {
                $resultSetPrototype = new ResultSet(ResultSet::TYPE_ARRAYOBJECT, new ZipCode());
                $tableIdentifier = new TableIdentifier('sepomex_codigos_postales',$_SESSION['db']['database']);
                $tableGateway = new TableGateway($tableIdentifier, $sm->get(Adapter::class), null, $resultSetPrototype);
                return new ZipCodesTable($tableGateway, $sm);
            },
            TokensTable::class => function ($sm) {
                $resultSetPrototype = new ResultSet(ResultSet::TYPE_ARRAYOBJECT, new Token());
                $tableIdentifier = new TableIdentifier('seguridad_tokens',$_SESSION['db']['database']);
                $tableGateway = new TableGateway($tableIdentifier, $sm->get(Adapter::class), null, $resultSetPrototype);
                return new TokensTable($tableGateway, $sm);
            },
            AboutTable::class => function ($sm) {
                $resultSetPrototype = new ResultSet(ResultSet::TYPE_ARRAYOBJECT, new About());
                $tableIdentifier = new TableIdentifier('aviso_acerca_nosotros',$_SESSION['db']['database']);
                $tableGateway = new TableGateway($tableIdentifier, $sm->get(Adapter::class), null, $resultSetPrototype);
                return new AboutTable($tableGateway, $sm);
            },
            TravelTipsTable::class => function ($sm) {
                $resultSetPrototype = new ResultSet(ResultSet::TYPE_ARRAYOBJECT, new TravelTip());
                $tableIdentifier = new TableIdentifier('aviso_recomendaciones_viajes',$_SESSION['db']['database']);
                $tableGateway = new TableGateway($tableIdentifier, $sm->get(Adapter::class), null, $resultSetPrototype);
                return new TravelTipsTable($tableGateway, $sm);
            },
            PrivacyNoticesTable::class => function ($sm) {
                $resultSetPrototype = new ResultSet(ResultSet::TYPE_ARRAYOBJECT, new PrivacyNotice());
                $tableIdentifier = new TableIdentifier('aviso_aviso_privacidad',$_SESSION['db']['database']);
                $tableGateway = new TableGateway($tableIdentifier, $sm->get(Adapter::class), null, $resultSetPrototype);
                return new PrivacyNoticesTable($tableGateway, $sm);
            },
            TermsCoditionsTable::class => function ($sm) {
                $resultSetPrototype = new ResultSet(ResultSet::TYPE_ARRAYOBJECT, new TermsCodition());
                $tableIdentifier = new TableIdentifier('aviso_terminos_condiciones',$_SESSION['db']['database']);
                $tableGateway = new TableGateway($tableIdentifier, $sm->get(Adapter::class), null, $resultSetPrototype);
                return new TermsCoditionsTable($tableGateway, $sm);
            },
            LossPassportsTable::class => function ($sm) {
                $resultSetPrototype = new ResultSet(ResultSet::TYPE_ARRAYOBJECT, new LossPassport());
                $tableIdentifier = new TableIdentifier('servicio_extravios_pasaportes',$_SESSION['db']['database']);
                $tableGateway = new TableGateway($tableIdentifier, $sm->get(Adapter::class), null, $resultSetPrototype);
                return new LossPassportsTable($tableGateway, $sm);
            },
            ProvidersComplaintsTable::class => function ($sm) {
                $resultSetPrototype = new ResultSet(ResultSet::TYPE_ARRAYOBJECT, new ProvidersComplaint());
                $tableIdentifier = new TableIdentifier('servicio_quejas_prestadores_turisticos',$_SESSION['db']['database']);
                $tableGateway = new TableGateway($tableIdentifier, $sm->get(Adapter::class), null, $resultSetPrototype);
                return new ProvidersComplaintsTable($tableGateway, $sm);
            },
            ComplaintsCyberFraudsTable::class => function ($sm) {
                $resultSetPrototype = new ResultSet(ResultSet::TYPE_ARRAYOBJECT, new ComplaintsCyberFraud());
                $tableIdentifier = new TableIdentifier('servicio_quejas_fraudes_ciberneticos',$_SESSION['db']['database']);
                $tableGateway = new TableGateway($tableIdentifier, $sm->get(Adapter::class), null, $resultSetPrototype);
                return new ComplaintsCyberFraudsTable($tableGateway, $sm);
            },
            ReportsTheftIncidentsTable::class => function ($sm) {
                $resultSetPrototype = new ResultSet(ResultSet::TYPE_ARRAYOBJECT, new ReportsTheftIncident());
                $tableIdentifier = new TableIdentifier('servicio_reportes_robos_incidentes',$_SESSION['db']['database']);
                $tableGateway = new TableGateway($tableIdentifier, $sm->get(Adapter::class), null, $resultSetPrototype);
                return new ReportsTheftIncidentsTable($tableGateway, $sm);
            },
            ClonedCreditCardsTable::class => function ($sm) {
                $resultSetPrototype = new ResultSet(ResultSet::TYPE_ARRAYOBJECT, new ClonedCreditCard());
                $tableIdentifier = new TableIdentifier('servicio_tarjeta_credito_clonada',$_SESSION['db']['database']);
                $tableGateway = new TableGateway($tableIdentifier, $sm->get(Adapter::class), null, $resultSetPrototype);
                return new ClonedCreditCardsTable($tableGateway, $sm);
            },
            LegalAdviceTable::class => function ($sm) {
                $resultSetPrototype = new ResultSet(ResultSet::TYPE_ARRAYOBJECT, new LegalAdvice());
                $tableIdentifier = new TableIdentifier('servicio_asesorias_legales',$_SESSION['db']['database']);
                $tableGateway = new TableGateway($tableIdentifier, $sm->get(Adapter::class), null, $resultSetPrototype);
                return new LegalAdviceTable($tableGateway, $sm);
            },
            MedicalAssistanceTable::class => function ($sm) {
                $resultSetPrototype = new ResultSet(ResultSet::TYPE_ARRAYOBJECT, new MedicalAssistance());
                $tableIdentifier = new TableIdentifier('servicio_asistencias_medicas',$_SESSION['db']['database']);
                $tableGateway = new TableGateway($tableIdentifier, $sm->get(Adapter::class), null, $resultSetPrototype);
                return new MedicalAssistanceTable($tableGateway, $sm);
            },
            GeneralTable::class => function ($sm) {
                $resultSetPrototype = new ResultSet(ResultSet::TYPE_ARRAYOBJECT, new General());
                $tableIdentifier = new TableIdentifier('emergencia_generales',$_SESSION['db']['database']);
                $tableGateway = new TableGateway($tableIdentifier, $sm->get(Adapter::class), null, $resultSetPrototype);
                return new GeneralTable($tableGateway, $sm);
            },
            FederalPoliceTable::class => function ($sm) {
                $resultSetPrototype = new ResultSet(ResultSet::TYPE_ARRAYOBJECT, new FederalPolice());
                $tableIdentifier = new TableIdentifier('emergencia_policias_federales',$_SESSION['db']['database']);
                $tableGateway = new TableGateway($tableIdentifier, $sm->get(Adapter::class), null, $resultSetPrototype);
                return new FederalPoliceTable($tableGateway, $sm);
            },
            AnonymousComplaintsTable::class => function ($sm) {
                $resultSetPrototype = new ResultSet(ResultSet::TYPE_ARRAYOBJECT, new AnonymousComplaint());
                $tableIdentifier = new TableIdentifier('emergencia_denuncias_anonimas',$_SESSION['db']['database']);
                $tableGateway = new TableGateway($tableIdentifier, $sm->get(Adapter::class), null, $resultSetPrototype);
                return new AnonymousComplaintsTable($tableGateway, $sm);
            },
            RoadAssistanceTable::class => function ($sm) {
                $resultSetPrototype = new ResultSet(ResultSet::TYPE_ARRAYOBJECT, new RoadAssistance());
                $tableIdentifier = new TableIdentifier('emergencia_asistencias_viales',$_SESSION['db']['database']);
                $tableGateway = new TableGateway($tableIdentifier, $sm->get(Adapter::class), null, $resultSetPrototype);
                return new RoadAssistanceTable($tableGateway, $sm);
            },
            GeneralCovidTable::class => function ($sm) {
                $resultSetPrototype = new ResultSet(ResultSet::TYPE_ARRAYOBJECT, new GeneralCovid());
                $tableIdentifier = new TableIdentifier('covid_generales',$_SESSION['db']['database']);
                $tableGateway = new TableGateway($tableIdentifier, $sm->get(Adapter::class), null, $resultSetPrototype);
                return new GeneralCovidTable($tableGateway, $sm);
            },
            CallCenterTable::class => function ($sm) {
                $resultSetPrototype = new ResultSet(ResultSet::TYPE_ARRAYOBJECT, new CallCenter());
                $tableIdentifier = new TableIdentifier('covid_call_center',$_SESSION['db']['database']);
                $tableGateway = new TableGateway($tableIdentifier, $sm->get(Adapter::class), null, $resultSetPrototype);
                return new CallCenterTable($tableGateway, $sm);
            },
            PreventiveMeasuresTable::class => function ($sm) {
                $resultSetPrototype = new ResultSet(ResultSet::TYPE_ARRAYOBJECT, new PreventiveMeasures());
                $tableIdentifier = new TableIdentifier('covid_medidas_prevencion',$_SESSION['db']['database']);
                $tableGateway = new TableGateway($tableIdentifier, $sm->get(Adapter::class), null, $resultSetPrototype);
                return new PreventiveMeasuresTable($tableGateway, $sm);
            },
            CovidTestsTable::class => function ($sm) {
                $resultSetPrototype = new ResultSet(ResultSet::TYPE_ARRAYOBJECT, new CovidTests());
                $tableIdentifier = new TableIdentifier('covid_pruebas',$_SESSION['db']['database']);
                $tableGateway = new TableGateway($tableIdentifier, $sm->get(Adapter::class), null, $resultSetPrototype);
                return new CovidTestsTable($tableGateway, $sm);
            },
            SanitaryCertificationTable::class => function ($sm) {
                $resultSetPrototype = new ResultSet(ResultSet::TYPE_ARRAYOBJECT, new SanitaryCertification());
                $tableIdentifier = new TableIdentifier('covid_certificacion_sanitaria',$_SESSION['db']['database']);
                $tableGateway = new TableGateway($tableIdentifier, $sm->get(Adapter::class), null, $resultSetPrototype);
                return new SanitaryCertificationTable($tableGateway, $sm);
            },
            ConsulatesEmbassiesTable::class => function ($sm) {
                $resultSetPrototype = new ResultSet(ResultSet::TYPE_ARRAYOBJECT, new ConsulatesEmbassies());
                $tableIdentifier = new TableIdentifier('catalogo_consulados',$_SESSION['db']['database']);
                $tableGateway = new TableGateway($tableIdentifier, $sm->get(Adapter::class), null, $resultSetPrototype);
                return new ConsulatesEmbassiesTable($tableGateway, $sm);
            },
            ProsecutorsTable::class => function ($sm) {
                $resultSetPrototype = new ResultSet(ResultSet::TYPE_ARRAYOBJECT, new Prosecutors());
                $tableIdentifier = new TableIdentifier('catalogo_fiscalias',$_SESSION['db']['database']);
                $tableGateway = new TableGateway($tableIdentifier, $sm->get(Adapter::class), null, $resultSetPrototype);
                return new ProsecutorsTable($tableGateway, $sm);
            },
            NationalitiesTable::class => function ($sm) {
                $resultSetPrototype = new ResultSet(ResultSet::TYPE_ARRAYOBJECT, new Nationalities());
                $tableIdentifier = new TableIdentifier('catalogo_nacionalidades',$_SESSION['db']['database']);
                $tableGateway = new TableGateway($tableIdentifier, $sm->get(Adapter::class), null, $resultSetPrototype);
                return new NationalitiesTable($tableGateway, $sm);
            },
            HospitalsTable::class => function ($sm) {
                $resultSetPrototype = new ResultSet(ResultSet::TYPE_ARRAYOBJECT, new Hospitals());
                $tableIdentifier = new TableIdentifier('catalogo_hospitales',$_SESSION['db']['database']);
                $tableGateway = new TableGateway($tableIdentifier, $sm->get(Adapter::class), null, $resultSetPrototype);
                return new HospitalsTable($tableGateway, $sm);
            },
            GendersTable::class => function ($sm) {
                $resultSetPrototype = new ResultSet(ResultSet::TYPE_ARRAYOBJECT, new Genders());
                $tableIdentifier = new TableIdentifier('catalogo_generos',$_SESSION['db']['database']);
                $tableGateway = new TableGateway($tableIdentifier, $sm->get(Adapter::class), null, $resultSetPrototype);
                return new GendersTable($tableGateway, $sm);
            },
            ServiceProvidersTable::class => function ($sm) {
                $resultSetPrototype = new ResultSet(ResultSet::TYPE_ARRAYOBJECT, new ServiceProvider());
                $tableIdentifier = new TableIdentifier('catalogo_quejas_prestadores',$_SESSION['db']['database']);
                $tableGateway = new TableGateway($tableIdentifier, $sm->get(Adapter::class), null, $resultSetPrototype);
                return new ServiceProvidersTable($tableGateway, $sm);
            },
            TouristicDestinationsTable::class => function ($sm) {
                $resultSetPrototype = new ResultSet(ResultSet::TYPE_ARRAYOBJECT, new TouristicDestination());
                $tableIdentifier = new TableIdentifier('catalogo_quejas_destinos',$_SESSION['db']['database']);
                $tableGateway = new TableGateway($tableIdentifier, $sm->get(Adapter::class), null, $resultSetPrototype);
                return new TouristicDestinationsTable($tableGateway, $sm);
            },
            ReasonsComplaintTable::class => function ($sm) {
                $resultSetPrototype = new ResultSet(ResultSet::TYPE_ARRAYOBJECT, new ReasonComplaint());
                $tableIdentifier = new TableIdentifier('catalogo_quejas_motivos',$_SESSION['db']['database']);
                $tableGateway = new TableGateway($tableIdentifier, $sm->get(Adapter::class), null, $resultSetPrototype);
                return new ReasonsComplaintTable($tableGateway, $sm);
            },
            LanguagesTable::class => function ($sm) {
                $resultSetPrototype = new ResultSet(ResultSet::TYPE_ARRAYOBJECT, new Language());
                $tableIdentifier = new TableIdentifier('catalogo_idiomas',$_SESSION['db']['database']);
                $tableGateway = new TableGateway($tableIdentifier, $sm->get(Adapter::class), null, $resultSetPrototype);
                return new LanguagesTable($tableGateway, $sm);
            },
            UsersDataTable::class => function ($sm) {
                $resultSetPrototype = new ResultSet(ResultSet::TYPE_ARRAYOBJECT, new UserData());
                $tableIdentifier = new TableIdentifier('catalogo_usuarios',$_SESSION['db']['database']);
                $tableGateway = new TableGateway($tableIdentifier, $sm->get(Adapter::class), null, $resultSetPrototype);
                return new UsersDataTable($tableGateway, $sm);
            },
            HomePageTable::class => function ($sm) {
                $resultSetPrototype = new ResultSet(ResultSet::TYPE_ARRAYOBJECT, new HomePage());
                $tableIdentifier = new TableIdentifier('pagina_inicio',$_SESSION['db']['database']);
                $tableGateway = new TableGateway($tableIdentifier, $sm->get(Adapter::class), null, $resultSetPrototype);
                return new HomePageTable($tableGateway, $sm);
            },
            TraceabilityTable::class => function ($sm) {
                $resultSetPrototype = new ResultSet(ResultSet::TYPE_ARRAYOBJECT, new Traceability());
                $tableIdentifier = new TableIdentifier('trazabilidad_formularios',$_SESSION['db']['database']);
                $tableGateway = new TableGateway($tableIdentifier, $sm->get(Adapter::class), null, $resultSetPrototype);
                return new TraceabilityTable($tableGateway, $sm);
            },
            UsersSocialNetworksTable::class => function ($sm) {
                $resultSetPrototype = new ResultSet(ResultSet::TYPE_ARRAYOBJECT, new UsersSocialNetwork());
                $tableIdentifier = new TableIdentifier('seguridad_usuarios_redes_sociales',$_SESSION['db']['database']);
                $tableGateway = new TableGateway($tableIdentifier, $sm->get(Adapter::class), null, $resultSetPrototype);
                return new UsersSocialNetworksTable($tableGateway, $sm);
            },
            FooterTable::class => function ($sm) {
                $resultSetPrototype = new ResultSet(ResultSet::TYPE_ARRAYOBJECT, new Footer());
                $tableIdentifier = new TableIdentifier('pagina_footer',$_SESSION['db']['database']);
                $tableGateway = new TableGateway($tableIdentifier, $sm->get(Adapter::class), null, $resultSetPrototype);
                return new FooterTable($tableGateway, $sm);
            },
            BannerTable::class => function ($sm) {
                $resultSetPrototype = new ResultSet(ResultSet::TYPE_ARRAYOBJECT, new Banner());
                $tableIdentifier = new TableIdentifier('pagina_banner',$_SESSION['db']['database']);
                $tableGateway = new TableGateway($tableIdentifier, $sm->get(Adapter::class), null, $resultSetPrototype);
                return new BannerTable($tableGateway, $sm);
            },
            ShortcutsTable::class => function ($sm) {
                $resultSetPrototype = new ResultSet(ResultSet::TYPE_ARRAYOBJECT, new Shortcuts());
                $tableIdentifier = new TableIdentifier('seguridad_accesos_directos',$_SESSION['db']['database']);
                $tableGateway = new TableGateway($tableIdentifier, $sm->get(Adapter::class), null, $resultSetPrototype);
                return new ShortcutsTable($tableGateway, $sm);
            },
            MenuPublicTable::class => function ($sm) {
                $resultSetPrototype = new ResultSet(ResultSet::TYPE_ARRAYOBJECT, new MenuPublic());
                $tableIdentifier = new TableIdentifier('seguridad_menus_publicos',$_SESSION['db']['database']);
                $tableGateway = new TableGateway($tableIdentifier, $sm->get(Adapter::class), null, $resultSetPrototype);
                return new MenuPublicTable($tableGateway, $sm);
            },
            SedeturComplaintsFormTable::class => function ($sm) {
                $resultSetPrototype = new ResultSet(ResultSet::TYPE_ARRAYOBJECT, new SedeturComplaintsForm());
                $tableIdentifier = new TableIdentifier('servicio_formulario_quejas',$_SESSION['db']['database']);
                $tableGateway = new TableGateway($tableIdentifier, $sm->get(Adapter::class), null, $resultSetPrototype);
                return new SedeturComplaintsFormTable($tableGateway, $sm);
            },
            ConsulatesAndEmbasiesTitleTable::class => function ($sm) {
                $resultSetPrototype = new ResultSet(ResultSet::TYPE_ARRAYOBJECT, new ConsulatesAndEmbasiesTitle());
                $tableIdentifier = new TableIdentifier('titulo_consulados',$_SESSION['db']['database']);
                $tableGateway = new TableGateway($tableIdentifier, $sm->get(Adapter::class), null, $resultSetPrototype);
                return new ConsulatesAndEmbasiesTitleTable($tableGateway, $sm);
            },
            ProsecutorsTitleTable::class => function ($sm) {
                $resultSetPrototype = new ResultSet(ResultSet::TYPE_ARRAYOBJECT, new ProsecutorsTitle());
                $tableIdentifier = new TableIdentifier('titulo_fiscalias',$_SESSION['db']['database']);
                $tableGateway = new TableGateway($tableIdentifier, $sm->get(Adapter::class), null, $resultSetPrototype);
                return new ProsecutorsTitleTable($tableGateway, $sm);
            },
            HospitalsTitleTable::class => function ($sm) {
                $resultSetPrototype = new ResultSet(ResultSet::TYPE_ARRAYOBJECT, new HospitalsTitle());
                $tableIdentifier = new TableIdentifier('titulo_hospitales',$_SESSION['db']['database']);
                $tableGateway = new TableGateway($tableIdentifier, $sm->get(Adapter::class), null, $resultSetPrototype);
                return new HospitalsTitleTable($tableGateway, $sm);
            },
            LabelsTable::class => function ($sm) {
                $resultSetPrototype = new ResultSet(ResultSet::TYPE_ARRAYOBJECT, new Label());
                $tableIdentifier = new TableIdentifier('pagina_etiquetas',$_SESSION['db']['database']);
                $tableGateway = new TableGateway($tableIdentifier, $sm->get(Adapter::class), null, $resultSetPrototype);
                return new LabelsTable($tableGateway, $sm);
            }
        ]
    ]
];
