<?php
namespace Api\V1\Rest\ReporteRobo;

use Laminas\ApiTools\ApiProblem\ApiProblem;
use Laminas\ApiTools\Rest\AbstractResourceListener;
use Laminas\Stdlib\Parameters;
use Application\Library\Api\Resource;
use Application\Model\Catalog\Languages\LanguagesTable;
use Application\Model\Catalog\Prosecutors\ProsecutorsTable;
use Application\Model\Home\Labels\LabelsTable;
use Application\Model\Service\ReportsTheftIncidents\ReportsTheftIncidentsTable;

class ReporteRoboResource extends Resource
{
    /**
     * Create a resource
     *
     * @param  mixed $data
     * @return ApiProblem|mixed
     */
    public function create($data)
    {
        return new ApiProblem(405, 'The POST method has not been defined');
    }

    /**
     * Delete a resource
     *
     * @param  mixed $id
     * @return ApiProblem|mixed
     */
    public function delete($id)
    {
        return new ApiProblem(405, 'The DELETE method has not been defined for individual resources');
    }

    /**
     * Delete a collection, or members of a collection
     *
     * @param  mixed $data
     * @return ApiProblem|mixed
     */
    public function deleteList($data)
    {
        return new ApiProblem(405, 'The DELETE method has not been defined for collections');
    }

    /**
     * Fetch a resource
     *
     * @param  mixed $id
     * @return ApiProblem|mixed
     */
    public function fetch($id)
    {
        return new ApiProblem(405, 'The GET method has not been defined for individual resources');
    }

    /**
     * Fetch all or a subset of resources
     *
     * @param  array|Parameters $params
     * @return ApiProblem|mixed
     */
    public function fetchAll($params = [])
    {
        try {
            
            /*************************
             * Parameters extraction *
             *************************/
            
            /**********************
             * Custom validations *
             **********************/
            
            /**************************
             * Input data preparation *
             **************************/
            
            /**********************
             * Action realization *
             **********************/
            
            $result = $this->sm->get(ReportsTheftIncidentsTable::class)->fetchAll($params);
            $fiscalias = $this->sm->get(ProsecutorsTable::class)->fetchAll($params);
            $idiomas = $this->sm->get(LanguagesTable::class)->fetchAll(['where' => 'frmActivoIdioma eq 1']);
            $etiquetas = $this->sm->get(LabelsTable::class)->fetchAll();

            /***************************
             * Output data preparation *
             ***************************/

             foreach($idiomas->data as $k1 => $v1){
                foreach($etiquetas->data as $ek => $ev){
                    $ev['frmI18nLabel'] = json_decode($ev['frmI18nLabel'], true);
                    foreach($ev['frmI18nLabel'] as $edk => $edv){
                        if($v1['frmCodigoIdioma'] == $edk){
                            $labels[$ev['frmEtiquetaLabel']] = $edv;
                        }
                    }
                }
                $labelsIdIdioma[$v1['frmIdIdioma']] = $labels;
                $labels = [];
            }

            $cat = null;
            foreach($idiomas->data as $ik => $iv){
                foreach ($fiscalias->data as $r => $k) {
                    if($k['frmIdIdioma'] == $iv['frmIdIdioma']){
                        $cat[] = [
                            [
                                'etiqueta' => 'Nombre: ',
                                'valor' => $k['frmNombreFiscalia'],
                                'tipo' => 'texto',
                                'icono' => 'img/iconos/shield-alt-solid.svg'
                            ],
                            [
                                "etiqueta" => $labelsIdIdioma[$k['frmIdIdioma']]['lbldomicilio']." ",
                                'valor' => $k['frmDireccionFiscalia'],
                                'tipo' => 'texto'
                            ],
                            [
                                "etiqueta" => $labelsIdIdioma[$k['frmIdIdioma']]['lbltelefono']." ",
                                'valor' => $k['frmTelefonoFiscalia'],
                                'tipo' => 'texto'
                            ],
                            [
                                'etiqueta' => 'Mapa: ',
                                'valor' => $labelsIdIdioma[$k['frmIdIdioma']]['lblvermapa']." ",
                                'tipo' => 'mapa',
                                'icono' => 'img/iconos/map-marker-alt-solid.svg',
                                'latitud' => $k['frmLatitudFiscalia'],
                                'longitud' => $k['frmLongitudFiscalia'],
                                'id' => $k['frmIdFiscalia']
                            ]
                        ];
                    }
               }
               foreach ($result->data as $r => $k) {
                    if($k['frmIdIdioma'] == $iv['frmIdIdioma']){
                        $result->data[$r]['frmBasePath']  = (empty($_SERVER['HTTPS']) ? 'http' : 'https') . "://$_SERVER[HTTP_HOST]/";
                        $result->data[$r]['frmContenidoReportesRobo'] = json_decode($k['frmContenidoReportesRobo']);

                        $cont = $cat;
                    
                        foreach ($result->data[$r]['frmContenidoReportesRobo']->contenido as $i => $j) {
                            foreach ($j->subtitulo as $k => $v) {
                                if (@$v->valor == "catalogoFiscalias") {
                                    $result->data[$r]['frmContenidoReportesRobo']->contenido[$i]->subtitulo[$k]->valor = @$cont;
                                }
                            }
                        }
                    }
                }
                $cat = [];
            }
            
            
            $body = $result;
            
            /********************
             * Response sending *
             ********************/
            
            return $this->getResponse(200, $body);
            
        } catch (\Exception $e) {
            return $this->getServerError($e);
        }
    }

    /**
     * Patch (partial in-place update) a resource
     *
     * @param  mixed $id
     * @param  mixed $data
     * @return ApiProblem|mixed
     */
    public function patch($id, $data)
    {
        return new ApiProblem(405, 'The PATCH method has not been defined for individual resources');
    }

    /**
     * Patch (partial in-place update) a collection or members of a collection
     *
     * @param  mixed $data
     * @return ApiProblem|mixed
     */
    public function patchList($data)
    {
        return new ApiProblem(405, 'The PATCH method has not been defined for collections');
    }

    /**
     * Replace a collection or members of a collection
     *
     * @param  mixed $data
     * @return ApiProblem|mixed
     */
    public function replaceList($data)
    {
        return new ApiProblem(405, 'The PUT method has not been defined for collections');
    }

    /**
     * Update a resource
     *
     * @param  mixed $id
     * @param  mixed $data
     * @return ApiProblem|mixed
     */
    public function update($id, $data)
    {
        return new ApiProblem(405, 'The PUT method has not been defined for individual resources');
    }
}
