<?php
namespace Api\V1\Rest\Registro;

use Application\Library\Api\Resource;
use Application\Model\Catalog\Employees\EmployeesTable;
use Application\Model\Catalog\UsersData\UsersDataTable;
use Application\Model\Security\Users\UsersTable;
use Application\Model\Security\UsersSocialNetworks\UsersSocialNetworksTable;
use Laminas\ApiTools\ApiProblem\ApiProblem;
use Laminas\ApiTools\Rest\AbstractResourceListener;
use Laminas\Stdlib\Parameters;

class RegistroResource extends Resource
{
    /**
     * Create a resource
     *
     * @param  mixed $data
     * @return ApiProblem|mixed
     */
    public function create($data)
    {
        try{
            // Data is filtered and sanitized.
            $data = $this->getFilteredData($data);

            $user = $this->sm->get(UsersTable::class)->selectByName($data['frmCorreo']);
            // Validate if user exists 
            if(@$user->frmIdUsuario){
                // Validate if uid exits
                $uid = $this->sm->get(UsersSocialNetworksTable::class)->selectByUid($data['frmUidRedSocial']);
                if(@$uid != $data['frmUidRedSocial']){
                    // If the uid don't equals, register a new uid to the user
                    $uidData = [
                        'frmIdUsuarioUsuariosRedesSociales' => $user->frmIdUsuario,
                        'frmIdRedSocialUsuariosRedesSociales' => $data['frmIdRedSocial'],
                        'frmUidUsuariosRedesSociales' => $data['frmUidRedSocial']
                    ];
                    $this->sm->get(UsersSocialNetworksTable::class)->insert($uidData);
                    // Response is sent.
                    return $this->getResponse(200, "Usuario creado exitosamente");
                }else{
                    return $this->getError(401, $this->translator->translate('El usuario ya existe'));
                }
            };

            // Declares personal data from post
            $personalData = [
                'frmNombreEmpleado' => $data['frmNombre'],
                'frmApellidosEmpleado' => $data['frmApellidos'],
                'frmCorreoElectronicoEmpleado' => $data['frmCorreo'],
                'frmFechaNacimientoEmpleado' => $data['frmFechaNacimiento'],
                'frmContraseñaEmpleado' => $data['frmContraseña'],
                'frmIdRedSocialEmpleado' => $data['frmIdRedSocial'],
                'frmUidRedSocialEmpleado' => @$data['frmUidRedSocial'],
                'frmIdGeneroEmpleado' => $data['frmIdGenero']
            ];

            // Insert and obtain id of user in catalog
            $this->sm->get(EmployeesTable::class)->createFromWeb($personalData);
            
            // Response is sent.
            return $this->getResponse(200, "Usuario creado exitosamente");
            
        } catch (\Exception $e) {
            return $this->getServerError($e);
        }
    }

    /**
     * Delete a resource
     *
     * @param  mixed $id
     * @return ApiProblem|mixed
     */
    public function delete($id)
    {
        return new ApiProblem(405, 'The DELETE method has not been defined for individual resources');
    }

    /**
     * Delete a collection, or members of a collection
     *
     * @param  mixed $data
     * @return ApiProblem|mixed
     */
    public function deleteList($data)
    {
        return new ApiProblem(405, 'The DELETE method has not been defined for collections');
    }

    /**
     * Fetch a resource
     *
     * @param  mixed $id
     * @return ApiProblem|mixed
     */
    public function fetch($id)
    {
        return new ApiProblem(405, 'The GET method has not been defined for individual resources');
    }

    /**
     * Fetch all or a subset of resources
     *
     * @param  array|Parameters $params
     * @return ApiProblem|mixed
     */
    public function fetchAll($params = [])
    {
        return new ApiProblem(405, 'The GET method has not been defined for collections');
    }

    /**
     * Patch (partial in-place update) a resource
     *
     * @param  mixed $id
     * @param  mixed $data
     * @return ApiProblem|mixed
     */
    public function patch($id, $data)
    {
        return new ApiProblem(405, 'The PATCH method has not been defined for individual resources');
    }

    /**
     * Patch (partial in-place update) a collection or members of a collection
     *
     * @param  mixed $data
     * @return ApiProblem|mixed
     */
    public function patchList($data)
    {
        return new ApiProblem(405, 'The PATCH method has not been defined for collections');
    }

    /**
     * Replace a collection or members of a collection
     *
     * @param  mixed $data
     * @return ApiProblem|mixed
     */
    public function replaceList($data)
    {
        return new ApiProblem(405, 'The PUT method has not been defined for collections');
    }

    /**
     * Update a resource
     *
     * @param  mixed $id
     * @param  mixed $data
     * @return ApiProblem|mixed
     */
    public function update($id, $data)
    {
        return new ApiProblem(405, 'The PUT method has not been defined for individual resources');
    }
}
