<?php
namespace Api\V1\Rest\Login;

use Application\Library\Api\Resource;
use Application\Library\Api\Token;
use Application\Library\Complements\MyLogger;
use Application\Library\Security\Password;
use Application\Model\Security\Users\UsersTable;
use Application\Model\Security\UsersSocialNetworks\UsersSocialNetworksTable;
use Laminas\ApiTools\ApiProblem\ApiProblem;
use Laminas\Stdlib\Parameters;

class LoginResource extends Resource
{
    /**
     * Create a resource
     *
     * @param  mixed $data
     * @return ApiProblem|mixed
     */
    public function create($data)
    {
        try {
            
            // Data is filtered and sanitized.
            $data = $this->getFilteredData($data);
            // Checked if user exists.
            $user = $this->sm->get(UsersTable::class)->selectByName($data['frmCorreo'], null, false);
            if(empty($user->frmIdUsuario)) {
                return $this->getError(401, $this->translator->translate('El correo incorrecto'));
            }

            $uid = $this->sm->get(UsersSocialNetworksTable::class)->selectByUid($data['frmUidRedSocial']);
            // Validate id of social network
            if(@$data['frmUidRedSocial']){
                if($data['frmUidRedSocial'] != @$uid->frmUidUsuariosRedesSociales){
                    return $this->getError(401, $this->translator->translate('Acceso incorrecto'));
                }
            }else{
                // Password given from the form is validated against stored password.
                if(!Password::verify($data['frmContraseña'], $user->frmPasswordUsuario)) {
                    return $this->getError(401, $this->translator->translate('La contraseña es incorrecta'));
                }
            }
           
            // Validates if user is active.
            if($user->frmActivoUsuario != 1) {
                return $this->getError(401, $this->translator->translate('El usuario está inactivo'));
            }
            
            // Data prepared.
            $payload = [
                'id' => $user->frmIdUsuario,
                'user' => $user->frmIdNombreUsuarioUsuario,
                'name' => $user->frmNombreEmpleado,
                'lastName' => $user->frmApellidosEmpleado,
//                 'citizen' => trim(implode(' ', [$user->frmNameCitizen, $user->frmLastNameCitizen, $user->frmMaternalSurnameCitizen])),
//                 'initials' => substr($user->frmNameCitizen, 0, 1).substr($user->frmLastNameCitizen, 0, 1)
            ];

            // Access token is created.
            $accessToken = Token::create($payload);
            
            // Refresh token is created and stored in database.
            $refreshToken = bin2hex(openssl_random_pseudo_bytes(16));
            
            // Session ID is extracted and stored in database.
            $sessionToken = session_id();
            
            // Data stored in session.
            $_SESSION['user'] = $payload;
            
            // Load sections.
//             $userSection = $this->sm->get(UsersSectionsTable::class)->selectByUserId($user->frmIdUsuario);
//             $_SESSION['user']['state'] = $userSection->frmStateIdUserSection;
//             $_SESSION['user']['municipalities'] = @json_decode($userSection->frmMunicipalitiesUserSection) ? : [];
//             $_SESSION['user']['sections'] = @json_decode($userSection->frmSectionsUserSection, true) ? : [];
            
            // Tokens stored in database.
            $this->sm->get(UsersTable::class)->updateTokens($user->frmIdUsuario, $accessToken, $refreshToken);
            
            // Body is prepared for insert it in response.
            $body = [
                'idUsuario' => $user->frmIdUsuario,
                'accessToken' => $accessToken,
                'refreshToken' => $refreshToken,
                'sessionToken' => $sessionToken,
                'datosUsuario' => [
                    'nombre' => $user->frmNombreEmpleado,
                    'apellidos' => $user->frmApellidosEmpleado,
                    'idGenero' => $user->frmIdGeneroUsuarioEmpleado,
                    'fechaNacimiento' => $user->frmFechaNacimientoEmpleado
                ]
            ];
            
            // Response is sent.
            return $this->getResponse(200, $body);
            
        } catch (\Exception $e) {
            return $this->getServerError($e);
        }
    }

    /**
     * Delete a resource
     *
     * @param  mixed $id
     * @return ApiProblem|mixed
     */
    public function delete($id)
    {
        return new ApiProblem(405, 'The DELETE method has not been defined for individual resources');
    }

    /**
     * Delete a collection, or members of a collection
     *
     * @param  mixed $data
     * @return ApiProblem|mixed
     */
    public function deleteList($data)
    {
        return new ApiProblem(405, 'The DELETE method has not been defined for collections');
    }

    /**
     * Fetch a resource
     *
     * @param  mixed $id
     * @return ApiProblem|mixed
     */
    public function fetch($id)
    {
        return new ApiProblem(405, 'The GET method has not been defined for individual resources');
    }

    /**
     * Fetch all or a subset of resources
     *
     * @param  array|Parameters $params
     * @return ApiProblem|mixed
     */
    public function fetchAll($params = [])
    {
        try {
            
            // Access token payload is extracted.
            $body = Token::payload();
            
            // Response is sent.
            return $this->getResponse(200, $body);
            
        } catch (\Exception $e) {
            return $this->getServerError($e);
        }
    }

    /**
     * Patch (partial in-place update) a resource
     *
     * @param  mixed $id
     * @param  mixed $data
     * @return ApiProblem|mixed
     */
    public function patch($id, $data)
    {
        return new ApiProblem(405, 'The PATCH method has not been defined for individual resources');
    }

    /**
     * Patch (partial in-place update) a collection or members of a collection
     *
     * @param  mixed $data
     * @return ApiProblem|mixed
     */
    public function patchList($data)
    {
        return new ApiProblem(405, 'The PATCH method has not been defined for collections');
    }

    /**
     * Replace a collection or members of a collection
     *
     * @param  mixed $data
     * @return ApiProblem|mixed
     */
    public function replaceList($data)
    {
        return new ApiProblem(405, 'The PUT method has not been defined for collections');
    }

    /**
     * Update a resource
     *
     * @param  mixed $id
     * @param  mixed $data
     * @return ApiProblem|mixed
     */
    public function update($id, $data)
    {
        return new ApiProblem(405, 'The PUT method has not been defined for individual resources');
    }
}
