<?php
namespace Api\V1\Rest\Fiscalias;

use Application\Library\Api\Resource;
use Application\Library\Complements\MyLogger;
use Application\Model\Catalog\Languages\LanguagesTable;
use Application\Model\Catalog\Prosecutors\ProsecutorsTable;
use Application\Model\Home\Labels\LabelsTable;
use Application\Model\Home\ProsecutorsTitle\ProsecutorsTitleTable;
use Laminas\ApiTools\ApiProblem\ApiProblem;
use Laminas\ApiTools\Rest\AbstractResourceListener;
use Laminas\Stdlib\Parameters;

class FiscaliasResource extends Resource
{
    /**
     * Create a resource
     *
     * @param  mixed $data
     * @return ApiProblem|mixed
     */
    public function create($data)
    {
        return new ApiProblem(405, 'The POST method has not been defined');
    }

    /**
     * Delete a resource
     *
     * @param  mixed $id
     * @return ApiProblem|mixed
     */
    public function delete($id)
    {
        return new ApiProblem(405, 'The DELETE method has not been defined for individual resources');
    }

    /**
     * Delete a collection, or members of a collection
     *
     * @param  mixed $data
     * @return ApiProblem|mixed
     */
    public function deleteList($data)
    {
        return new ApiProblem(405, 'The DELETE method has not been defined for collections');
    }

    /**
     * Fetch a resource
     *
     * @param  mixed $id
     * @return ApiProblem|mixed
     */
    public function fetch($id)
    {
        try {
            
            /*************************
             * Parameters extraction *
             *************************/
            
            /**********************
             * Custom validations *
             **********************/
            
            /**************************
             * Input data preparation *
             **************************/
            
            /**********************
             * Action realization *
             **********************/
            
            $result = $this->sm->get(ProsecutorsTable::class)->fetch($id);
            $idiomas = $this->sm->get(LanguagesTable::class)->fetchAll(['where' => 'frmActivoIdioma eq 1']);
            $etiquetas = $this->sm->get(LabelsTable::class)->fetchAll();

            /***************************
             * Output data preparation *
             ***************************/

             foreach($idiomas->data as $k1 => $v1){
                foreach($etiquetas->data as $ek => $ev){
                    $ev['frmI18nLabel'] = json_decode($ev['frmI18nLabel'], true);
                    foreach($ev['frmI18nLabel'] as $edk => $edv){
                        if($v1['frmCodigoIdioma'] == $edk){
                            $labels[$ev['frmEtiquetaLabel']] = $edv;
                        }
                    }
                }
                $labelsIdIdioma[$v1['frmIdIdioma']] = $labels;
                $labels = [];
            }

             $sub = null;
             $data = null;
 
             foreach($idiomas->data as $k1 => $v1){
                 foreach ($result->data as $k => $r) {
                     if($r['frmIdIdioma'] == $v1['frmIdIdioma']){
                        $sub = [
                            [
                                "tipo" => "coordenadas",
                                "latitud" => $r['frmLatitudFiscalia'],
                                "longitud" => $r['frmLongitudFiscalia']
                            ],
                            [
                                "etiqueta" => $labelsIdIdioma[$r['frmIdIdioma']]['lbldomicilio']." ",
                                "tipo" => "texto",
                                "valor" => $r['frmDireccionFiscalia'],
                                "icono" => "img/iconos/compass-solid.svg"
                            ],
                            [
                                "etiqueta" => $labelsIdIdioma[$r['frmIdIdioma']]['lbltelefono']." ",
                                "tipo" => "texto",
                                "valor" => $r['frmTelefonoFiscalia'],
                                "icono" => "img/iconos/phone-solid.svg"
                            ],
                        ];
 
                         $data[] = [
                             "frmIdFiscalia" => $r['frmIdFiscalia'],
                             "frmIdIdioma" => $r['frmIdIdioma'],
                             "frmBasePath" => (empty($_SERVER['HTTPS']) ? 'http' : 'https') . "://$_SERVER[HTTP_HOST]/",
                             "frmContenidoFiscalia" => [
                                 "contenido" => [
                                     [
                                         "titulo" => $r['frmNombreFiscalia'],
                                         "subtitulo" => [
                                             $sub
                                         ]
                                     ]
                                 ]
                             ]
                         ];
                     }
                 }
                 
             }
 
             $body = array(
                 "totalRecords" => count($data), 
                 "data" => $data
             );
            
            /********************
             * Response sending *
             ********************/
            
            return $this->getResponse(200, $body);
            
        } catch (\Exception $e) {
            return $this->getServerError($e);
        }
    }

    /**
     * Fetch all or a subset of resources
     *
     * @param  array|Parameters $params
     * @return ApiProblem|mixed
     */
    public function fetchAll($params = [])
    {
        try {
            
            /*************************
             * Parameters extraction *
             *************************/
            
            /**********************
             * Custom validations *
             **********************/
            
            /**************************
             * Input data preparation *
             **************************/
            
            /**********************
             * Action realization *
             **********************/
            
            $result = $this->sm->get(ProsecutorsTable::class)->fetchAll($params);
            $titulo = $this->sm->get(ProsecutorsTitleTable::class)->fetchAll([])->data;
            $idiomas = $this->sm->get(LanguagesTable::class)->fetchAll(['where' => 'frmActivoIdioma eq 1']);
            $etiquetas = $this->sm->get(LabelsTable::class)->fetchAll();

            /***************************
             * Output data preparation *
             ***************************/

             foreach($idiomas->data as $k1 => $v1){
                foreach($etiquetas->data as $ek => $ev){
                    $ev['frmI18nLabel'] = json_decode($ev['frmI18nLabel'], true);
                    foreach($ev['frmI18nLabel'] as $edk => $edv){
                        if($v1['frmCodigoIdioma'] == $edk){
                            $labels[$ev['frmEtiquetaLabel']] = $edv;
                        }
                    }
                }
                $labelsIdIdioma[$v1['frmIdIdioma']] = $labels;
                $labels = [];
            }

            $result2 = null;

            foreach($titulo as $k => $v){
                foreach($result->data as $k2 => $v2){
                    if($v2['frmIdIdioma'] == $v['frmIdIdioma']){
                        $catalogo[] = [
                                [
                                    'etiqueta' => 'Nombre: ',
                                    'valor' => $v2['frmNombreFiscalia'],
                                    'tipo' => 'texto',
                                    'icono' => 'img/iconos/shield-alt-solid.svg'
                                ],
                                [
                                    'etiqueta' => $labelsIdIdioma[$v2['frmIdIdioma']]['lbldomicilio']." ",
                                    'valor' => $v2['frmDireccionFiscalia'],
                                    'tipo' => 'texto'
                                ],
                                [
                                    'etiqueta' => $labelsIdIdioma[$v2['frmIdIdioma']]['lbltelefono']." ",
                                    'valor' => $v2['frmTelefonoFiscalia'],
                                    'tipo' => 'texto'
                                ],
                                [
                                    'etiqueta' => 'Mapa: ',
                                    'valor' => $labelsIdIdioma[$v2['frmIdIdioma']]['lblvermapa']." ",
                                    'tipo' => 'mapa',
                                    'icono' => 'img/iconos/map-marker-alt-solid.svg',
                                    'latitud' => $v2['frmLatitudFiscalia'],
                                    'longitud' => $v2['frmLongitudFiscalia'],
                                    'id' => $v2['frmIdFiscalia']
                                ]
                            ];
                    }
                }
                if(@$catalogo){
                    $result2["subtitulo"][] = [
                        "tipo" => "catalogo",
                        "valor" => $catalogo
                    ];
                }
                $catalogo = [];
                if(@$result2['subtitulo']){
                    $cons[] = [
                        "frmIdFiscalias" => $v['frmIdTituloFiscalias'],
                        "frmIdIdioma" => $v['frmIdIdioma'],
                        "frmBasePath" => (empty($_SERVER['HTTPS']) ? 'http' : 'https') . "://$_SERVER[HTTP_HOST]/",
                        "frmContenidoFiscalias" => [
                            "menu" => "Directorios",
                            "subMenu" => $v['frmContenidoTituloFiscalias'],
                            "contenido" => [
                                $result2
                            ]
                        ],
                        "frmActivoFiscalias" => "1"
                        ];
                }
                $result2 = [];
            }

            $response = [
                "totalRecords" => count($cons),
                "data" => $cons
                
            ];
            
            $body = $response;
            
            /********************
             * Response sending *
             ********************/
            
            return $this->getResponse(200, $body);
            
        } catch (\Exception $e) {
            return $this->getServerError($e);
        }
    }

    /**
     * Patch (partial in-place update) a resource
     *
     * @param  mixed $id
     * @param  mixed $data
     * @return ApiProblem|mixed
     */
    public function patch($id, $data)
    {
        return new ApiProblem(405, 'The PATCH method has not been defined for individual resources');
    }

    /**
     * Patch (partial in-place update) a collection or members of a collection
     *
     * @param  mixed $data
     * @return ApiProblem|mixed
     */
    public function patchList($data)
    {
        return new ApiProblem(405, 'The PATCH method has not been defined for collections');
    }

    /**
     * Replace a collection or members of a collection
     *
     * @param  mixed $data
     * @return ApiProblem|mixed
     */
    public function replaceList($data)
    {
        return new ApiProblem(405, 'The PUT method has not been defined for collections');
    }

    /**
     * Update a resource
     *
     * @param  mixed $id
     * @param  mixed $data
     * @return ApiProblem|mixed
     */
    public function update($id, $data)
    {
        return new ApiProblem(405, 'The PUT method has not been defined for individual resources');
    }
}
