<?php
namespace Api\V1\Rest\ConsuladosYEmbajadas;

use Application\Library\Api\Resource;
use Application\Library\Complements\MyLogger;
use Application\Model\Catalog\ConsulatesEmbassies\ConsulatesEmbassiesTable;
use Application\Model\Catalog\Languages\LanguagesTable;
use Application\Model\Home\ConsulatesAndEmbasiesTitle\ConsulatesAndEmbasiesTitleTable;
use Application\Model\Home\Labels\LabelsTable;
use Laminas\ApiTools\ApiProblem\ApiProblem;
use Laminas\ApiTools\Rest\AbstractResourceListener;
use Laminas\Stdlib\Parameters;

class ConsuladosYEmbajadasResource extends Resource
{
    /**
     * Create a resource
     *
     * @param  mixed $data
     * @return ApiProblem|mixed
     */
    public function create($data)
    {
        return new ApiProblem(405, 'The POST method has not been defined');
    }

    /**
     * Delete a resource
     *
     * @param  mixed $id
     * @return ApiProblem|mixed
     */
    public function delete($id)
    {
        return new ApiProblem(405, 'The DELETE method has not been defined for individual resources');
    }

    /**
     * Delete a collection, or members of a collection
     *
     * @param  mixed $data
     * @return ApiProblem|mixed
     */
    public function deleteList($data)
    {
        return new ApiProblem(405, 'The DELETE method has not been defined for collections');
    }

    /**
     * Fetch a resource
     *
     * @param  mixed $id
     * @return ApiProblem|mixed
     */
    public function fetch($id, $params = [])
    {
        try {
            
            /*************************
             * Parameters extraction *
             *************************/
            
            /**********************
             * Custom validations *
             **********************/
            
            /**************************
             * Input data preparation *
             **************************/
            
            /**********************
             * Action realization *
             **********************/

            $idIdioma = substr(@$params['where'], -1);
            $result = $this->sm->get(ConsulatesEmbassiesTable::class)->fetch($id, $params);
            $idiomas = $this->sm->get(LanguagesTable::class)->fetchAll(['where' => 'frmActivoIdioma eq 1']);
            $etiquetas = $this->sm->get(LabelsTable::class)->fetchAll();
                        
            // $result->data['frmContenidoConsuladoEmbajada'] = json_decode($result->data['frmContenidoConsuladoEmbajada'],true); 
            
            /***************************
             * Output data preparation *
             ***************************/

            $sub = null;

            $data = null;

            foreach($idiomas->data as $k1 => $v1){
                foreach($etiquetas->data as $ek => $ev){
                    $ev['frmI18nLabel'] = json_decode($ev['frmI18nLabel'], true);
                    foreach($ev['frmI18nLabel'] as $edk => $edv){
                        if($v1['frmCodigoIdioma'] == $edk){
                            $labels[$ev['frmEtiquetaLabel']] = $edv;
                        }
                    }
                }
                $labelsIdIdioma[$v1['frmIdIdioma']] = $labels;
                $labels = [];
            }

            foreach($idiomas->data as $k1 => $v1){
                foreach ($result->data as $k => $r) {
                    if($v1['frmIdIdioma'] == $r['frmIdIdioma']){
                        $sub[] = [
                            [
                                "tipo" => "texto",
                                "valor" => $labelsIdIdioma[$r['frmIdIdioma']]['lblconsulado']
                            ],
                            [
                                "tipo" => "img",
                                "valor" => "img/banderas/".$r['frmBanderaConsuladoEmbajada'],
                            ],
                            [
                                "tipo" => "coordenadas",
                                "latitud" => $r['frmLatitudConsuladoEmbajada'],
                                "longitud" => $r['frmLongitudConsuladoEmbajada']
                            ],
                            [
                                "etiqueta" => $labelsIdIdioma[$r['frmIdIdioma']]['lbljurisdiccion']." ",
                                "tipo" => "texto",
                                "valor" => $r['frmJurisdiccionConsuladoEmbajada'],
                                "icono" => "img/iconos/certificate-solid.svg"
                            ],
                            [
                                "etiqueta" => $labelsIdIdioma[$r['frmIdIdioma']]['lbldomicilio']." ",
                                "tipo" => "texto",
                                "valor" => $r['frmDireccionConsuladoEmbajada'],
                                "icono" => "img/iconos/compass-solid.svg"
                            ],
                            [
                                "etiqueta" => $labelsIdIdioma[$r['frmIdIdioma']]['lblhorario']." ",
                                "tipo" => "texto",
                                "valor" => $r['frmHorarioConsuladoEmbajada'],
                                "icono" => "img/iconos/calendar-days-solids.svg"
                            ],
                            [
                                "etiqueta" => $labelsIdIdioma[$r['frmIdIdioma']]['lblcorreo']." ",
                                "tipo" => "texto",
                                "valor" => $r['frmCorreoConsuladoEmbajada'],
                                "icono" => "img/iconos/envelope-solid.svg"
                            ],
                            [
                                "etiqueta" => $labelsIdIdioma[$r['frmIdIdioma']]['lblwebsite']." ",
                                "tipo" => "texto",
                                "valor" => $r['frmWebsiteConsuladoEmbajada']
                            ],
                            [
                                "etiqueta" => $labelsIdIdioma[$r['frmIdIdioma']]['lbltelefono']." ",
                                "tipo" => "texto",
                                "valor" => $r['frmTelefonoConsuladoEmbajada'],
                                "icono" => "img/iconos/phone-solid.svg"
                            ],
                            [
                                "etiqueta" => $labelsIdIdioma[$r['frmIdIdioma']]['lbltelefonoemergencia']." ",
                                "tipo" => "texto",
                                "valor" => $r['frmTelefonoEmergenciaConsuladoEmbajada'],
                                "icono" => "img/iconos/medkit-solid.svg"
                            ],
                        ];
                        $consulado = $r['frmNombreConsuladoEmbajada'];  
                    }
                }
                $data[] = [
                    "frmIdConsuladoEmbajada" => $r['frmIdPaisConsuladoEmbajada'],
                    "frmIdIdioma" => $v1['frmIdIdioma'],
                    "frmBasePath" => (empty($_SERVER['HTTPS']) ? 'http' : 'https') . "://$_SERVER[HTTP_HOST]/",
                    "frmContenidoConsuladoEmbajada" => [
                        "contenido" => [
                            [
                                "titulo" => $consulado,
                                "subtitulo" => 
                                    $sub
                            ]
                        ]
                    ]
                ];
                $sub = [];
                $labels = [];

            }
            
            $body = array(
                "totalRecords" => count($data), 
                "data" => $data
            );
                        
            /********************
             * Response sending *
             ********************/
            
            return $this->getResponse(200, $body);
            
        } catch (\Exception $e) {
            return $this->getServerError($e);
        }
    }

    /**
     * Fetch all or a subset of resources
     *
     * @param  array|Parameters $params
     * @return ApiProblem|mixed
     */
    public function fetchAll($params = [])
    {
        try {
            
            /*************************
             * Parameters extraction *
             *************************/
            
            /**********************
             * Custom validations *
             **********************/
            
            /**************************
             * Input data preparation *
             **************************/
            
            /**********************
             * Action realization *
             **********************/
            
            $result = $this->sm->get(ConsulatesEmbassiesTable::class)->fetchAllPais($params);
            $titulo = $this->sm->get(ConsulatesAndEmbasiesTitleTable::class)->fetchAll([])->data;
            
            /***************************
             * Output data preparation *
             ***************************/

            $result2 = null;

            foreach($titulo as $k => $v){
                foreach($result->data as $k2 => $v2){
                    if($v2['frmIdIdioma'] == $v['frmIdIdioma']){
                        $result2['subtitulo'][] = [
                            [
                                'tipo' => 'id',
                                'valor' => $v2['frmIdPaisConsuladoEmbajada']
                            ],
                            [
                                'tipo' => 'texto',
                                'valor' => $v2['frmNombreConsuladoEmbajada']
                            ],
                            [
                                'tipo' => 'imagen',
                                'valor' => "img/banderas/" .$v2['frmBanderaConsuladoEmbajada']
                            ]
                        ];
                    }
                }
                if(@$result2['subtitulo']){
                    $cons[] = [
                        "frmIdConsuladosEmbajadas" => $v['frmIdTituloConsulados'],
                            "frmIdIdioma" => $v['frmIdIdioma'],
                            "frmBasePath" => (empty($_SERVER['HTTPS']) ? 'http' : 'https') . "://$_SERVER[HTTP_HOST]/",
                            "frmContenidoConsuladosEmbajadas" => [
                                "menu" => "Directorios",
                                "subMenu" => $v['frmContenidoTituloConsulados'],
                                "contenido" => $result2
                            ],
                            "frmActivoConsuladosEmbajadas" => "1"
                        ];
                }
            }

            $response = [
                "totalRecords" => count($cons),
                "data" => $cons
                
            ];
            
            $body = $response;
            
            /********************
             * Response sending *
             ********************/
            
            return $this->getResponse(200, $body);
            
        } catch (\Exception $e) {
            return $this->getServerError($e);
        }
    }

    /**
     * Patch (partial in-place update) a resource
     *
     * @param  mixed $id
     * @param  mixed $data
     * @return ApiProblem|mixed
     */
    public function patch($id, $data)
    {
        return new ApiProblem(405, 'The PATCH method has not been defined for individual resources');
    }

    /**
     * Patch (partial in-place update) a collection or members of a collection
     *
     * @param  mixed $data
     * @return ApiProblem|mixed
     */
    public function patchList($data)
    {
        return new ApiProblem(405, 'The PATCH method has not been defined for collections');
    }

    /**
     * Replace a collection or members of a collection
     *
     * @param  mixed $data
     * @return ApiProblem|mixed
     */
    public function replaceList($data)
    {
        return new ApiProblem(405, 'The PUT method has not been defined for collections');
    }

    /**
     * Update a resource
     *
     * @param  mixed $id
     * @param  mixed $data
     * @return ApiProblem|mixed
     */
    public function update($id, $data)
    {
        return new ApiProblem(405, 'The PUT method has not been defined for individual resources');
    }
}
