<?php
namespace Api\V1\Rest\AsesoriaLegalForm;

use Application\Library\Api\Resource;
use Laminas\ApiTools\ApiProblem\ApiProblem;
use Laminas\ApiTools\Rest\AbstractResourceListener;
use Laminas\Stdlib\Parameters;

class AsesoriaLegalFormResource extends Resource
{
    /**
     * Create a resource
     *
     * @param  mixed $data
     * @return ApiProblem|mixed
     */
    public function create($data)
    {
        return new ApiProblem(405, 'The POST method has not been defined');
    }

    /**
     * Delete a resource
     *
     * @param  mixed $id
     * @return ApiProblem|mixed
     */
    public function delete($id)
    {
        return new ApiProblem(405, 'The DELETE method has not been defined for individual resources');
    }

    /**
     * Delete a collection, or members of a collection
     *
     * @param  mixed $data
     * @return ApiProblem|mixed
     */
    public function deleteList($data)
    {
        return new ApiProblem(405, 'The DELETE method has not been defined for collections');
    }

    /**
     * Fetch a resource
     *
     * @param  mixed $id
     * @return ApiProblem|mixed
     */
    public function fetch($id)
    {
        return new ApiProblem(405, 'The GET method has not been defined for individual resources');
    }

    /**
     * Fetch all or a subset of resources
     *
     * @param  array|Parameters $params
     * @return ApiProblem|mixed
     */
    public function fetchAll($params = [])
    {
        try {
            
            /*************************
             * Parameters extraction *
             *************************/
            
            /**********************
             * Custom validations *
             **********************/
            
            /**************************
             * Input data preparation *
             **************************/
            
            /**********************
             * Action realization *
             **********************/

            $result = [
                [
                    'type' => 'text',
                    'name' => 'frmNombreCompleto',
                    'options' => [
                        'label' => '* Nombre',
                        'required' => 'true'
                    ],
                    'attributes' => [
                        'id' => 'frmNombre',
                        'class' => 'formControl',
                        'placeholder' => 'Nombre'
                    ]
                ],
                [
                    'type' => 'select',
                    'name' => 'frmIdGenero',
                    'options' => [
                        'label' => '* Sexo',
                        'required' => 'true',
                        'empty_option' => 'Seleccione sexo...'
                    ],
                    'attributes' => [
                        'id' => 'frmIdGenero',
                        'class' => 'formControl'
                    ]
                ],
                [
                    'type' => 'select',
                    'name' => 'frmIdNacionalidad',
                    'options' => [
                        'label' => '* Nacionalidad',
                        'required' => 'true',
                        'empty_option' => 'Seleccione nacionalidad...'
                    ],
                    'attributes' => [
                        'id' => 'frmIdNacionalidad',
                        'class' => 'formControl'
                    ]
                ],
                [
                    'type' => 'text',
                    'name' => 'frmNumeroTelefonico',
                    'options' => [
                        'label' => '* Teléfono celular',
                        'required' => 'true'
                    ],
                    'attributes' => [
                        'id' => 'frmNumeroTelefonico',
                        'class' => 'formControl',
                        'placeholder' => 'Teléfono celular'
                    ]
                ],
                [
                    'type' => 'text',
                    'name' => 'frmCorreoElectronico',
                    'options' => [
                        'label' => '* Correo electrónico',
                        'required' => 'true'
                    ],
                    'attributes' => [
                        'id' => 'frmCorreoElectronico',
                        'class' => 'formControl',
                        'placeholder' => 'Correo electrónico'
                    ]
                ],
                [
                    'type' => 'text',
                    'name' => 'frmDestino',
                    'options' => [
                        'label' => '* Destino',
                        'required' => 'true'
                    ],
                    'attributes' => [
                        'id' => 'frmDestino',
                        'class' => 'formControl',
                        'placeholder' => 'Destino donde se encuentra'
                    ]
                ],
                [
                    'type' => 'text',
                    'name' => 'frmHotel',
                    'options' => [
                        'label' => 'Hotel'
                    ],
                    'attributes' => [
                        'id' => 'frmHotel',
                        'class' => 'formControl',
                        'placeholder' => 'Hotel donde se encuentra hospedado'
                    ]
                ],
                [
                    'type' => 'text',
                    'name' => 'frmNumeroHabitacion',
                    'options' => [
                        'label' => 'Número de habitación'
                    ],
                    'attributes' => [
                        'id' => 'frmNumeroHabitacion',
                        'class' => 'formControl',
                        'placeholder' => 'Número de habitación'
                    ]
                ],
                [
                    'type' => 'textArea',
                    'name' => 'frmMensaje',
                    'options' => [
                        'label' => '* Mensaje',
                        'required' => 'true'
                    ],
                    'attributes' => [
                        'id' => 'frmNumeroHabitacion',
                        'class' => 'formControl',
                        'placeholder' => 'Mensaje'
                    ]
                ],
            ];

            /***************************
             * Output data preparation *
             ***************************/
            
            $body = $result;
            
            /********************
             * Response sending *
             ********************/
            
            return $this->getResponse(200, $body);
            
        } catch (\Exception $e) {
            return $this->getServerError($e);
        }
    }

    /**
     * Patch (partial in-place update) a resource
     *
     * @param  mixed $id
     * @param  mixed $data
     * @return ApiProblem|mixed
     */
    public function patch($id, $data)
    {
        return new ApiProblem(405, 'The PATCH method has not been defined for individual resources');
    }

    /**
     * Patch (partial in-place update) a collection or members of a collection
     *
     * @param  mixed $data
     * @return ApiProblem|mixed
     */
    public function patchList($data)
    {
        return new ApiProblem(405, 'The PATCH method has not been defined for collections');
    }

    /**
     * Replace a collection or members of a collection
     *
     * @param  mixed $data
     * @return ApiProblem|mixed
     */
    public function replaceList($data)
    {
        return new ApiProblem(405, 'The PUT method has not been defined for collections');
    }

    /**
     * Update a resource
     *
     * @param  mixed $id
     * @param  mixed $data
     * @return ApiProblem|mixed
     */
    public function update($id, $data)
    {
        return new ApiProblem(405, 'The PUT method has not been defined for individual resources');
    }
}
