<?php
return [
    'service_manager' => [
        'factories' => [
            \Api\V1\Rest\Authentication\AuthenticationResource::class => \Api\V1\Rest\Authentication\AuthenticationResourceFactory::class,
            \Api\V1\Rest\Refresh\RefreshResource::class => \Api\V1\Rest\Refresh\RefreshResourceFactory::class,
            \Api\V1\Rest\Users\UsersResource::class => \Api\V1\Rest\Users\UsersResourceFactory::class,
            \Api\V1\Rest\UsersPrivileges\UsersPrivilegesResource::class => \Api\V1\Rest\UsersPrivileges\UsersPrivilegesResourceFactory::class,
            \Api\V1\Rest\Profiles\ProfilesResource::class => \Api\V1\Rest\Profiles\ProfilesResourceFactory::class,
            \Api\V1\Rest\ProfilesPrivileges\ProfilesPrivilegesResource::class => \Api\V1\Rest\ProfilesPrivileges\ProfilesPrivilegesResourceFactory::class,
            \Api\V1\Rest\Menus\MenusResource::class => \Api\V1\Rest\Menus\MenusResourceFactory::class,
            \Api\V1\Rest\States\StatesResource::class => \Api\V1\Rest\States\StatesResourceFactory::class,
            \Api\V1\Rest\Municipalities\MunicipalitiesResource::class => \Api\V1\Rest\Municipalities\MunicipalitiesResourceFactory::class,
            \Api\V1\Rest\Neighborhoods\NeighborhoodsResource::class => \Api\V1\Rest\Neighborhoods\NeighborhoodsResourceFactory::class,
            \Api\V1\Rest\Employees\EmployeesResource::class => \Api\V1\Rest\Employees\EmployeesResourceFactory::class,
            \Api\V1\Rest\AcercaDe\AcercaDeResource::class => \Api\V1\Rest\AcercaDe\AcercaDeResourceFactory::class,
            \Api\V1\Rest\Recomendaciones\RecomendacionesResource::class => \Api\V1\Rest\Recomendaciones\RecomendacionesResourceFactory::class,
            \Api\V1\Rest\AvisoPrivacidad\AvisoPrivacidadResource::class => \Api\V1\Rest\AvisoPrivacidad\AvisoPrivacidadResourceFactory::class,
            \Api\V1\Rest\TerminosYCondiciones\TerminosYCondicionesResource::class => \Api\V1\Rest\TerminosYCondiciones\TerminosYCondicionesResourceFactory::class,
            \Api\V1\Rest\RoboExtravioPasaporte\RoboExtravioPasaporteResource::class => \Api\V1\Rest\RoboExtravioPasaporte\RoboExtravioPasaporteResourceFactory::class,
            \Api\V1\Rest\QuejasContraPrestadores\QuejasContraPrestadoresResource::class => \Api\V1\Rest\QuejasContraPrestadores\QuejasContraPrestadoresResourceFactory::class,
            \Api\V1\Rest\QuejasFraudeCibernetico\QuejasFraudeCiberneticoResource::class => \Api\V1\Rest\QuejasFraudeCibernetico\QuejasFraudeCiberneticoResourceFactory::class,
            \Api\V1\Rest\ReporteRobo\ReporteRoboResource::class => \Api\V1\Rest\ReporteRobo\ReporteRoboResourceFactory::class,
            \Api\V1\Rest\TarjetaCreditoClonada\TarjetaCreditoClonadaResource::class => \Api\V1\Rest\TarjetaCreditoClonada\TarjetaCreditoClonadaResourceFactory::class,
            \Api\V1\Rest\AsesoriaLegal\AsesoriaLegalResource::class => \Api\V1\Rest\AsesoriaLegal\AsesoriaLegalResourceFactory::class,
            \Api\V1\Rest\AsistenciaMedica\AsistenciaMedicaResource::class => \Api\V1\Rest\AsistenciaMedica\AsistenciaMedicaResourceFactory::class,
            \Api\V1\Rest\Emergencias\EmergenciasResource::class => \Api\V1\Rest\Emergencias\EmergenciasResourceFactory::class,
            \Api\V1\Rest\PoliciaFederal\PoliciaFederalResource::class => \Api\V1\Rest\PoliciaFederal\PoliciaFederalResourceFactory::class,
            \Api\V1\Rest\DenunciaAnonima\DenunciaAnonimaResource::class => \Api\V1\Rest\DenunciaAnonima\DenunciaAnonimaResourceFactory::class,
            \Api\V1\Rest\InformacionTuristica\InformacionTuristicaResource::class => \Api\V1\Rest\InformacionTuristica\InformacionTuristicaResourceFactory::class,
            \Api\V1\Rest\InfoCovid\InfoCovidResource::class => \Api\V1\Rest\InfoCovid\InfoCovidResourceFactory::class,
            \Api\V1\Rest\CallCenter\CallCenterResource::class => \Api\V1\Rest\CallCenter\CallCenterResourceFactory::class,
            \Api\V1\Rest\MedidasPrevencion\MedidasPrevencionResource::class => \Api\V1\Rest\MedidasPrevencion\MedidasPrevencionResourceFactory::class,
            \Api\V1\Rest\PruebasCovid\PruebasCovidResource::class => \Api\V1\Rest\PruebasCovid\PruebasCovidResourceFactory::class,
            \Api\V1\Rest\CertificacionSanitaria\CertificacionSanitariaResource::class => \Api\V1\Rest\CertificacionSanitaria\CertificacionSanitariaResourceFactory::class,
            \Api\V1\Rest\ConsuladosYEmbajadas\ConsuladosYEmbajadasResource::class => \Api\V1\Rest\ConsuladosYEmbajadas\ConsuladosYEmbajadasResourceFactory::class,
            \Api\V1\Rest\Fiscalias\FiscaliasResource::class => \Api\V1\Rest\Fiscalias\FiscaliasResourceFactory::class,
            \Api\V1\Rest\Nacionalidades\NacionalidadesResource::class => \Api\V1\Rest\Nacionalidades\NacionalidadesResourceFactory::class,
            \Api\V1\Rest\Hospitales\HospitalesResource::class => \Api\V1\Rest\Hospitales\HospitalesResourceFactory::class,
            \Api\V1\Rest\Generos\GenerosResource::class => \Api\V1\Rest\Generos\GenerosResourceFactory::class,
            \Api\V1\Rest\NumeroCallCenter\NumeroCallCenterResource::class => \Api\V1\Rest\NumeroCallCenter\NumeroCallCenterResourceFactory::class,
            \Api\V1\Rest\PrestadoresServicios\PrestadoresServiciosResource::class => \Api\V1\Rest\PrestadoresServicios\PrestadoresServiciosResourceFactory::class,
            \Api\V1\Rest\DestinosTuristicos\DestinosTuristicosResource::class => \Api\V1\Rest\DestinosTuristicos\DestinosTuristicosResourceFactory::class,
            \Api\V1\Rest\MotivosQueja\MotivosQuejaResource::class => \Api\V1\Rest\MotivosQueja\MotivosQuejaResourceFactory::class,
            \Api\V1\Rest\Footer\FooterResource::class => \Api\V1\Rest\Footer\FooterResourceFactory::class,
            \Api\V1\Rest\Idiomas\IdiomasResource::class => \Api\V1\Rest\Idiomas\IdiomasResourceFactory::class,
            \Api\V1\Rest\Login\LoginResource::class => \Api\V1\Rest\Login\LoginResourceFactory::class,
            \Api\V1\Rest\Registro\RegistroResource::class => \Api\V1\Rest\Registro\RegistroResourceFactory::class,
            \Api\V1\Rest\FiscaliasIcono\FiscaliasIconoResource::class => \Api\V1\Rest\FiscaliasIcono\FiscaliasIconoResourceFactory::class,
            \Api\V1\Rest\AsesoriaLegalForm\AsesoriaLegalFormResource::class => \Api\V1\Rest\AsesoriaLegalForm\AsesoriaLegalFormResourceFactory::class,
            \Api\V1\Rest\QuejasForm\QuejasFormResource::class => \Api\V1\Rest\QuejasForm\QuejasFormResourceFactory::class,
            \Api\V1\Rest\Inicio\InicioResource::class => \Api\V1\Rest\Inicio\InicioResourceFactory::class,
            \Api\V1\Rest\ReporteTrazabilidad\ReporteTrazabilidadResource::class => \Api\V1\Rest\ReporteTrazabilidad\ReporteTrazabilidadResourceFactory::class,
            \Api\V1\Rest\ValidateUid\ValidateUidResource::class => \Api\V1\Rest\ValidateUid\ValidateUidResourceFactory::class,
            \Api\V1\Rest\UsuariosRedesSociales\UsuariosRedesSocialesResource::class => \Api\V1\Rest\UsuariosRedesSociales\UsuariosRedesSocialesResourceFactory::class,
            \Api\V1\Rest\Banner\BannerResource::class => \Api\V1\Rest\Banner\BannerResourceFactory::class,
            \Api\V1\Rest\AccesosDirectos\AccesosDirectosResource::class => \Api\V1\Rest\AccesosDirectos\AccesosDirectosResourceFactory::class,
            \Api\V1\Rest\MenuPublico\MenuPublicoResource::class => \Api\V1\Rest\MenuPublico\MenuPublicoResourceFactory::class,
            \Api\V1\Rest\Etiquetas\EtiquetasResource::class => \Api\V1\Rest\Etiquetas\EtiquetasResourceFactory::class,
        ],
    ],
    'router' => [
        'routes' => [
            'api.rest.authentication' => [
                'type' => 'Segment',
                'options' => [
                    'route' => '/authentication[/:authentication_id]',
                    'defaults' => [
                        'controller' => 'Api\\V1\\Rest\\Authentication\\Controller',
                    ],
                ],
            ],
            'api.rest.refresh' => [
                'type' => 'Segment',
                'options' => [
                    'route' => '/refresh[/:refresh_id]',
                    'defaults' => [
                        'controller' => 'Api\\V1\\Rest\\Refresh\\Controller',
                    ],
                ],
            ],
            'api.rest.users' => [
                'type' => 'Segment',
                'options' => [
                    'route' => '/users[/:users_id]',
                    'defaults' => [
                        'controller' => 'Api\\V1\\Rest\\Users\\Controller',
                    ],
                ],
            ],
            'api.rest.users-privileges' => [
                'type' => 'Segment',
                'options' => [
                    'route' => '/users-privileges[/:users_privileges_id]',
                    'defaults' => [
                        'controller' => 'Api\\V1\\Rest\\UsersPrivileges\\Controller',
                    ],
                ],
            ],
            'api.rest.profiles' => [
                'type' => 'Segment',
                'options' => [
                    'route' => '/profiles[/:profiles_id]',
                    'defaults' => [
                        'controller' => 'Api\\V1\\Rest\\Profiles\\Controller',
                    ],
                ],
            ],
            'api.rest.profiles-privileges' => [
                'type' => 'Segment',
                'options' => [
                    'route' => '/profiles-privileges[/:profiles_privileges_id]',
                    'defaults' => [
                        'controller' => 'Api\\V1\\Rest\\ProfilesPrivileges\\Controller',
                    ],
                ],
            ],
            'api.rest.menus' => [
                'type' => 'Segment',
                'options' => [
                    'route' => '/menus[/:menus_id]',
                    'defaults' => [
                        'controller' => 'Api\\V1\\Rest\\Menus\\Controller',
                    ],
                ],
            ],
            'api.rest.states' => [
                'type' => 'Segment',
                'options' => [
                    'route' => '/states[/:states_id]',
                    'defaults' => [
                        'controller' => 'Api\\V1\\Rest\\States\\Controller',
                    ],
                ],
            ],
            'api.rest.municipalities' => [
                'type' => 'Segment',
                'options' => [
                    'route' => '/municipalities[/:municipalities_id]',
                    'defaults' => [
                        'controller' => 'Api\\V1\\Rest\\Municipalities\\Controller',
                    ],
                ],
            ],
            'api.rest.neighborhoods' => [
                'type' => 'Segment',
                'options' => [
                    'route' => '/neighborhoods[/:neighborhoods_id]',
                    'defaults' => [
                        'controller' => 'Api\\V1\\Rest\\Neighborhoods\\Controller',
                    ],
                ],
            ],
            'api.rest.employees' => [
                'type' => 'Segment',
                'options' => [
                    'route' => '/employees[/:employees_id]',
                    'defaults' => [
                        'controller' => 'Api\\V1\\Rest\\Employees\\Controller',
                    ],
                ],
            ],
            'api.rest.acerca-de' => [
                'type' => 'Segment',
                'options' => [
                    'route' => '/acerca-de[/:acerca_de_id]',
                    'defaults' => [
                        'controller' => 'Api\\V1\\Rest\\AcercaDe\\Controller',
                    ],
                ],
            ],
            'api.rest.recomendaciones' => [
                'type' => 'Segment',
                'options' => [
                    'route' => '/recomendaciones[/:recomendaciones_id]',
                    'defaults' => [
                        'controller' => 'Api\\V1\\Rest\\Recomendaciones\\Controller',
                    ],
                ],
            ],
            'api.rest.aviso-privacidad' => [
                'type' => 'Segment',
                'options' => [
                    'route' => '/aviso-privacidad[/:aviso_privacidad_id]',
                    'defaults' => [
                        'controller' => 'Api\\V1\\Rest\\AvisoPrivacidad\\Controller',
                    ],
                ],
            ],
            'api.rest.terminos-y-condiciones' => [
                'type' => 'Segment',
                'options' => [
                    'route' => '/terminos-y-condiciones[/:terminos_y_condiciones_id]',
                    'defaults' => [
                        'controller' => 'Api\\V1\\Rest\\TerminosYCondiciones\\Controller',
                    ],
                ],
            ],
            'api.rest.robo-extravio-pasaporte' => [
                'type' => 'Segment',
                'options' => [
                    'route' => '/robo-extravio-pasaporte[/:robo_extravio_pasaporte_id]',
                    'defaults' => [
                        'controller' => 'Api\\V1\\Rest\\RoboExtravioPasaporte\\Controller',
                    ],
                ],
            ],
            'api.rest.quejas-contra-prestadores' => [
                'type' => 'Segment',
                'options' => [
                    'route' => '/quejas-contra-prestadores[/:quejas_contra_prestadores_id]',
                    'defaults' => [
                        'controller' => 'Api\\V1\\Rest\\QuejasContraPrestadores\\Controller',
                    ],
                ],
            ],
            'api.rest.quejas-fraude-cibernetico' => [
                'type' => 'Segment',
                'options' => [
                    'route' => '/quejas-fraude-cibernetico[/:quejas_fraude_cibernetico_id]',
                    'defaults' => [
                        'controller' => 'Api\\V1\\Rest\\QuejasFraudeCibernetico\\Controller',
                    ],
                ],
            ],
            'api.rest.reporte-robo' => [
                'type' => 'Segment',
                'options' => [
                    'route' => '/reporte-robo[/:reporte_robo_id]',
                    'defaults' => [
                        'controller' => 'Api\\V1\\Rest\\ReporteRobo\\Controller',
                    ],
                ],
            ],
            'api.rest.tarjeta-credito-clonada' => [
                'type' => 'Segment',
                'options' => [
                    'route' => '/tarjeta-credito-clonada[/:tarjeta_credito_clonada_id]',
                    'defaults' => [
                        'controller' => 'Api\\V1\\Rest\\TarjetaCreditoClonada\\Controller',
                    ],
                ],
            ],
            'api.rest.asesoria-legal' => [
                'type' => 'Segment',
                'options' => [
                    'route' => '/asesoria-legal[/:asesoria_legal_id]',
                    'defaults' => [
                        'controller' => 'Api\\V1\\Rest\\AsesoriaLegal\\Controller',
                    ],
                ],
            ],
            'api.rest.asistencia-medica' => [
                'type' => 'Segment',
                'options' => [
                    'route' => '/asistencia-medica[/:asistencia_medica_id]',
                    'defaults' => [
                        'controller' => 'Api\\V1\\Rest\\AsistenciaMedica\\Controller',
                    ],
                ],
            ],
            'api.rest.emergencias' => [
                'type' => 'Segment',
                'options' => [
                    'route' => '/emergencias[/:emergencias_id]',
                    'defaults' => [
                        'controller' => 'Api\\V1\\Rest\\Emergencias\\Controller',
                    ],
                ],
            ],
            'api.rest.policia-federal' => [
                'type' => 'Segment',
                'options' => [
                    'route' => '/policia-federal[/:policia_federal_id]',
                    'defaults' => [
                        'controller' => 'Api\\V1\\Rest\\PoliciaFederal\\Controller',
                    ],
                ],
            ],
            'api.rest.denuncia-anonima' => [
                'type' => 'Segment',
                'options' => [
                    'route' => '/denuncia-anonima[/:denuncia_anonima_id]',
                    'defaults' => [
                        'controller' => 'Api\\V1\\Rest\\DenunciaAnonima\\Controller',
                    ],
                ],
            ],
            'api.rest.informacion-turistica' => [
                'type' => 'Segment',
                'options' => [
                    'route' => '/informacion-turistica[/:informacion_turistica_id]',
                    'defaults' => [
                        'controller' => 'Api\\V1\\Rest\\InformacionTuristica\\Controller',
                    ],
                ],
            ],
            'api.rest.info-covid' => [
                'type' => 'Segment',
                'options' => [
                    'route' => '/info-covid[/:info_covid_id]',
                    'defaults' => [
                        'controller' => 'Api\\V1\\Rest\\InfoCovid\\Controller',
                    ],
                ],
            ],
            'api.rest.call-center' => [
                'type' => 'Segment',
                'options' => [
                    'route' => '/call-center[/:call_center_id]',
                    'defaults' => [
                        'controller' => 'Api\\V1\\Rest\\CallCenter\\Controller',
                    ],
                ],
            ],
            'api.rest.medidas-prevencion' => [
                'type' => 'Segment',
                'options' => [
                    'route' => '/medidas-prevencion[/:medidas_prevencion_id]',
                    'defaults' => [
                        'controller' => 'Api\\V1\\Rest\\MedidasPrevencion\\Controller',
                    ],
                ],
            ],
            'api.rest.pruebas-covid' => [
                'type' => 'Segment',
                'options' => [
                    'route' => '/pruebas-covid[/:pruebas_covid_id]',
                    'defaults' => [
                        'controller' => 'Api\\V1\\Rest\\PruebasCovid\\Controller',
                    ],
                ],
            ],
            'api.rest.certificacion-sanitaria' => [
                'type' => 'Segment',
                'options' => [
                    'route' => '/certificacion-sanitaria[/:certificacion_sanitaria_id]',
                    'defaults' => [
                        'controller' => 'Api\\V1\\Rest\\CertificacionSanitaria\\Controller',
                    ],
                ],
            ],
            'api.rest.consulados-y-embajadas' => [
                'type' => 'Segment',
                'options' => [
                    'route' => '/consulados-y-embajadas[/:consulados_y_embajadas_id]',
                    'defaults' => [
                        'controller' => 'Api\\V1\\Rest\\ConsuladosYEmbajadas\\Controller',
                    ],
                ],
            ],
            'api.rest.fiscalias' => [
                'type' => 'Segment',
                'options' => [
                    'route' => '/fiscalias[/:fiscalias_id]',
                    'defaults' => [
                        'controller' => 'Api\\V1\\Rest\\Fiscalias\\Controller',
                    ],
                ],
            ],
            'api.rest.nacionalidades' => [
                'type' => 'Segment',
                'options' => [
                    'route' => '/nacionalidades[/:nacionalidades_id]',
                    'defaults' => [
                        'controller' => 'Api\\V1\\Rest\\Nacionalidades\\Controller',
                    ],
                ],
            ],
            'api.rest.hospitales' => [
                'type' => 'Segment',
                'options' => [
                    'route' => '/hospitales[/:hospitales_id]',
                    'defaults' => [
                        'controller' => 'Api\\V1\\Rest\\Hospitales\\Controller',
                    ],
                ],
            ],
            'api.rest.generos' => [
                'type' => 'Segment',
                'options' => [
                    'route' => '/generos[/:generos_id]',
                    'defaults' => [
                        'controller' => 'Api\\V1\\Rest\\Generos\\Controller',
                    ],
                ],
            ],
            'api.rest.numero-call-center' => [
                'type' => 'Segment',
                'options' => [
                    'route' => '/numero-call-center[/:numero_call_center_id]',
                    'defaults' => [
                        'controller' => 'Api\\V1\\Rest\\NumeroCallCenter\\Controller',
                    ],
                ],
            ],
            'api.rest.prestadores-servicios' => [
                'type' => 'Segment',
                'options' => [
                    'route' => '/prestadores-servicios[/:prestadores_servicios_id]',
                    'defaults' => [
                        'controller' => 'Api\\V1\\Rest\\PrestadoresServicios\\Controller',
                    ],
                ],
            ],
            'api.rest.destinos-turisticos' => [
                'type' => 'Segment',
                'options' => [
                    'route' => '/destinos-turisticos[/:destinos_turisticos_id]',
                    'defaults' => [
                        'controller' => 'Api\\V1\\Rest\\DestinosTuristicos\\Controller',
                    ],
                ],
            ],
            'api.rest.motivos-queja' => [
                'type' => 'Segment',
                'options' => [
                    'route' => '/motivos-queja[/:motivos_queja_id]',
                    'defaults' => [
                        'controller' => 'Api\\V1\\Rest\\MotivosQueja\\Controller',
                    ],
                ],
            ],
            'api.rest.footer' => [
                'type' => 'Segment',
                'options' => [
                    'route' => '/footer[/:footer_id]',
                    'defaults' => [
                        'controller' => 'Api\\V1\\Rest\\Footer\\Controller',
                    ],
                ],
            ],
            'api.rest.idiomas' => [
                'type' => 'Segment',
                'options' => [
                    'route' => '/idiomas[/:idiomas_id]',
                    'defaults' => [
                        'controller' => 'Api\\V1\\Rest\\Idiomas\\Controller',
                    ],
                ],
            ],
            'api.rest.login' => [
                'type' => 'Segment',
                'options' => [
                    'route' => '/login[/:login_id]',
                    'defaults' => [
                        'controller' => 'Api\\V1\\Rest\\Login\\Controller',
                    ],
                ],
            ],
            'api.rest.registro' => [
                'type' => 'Segment',
                'options' => [
                    'route' => '/registro[/:registro_id]',
                    'defaults' => [
                        'controller' => 'Api\\V1\\Rest\\Registro\\Controller',
                    ],
                ],
            ],
            'api.rest.fiscalias-icono' => [
                'type' => 'Segment',
                'options' => [
                    'route' => '/fiscalias-icono[/:fiscalias_icono_id]',
                    'defaults' => [
                        'controller' => 'Api\\V1\\Rest\\FiscaliasIcono\\Controller',
                    ],
                ],
            ],
            'api.rest.asesoria-legal-form' => [
                'type' => 'Segment',
                'options' => [
                    'route' => '/asesoria-legal-form[/:asesoria_legal_form_id]',
                    'defaults' => [
                        'controller' => 'Api\\V1\\Rest\\AsesoriaLegalForm\\Controller',
                    ],
                ],
            ],
            'api.rest.quejas-form' => [
                'type' => 'Segment',
                'options' => [
                    'route' => '/quejas-form[/:quejas_form_id]',
                    'defaults' => [
                        'controller' => 'Api\\V1\\Rest\\QuejasForm\\Controller',
                    ],
                ],
            ],
            'api.rest.inicio' => [
                'type' => 'Segment',
                'options' => [
                    'route' => '/inicio[/:inicio_id]',
                    'defaults' => [
                        'controller' => 'Api\\V1\\Rest\\Inicio\\Controller',
                    ],
                ],
            ],
            'api.rest.reporte-trazabilidad' => [
                'type' => 'Segment',
                'options' => [
                    'route' => '/reporte-trazabilidad[/:reporte_trazabilidad_id]',
                    'defaults' => [
                        'controller' => 'Api\\V1\\Rest\\ReporteTrazabilidad\\Controller',
                    ],
                ],
            ],
            'api.rest.validate-uid' => [
                'type' => 'Segment',
                'options' => [
                    'route' => '/validate-uid[/:validate_uid_id]',
                    'defaults' => [
                        'controller' => 'Api\\V1\\Rest\\ValidateUid\\Controller',
                    ],
                ],
            ],
            'api.rest.usuarios-redes-sociales' => [
                'type' => 'Segment',
                'options' => [
                    'route' => '/usuarios-redes-sociales[/:usuarios_redes_sociales_id]',
                    'defaults' => [
                        'controller' => 'Api\\V1\\Rest\\UsuariosRedesSociales\\Controller',
                    ],
                ],
            ],
            'api.rest.banner' => [
                'type' => 'Segment',
                'options' => [
                    'route' => '/banner[/:banner_id]',
                    'defaults' => [
                        'controller' => 'Api\\V1\\Rest\\Banner\\Controller',
                    ],
                ],
            ],
            'api.rest.accesos-directos' => [
                'type' => 'Segment',
                'options' => [
                    'route' => '/accesos-directos[/:accesos_directos_id]',
                    'defaults' => [
                        'controller' => 'Api\\V1\\Rest\\AccesosDirectos\\Controller',
                    ],
                ],
            ],
            'api.rest.menu-publico' => [
                'type' => 'Segment',
                'options' => [
                    'route' => '/menu-publico[/:menu_publico_id]',
                    'defaults' => [
                        'controller' => 'Api\\V1\\Rest\\MenuPublico\\Controller',
                    ],
                ],
            ],
            'api.rest.etiquetas' => [
                'type' => 'Segment',
                'options' => [
                    'route' => '/etiquetas[/:etiquetas_id]',
                    'defaults' => [
                        'controller' => 'Api\\V1\\Rest\\Etiquetas\\Controller',
                    ],
                ],
            ],
        ],
    ],
    'api-tools-versioning' => [
        'uri' => [
            0 => 'api.rest.authentication',
            1 => 'api.rest.refresh',
            2 => 'api.rest.users',
            3 => 'api.rest.users-privileges',
            4 => 'api.rest.profiles',
            5 => 'api.rest.profiles-privileges',
            7 => 'api.rest.menus',
            11 => 'api.rest.states',
            12 => 'api.rest.municipalities',
            15 => 'api.rest.neighborhoods',
            18 => 'api.rest.employees',
            19 => 'api.rest.acerca-de',
            20 => 'api.rest.recomendaciones',
            21 => 'api.rest.aviso-privacidad',
            22 => 'api.rest.terminos-y-condiciones',
            23 => 'api.rest.robo-extravio-pasaporte',
            24 => 'api.rest.quejas-contra-prestadores',
            25 => 'api.rest.quejas-fraude-cibernetico',
            26 => 'api.rest.reporte-robo',
            27 => 'api.rest.tarjeta-credito-clonada',
            28 => 'api.rest.asesoria-legal',
            29 => 'api.rest.asistencia-medica',
            30 => 'api.rest.emergencias',
            31 => 'api.rest.policia-federal',
            32 => 'api.rest.denuncia-anonima',
            33 => 'api.rest.informacion-turistica',
            34 => 'api.rest.info-covid',
            35 => 'api.rest.call-center',
            36 => 'api.rest.medidas-prevencion',
            37 => 'api.rest.pruebas-covid',
            38 => 'api.rest.certificacion-sanitaria',
            40 => 'api.rest.consulados-y-embajadas',
            41 => 'api.rest.fiscalias',
            42 => 'api.rest.nacionalidades',
            43 => 'api.rest.hospitales',
            44 => 'api.rest.generos',
            45 => 'api.rest.numero-call-center',
            46 => 'api.rest.prestadores-servicios',
            47 => 'api.rest.destinos-turisticos',
            48 => 'api.rest.motivos-queja',
            49 => 'api.rest.footer',
            51 => 'api.rest.idiomas',
            52 => 'api.rest.login',
            53 => 'api.rest.registro',
            54 => 'api.rest.fiscalias-icono',
            55 => 'api.rest.asesoria-legal-form',
            56 => 'api.rest.quejas-form',
            57 => 'api.rest.inicio',
            58 => 'api.rest.reporte-trazabilidad',
            59 => 'api.rest.validate-uid',
            60 => 'api.rest.usuarios-redes-sociales',
            61 => 'api.rest.banner',
            62 => 'api.rest.accesos-directos',
            63 => 'api.rest.menu-publico',
            64 => 'api.rest.etiquetas',
        ],
    ],
    'api-tools-rest' => [
        'Api\\V1\\Rest\\Authentication\\Controller' => [
            'listener' => \Api\V1\Rest\Authentication\AuthenticationResource::class,
            'route_name' => 'api.rest.authentication',
            'route_identifier_name' => 'authentication_id',
            'collection_name' => 'authentication',
            'entity_http_methods' => [],
            'collection_http_methods' => [],
            'collection_query_whitelist' => [],
            'page_size' => 25,
            'page_size_param' => null,
            'entity_class' => \Api\V1\Rest\Authentication\AuthenticationEntity::class,
            'collection_class' => \Api\V1\Rest\Authentication\AuthenticationCollection::class,
            'service_name' => 'authentication',
        ],
        'Api\\V1\\Rest\\Refresh\\Controller' => [
            'listener' => \Api\V1\Rest\Refresh\RefreshResource::class,
            'route_name' => 'api.rest.refresh',
            'route_identifier_name' => 'refresh_id',
            'collection_name' => 'refresh',
            'entity_http_methods' => [],
            'collection_http_methods' => [
                0 => 'POST',
            ],
            'collection_query_whitelist' => [],
            'page_size' => 25,
            'page_size_param' => null,
            'entity_class' => \Api\V1\Rest\Refresh\RefreshEntity::class,
            'collection_class' => \Api\V1\Rest\Refresh\RefreshCollection::class,
            'service_name' => 'refresh',
        ],
        'Api\\V1\\Rest\\Users\\Controller' => [
            'listener' => \Api\V1\Rest\Users\UsersResource::class,
            'route_name' => 'api.rest.users',
            'route_identifier_name' => 'users_id',
            'collection_name' => 'users',
            'entity_http_methods' => [
                0 => 'GET',
                1 => 'PUT',
                2 => 'DELETE',
                3 => 'PATCH',
            ],
            'collection_http_methods' => [
                0 => 'GET',
                1 => 'POST',
            ],
            'collection_query_whitelist' => [
                0 => 'select',
                1 => 'where',
                2 => 'order',
                3 => 'limit',
                4 => 'offset',
            ],
            'page_size' => 25,
            'page_size_param' => null,
            'entity_class' => \Api\V1\Rest\Users\UsersEntity::class,
            'collection_class' => \Api\V1\Rest\Users\UsersCollection::class,
            'service_name' => 'users',
        ],
        'Api\\V1\\Rest\\UsersPrivileges\\Controller' => [
            'listener' => \Api\V1\Rest\UsersPrivileges\UsersPrivilegesResource::class,
            'route_name' => 'api.rest.users-privileges',
            'route_identifier_name' => 'users_privileges_id',
            'collection_name' => 'users_privileges',
            'entity_http_methods' => [],
            'collection_http_methods' => [
                0 => 'GET',
            ],
            'collection_query_whitelist' => [
                0 => 'select',
                1 => 'where',
                2 => 'order',
                3 => 'limit',
                4 => 'offset',
            ],
            'page_size' => 25,
            'page_size_param' => null,
            'entity_class' => \Api\V1\Rest\UsersPrivileges\UsersPrivilegesEntity::class,
            'collection_class' => \Api\V1\Rest\UsersPrivileges\UsersPrivilegesCollection::class,
            'service_name' => 'usersPrivileges',
        ],
        'Api\\V1\\Rest\\Profiles\\Controller' => [
            'listener' => \Api\V1\Rest\Profiles\ProfilesResource::class,
            'route_name' => 'api.rest.profiles',
            'route_identifier_name' => 'profiles_id',
            'collection_name' => 'profiles',
            'entity_http_methods' => [
                0 => 'GET',
                1 => 'PUT',
                2 => 'DELETE',
            ],
            'collection_http_methods' => [
                0 => 'GET',
                1 => 'POST',
            ],
            'collection_query_whitelist' => [
                0 => 'select',
                1 => 'where',
                2 => 'order',
                3 => 'limit',
                4 => 'offset',
            ],
            'page_size' => 25,
            'page_size_param' => null,
            'entity_class' => \Api\V1\Rest\Profiles\ProfilesEntity::class,
            'collection_class' => \Api\V1\Rest\Profiles\ProfilesCollection::class,
            'service_name' => 'profiles',
        ],
        'Api\\V1\\Rest\\ProfilesPrivileges\\Controller' => [
            'listener' => \Api\V1\Rest\ProfilesPrivileges\ProfilesPrivilegesResource::class,
            'route_name' => 'api.rest.profiles-privileges',
            'route_identifier_name' => 'profiles_privileges_id',
            'collection_name' => 'profiles_privileges',
            'entity_http_methods' => [],
            'collection_http_methods' => [
                0 => 'GET',
            ],
            'collection_query_whitelist' => [
                0 => 'select',
                1 => 'where',
                2 => 'order',
                3 => 'limit',
                4 => 'offset',
            ],
            'page_size' => 25,
            'page_size_param' => null,
            'entity_class' => \Api\V1\Rest\ProfilesPrivileges\ProfilesPrivilegesEntity::class,
            'collection_class' => \Api\V1\Rest\ProfilesPrivileges\ProfilesPrivilegesCollection::class,
            'service_name' => 'profilesPrivileges',
        ],
        'Api\\V1\\Rest\\Menus\\Controller' => [
            'listener' => \Api\V1\Rest\Menus\MenusResource::class,
            'route_name' => 'api.rest.menus',
            'route_identifier_name' => 'menus_id',
            'collection_name' => 'menus',
            'entity_http_methods' => [
                0 => 'GET',
                1 => 'PATCH',
                2 => 'PUT',
                3 => 'DELETE',
            ],
            'collection_http_methods' => [
                0 => 'GET',
                1 => 'POST',
            ],
            'collection_query_whitelist' => [
                0 => 'select',
                1 => 'where',
                2 => 'order',
                3 => 'limit',
                4 => 'offset',
            ],
            'page_size' => 25,
            'page_size_param' => null,
            'entity_class' => \Api\V1\Rest\Menus\MenusEntity::class,
            'collection_class' => \Api\V1\Rest\Menus\MenusCollection::class,
            'service_name' => 'menus',
        ],
        'Api\\V1\\Rest\\States\\Controller' => [
            'listener' => \Api\V1\Rest\States\StatesResource::class,
            'route_name' => 'api.rest.states',
            'route_identifier_name' => 'states_id',
            'collection_name' => 'states',
            'entity_http_methods' => [
                0 => 'GET',
                1 => 'PATCH',
                2 => 'PUT',
                3 => 'DELETE',
            ],
            'collection_http_methods' => [
                0 => 'GET',
                1 => 'POST',
            ],
            'collection_query_whitelist' => [
                0 => 'select',
                1 => 'where',
                2 => 'order',
                3 => 'limit',
                4 => 'offset',
            ],
            'page_size' => 25,
            'page_size_param' => null,
            'entity_class' => \Api\V1\Rest\States\StatesEntity::class,
            'collection_class' => \Api\V1\Rest\States\StatesCollection::class,
            'service_name' => 'states',
        ],
        'Api\\V1\\Rest\\Municipalities\\Controller' => [
            'listener' => \Api\V1\Rest\Municipalities\MunicipalitiesResource::class,
            'route_name' => 'api.rest.municipalities',
            'route_identifier_name' => 'municipalities_id',
            'collection_name' => 'municipalities',
            'entity_http_methods' => [
                0 => 'GET',
                1 => 'PATCH',
                2 => 'PUT',
                3 => 'DELETE',
            ],
            'collection_http_methods' => [
                0 => 'GET',
                1 => 'POST',
            ],
            'collection_query_whitelist' => [
                0 => 'select',
                1 => 'where',
                2 => 'order',
                3 => 'limit',
                4 => 'offset',
            ],
            'page_size' => 25,
            'page_size_param' => null,
            'entity_class' => \Api\V1\Rest\Municipalities\MunicipalitiesEntity::class,
            'collection_class' => \Api\V1\Rest\Municipalities\MunicipalitiesCollection::class,
            'service_name' => 'municipalities',
        ],
        'Api\\V1\\Rest\\Neighborhoods\\Controller' => [
            'listener' => \Api\V1\Rest\Neighborhoods\NeighborhoodsResource::class,
            'route_name' => 'api.rest.neighborhoods',
            'route_identifier_name' => 'neighborhoods_id',
            'collection_name' => 'neighborhoods',
            'entity_http_methods' => [
                0 => 'GET',
                1 => 'PATCH',
                2 => 'PUT',
                3 => 'DELETE',
            ],
            'collection_http_methods' => [
                0 => 'GET',
                1 => 'POST',
            ],
            'collection_query_whitelist' => [
                0 => 'select',
                1 => 'where',
                2 => 'order',
                3 => 'limit',
                4 => 'offset',
            ],
            'page_size' => 25,
            'page_size_param' => null,
            'entity_class' => \Api\V1\Rest\Neighborhoods\NeighborhoodsEntity::class,
            'collection_class' => \Api\V1\Rest\Neighborhoods\NeighborhoodsCollection::class,
            'service_name' => 'neighborhoods',
        ],
        'Api\\V1\\Rest\\Employees\\Controller' => [
            'listener' => \Api\V1\Rest\Employees\EmployeesResource::class,
            'route_name' => 'api.rest.employees',
            'route_identifier_name' => 'employees_id',
            'collection_name' => 'employees',
            'entity_http_methods' => [
                0 => 'GET',
                1 => 'PATCH',
                2 => 'PUT',
                3 => 'DELETE',
            ],
            'collection_http_methods' => [
                0 => 'GET',
                1 => 'POST',
            ],
            'collection_query_whitelist' => [
                0 => 'select',
                1 => 'where',
                2 => 'order',
                3 => 'offset',
                4 => 'limit',
            ],
            'page_size' => 25,
            'page_size_param' => null,
            'entity_class' => \Api\V1\Rest\Employees\EmployeesEntity::class,
            'collection_class' => \Api\V1\Rest\Employees\EmployeesCollection::class,
            'service_name' => 'employees',
        ],
        'Api\\V1\\Rest\\AcercaDe\\Controller' => [
            'listener' => \Api\V1\Rest\AcercaDe\AcercaDeResource::class,
            'route_name' => 'api.rest.acerca-de',
            'route_identifier_name' => 'acerca_de_id',
            'collection_name' => 'acerca_de',
            'entity_http_methods' => [
                0 => 'GET',
            ],
            'collection_http_methods' => [
                0 => 'GET',
            ],
            'collection_query_whitelist' => [
                0 => 'select',
                1 => 'where',
                2 => 'order',
                3 => 'offset',
                4 => 'limit',
            ],
            'page_size' => 25,
            'page_size_param' => null,
            'entity_class' => \Api\V1\Rest\AcercaDe\AcercaDeEntity::class,
            'collection_class' => \Api\V1\Rest\AcercaDe\AcercaDeCollection::class,
            'service_name' => 'acercaDe',
        ],
        'Api\\V1\\Rest\\Recomendaciones\\Controller' => [
            'listener' => \Api\V1\Rest\Recomendaciones\RecomendacionesResource::class,
            'route_name' => 'api.rest.recomendaciones',
            'route_identifier_name' => 'recomendaciones_id',
            'collection_name' => 'recomendaciones',
            'entity_http_methods' => [
                0 => 'GET',
            ],
            'collection_http_methods' => [
                0 => 'GET',
            ],
            'collection_query_whitelist' => [
                0 => 'select',
                1 => 'where',
                2 => 'order',
                3 => 'offset',
                4 => 'limit',
            ],
            'page_size' => 25,
            'page_size_param' => null,
            'entity_class' => \Api\V1\Rest\Recomendaciones\RecomendacionesEntity::class,
            'collection_class' => \Api\V1\Rest\Recomendaciones\RecomendacionesCollection::class,
            'service_name' => 'recomendaciones',
        ],
        'Api\\V1\\Rest\\AvisoPrivacidad\\Controller' => [
            'listener' => \Api\V1\Rest\AvisoPrivacidad\AvisoPrivacidadResource::class,
            'route_name' => 'api.rest.aviso-privacidad',
            'route_identifier_name' => 'aviso_privacidad_id',
            'collection_name' => 'aviso_privacidad',
            'entity_http_methods' => [
                0 => 'GET',
            ],
            'collection_http_methods' => [
                0 => 'GET',
            ],
            'collection_query_whitelist' => [
                0 => 'select',
                1 => 'where',
                2 => 'order',
                3 => 'offset',
                4 => 'limit',
            ],
            'page_size' => 25,
            'page_size_param' => null,
            'entity_class' => \Api\V1\Rest\AvisoPrivacidad\AvisoPrivacidadEntity::class,
            'collection_class' => \Api\V1\Rest\AvisoPrivacidad\AvisoPrivacidadCollection::class,
            'service_name' => 'avisoPrivacidad',
        ],
        'Api\\V1\\Rest\\TerminosYCondiciones\\Controller' => [
            'listener' => \Api\V1\Rest\TerminosYCondiciones\TerminosYCondicionesResource::class,
            'route_name' => 'api.rest.terminos-y-condiciones',
            'route_identifier_name' => 'terminos_y_condiciones_id',
            'collection_name' => 'terminos_y_condiciones',
            'entity_http_methods' => [
                0 => 'GET',
            ],
            'collection_http_methods' => [
                0 => 'GET',
            ],
            'collection_query_whitelist' => [
                0 => 'select',
                1 => 'where',
                2 => 'order',
                3 => 'offset',
                4 => 'limit',
            ],
            'page_size' => 25,
            'page_size_param' => null,
            'entity_class' => \Api\V1\Rest\TerminosYCondiciones\TerminosYCondicionesEntity::class,
            'collection_class' => \Api\V1\Rest\TerminosYCondiciones\TerminosYCondicionesCollection::class,
            'service_name' => 'terminosYCondiciones',
        ],
        'Api\\V1\\Rest\\RoboExtravioPasaporte\\Controller' => [
            'listener' => \Api\V1\Rest\RoboExtravioPasaporte\RoboExtravioPasaporteResource::class,
            'route_name' => 'api.rest.robo-extravio-pasaporte',
            'route_identifier_name' => 'robo_extravio_pasaporte_id',
            'collection_name' => 'robo_extravio_pasaporte',
            'entity_http_methods' => [
                0 => 'GET',
            ],
            'collection_http_methods' => [
                0 => 'GET',
            ],
            'collection_query_whitelist' => [
                0 => 'select',
                1 => 'where',
                2 => 'order',
                3 => 'offset',
                4 => 'limit',
            ],
            'page_size' => 25,
            'page_size_param' => null,
            'entity_class' => \Api\V1\Rest\RoboExtravioPasaporte\RoboExtravioPasaporteEntity::class,
            'collection_class' => \Api\V1\Rest\RoboExtravioPasaporte\RoboExtravioPasaporteCollection::class,
            'service_name' => 'roboExtravioPasaporte',
        ],
        'Api\\V1\\Rest\\QuejasContraPrestadores\\Controller' => [
            'listener' => \Api\V1\Rest\QuejasContraPrestadores\QuejasContraPrestadoresResource::class,
            'route_name' => 'api.rest.quejas-contra-prestadores',
            'route_identifier_name' => 'quejas_contra_prestadores_id',
            'collection_name' => 'quejas_contra_prestadores',
            'entity_http_methods' => [
                0 => 'GET',
            ],
            'collection_http_methods' => [
                0 => 'GET',
            ],
            'collection_query_whitelist' => [
                0 => 'select',
                1 => 'where',
                2 => 'order',
                3 => 'offset',
                4 => 'limit',
            ],
            'page_size' => 25,
            'page_size_param' => null,
            'entity_class' => \Api\V1\Rest\QuejasContraPrestadores\QuejasContraPrestadoresEntity::class,
            'collection_class' => \Api\V1\Rest\QuejasContraPrestadores\QuejasContraPrestadoresCollection::class,
            'service_name' => 'quejasContraPrestadores',
        ],
        'Api\\V1\\Rest\\QuejasFraudeCibernetico\\Controller' => [
            'listener' => \Api\V1\Rest\QuejasFraudeCibernetico\QuejasFraudeCiberneticoResource::class,
            'route_name' => 'api.rest.quejas-fraude-cibernetico',
            'route_identifier_name' => 'quejas_fraude_cibernetico_id',
            'collection_name' => 'quejas_fraude_cibernetico',
            'entity_http_methods' => [
                0 => 'GET',
            ],
            'collection_http_methods' => [
                0 => 'GET',
            ],
            'collection_query_whitelist' => [
                0 => 'select',
                1 => 'where',
                2 => 'order',
                3 => 'offset',
                4 => 'limit',
            ],
            'page_size' => 25,
            'page_size_param' => null,
            'entity_class' => \Api\V1\Rest\QuejasFraudeCibernetico\QuejasFraudeCiberneticoEntity::class,
            'collection_class' => \Api\V1\Rest\QuejasFraudeCibernetico\QuejasFraudeCiberneticoCollection::class,
            'service_name' => 'quejasFraudeCibernetico',
        ],
        'Api\\V1\\Rest\\ReporteRobo\\Controller' => [
            'listener' => \Api\V1\Rest\ReporteRobo\ReporteRoboResource::class,
            'route_name' => 'api.rest.reporte-robo',
            'route_identifier_name' => 'reporte_robo_id',
            'collection_name' => 'reporte_robo',
            'entity_http_methods' => [
                0 => 'GET',
            ],
            'collection_http_methods' => [
                0 => 'GET',
            ],
            'collection_query_whitelist' => [
                0 => 'select',
                1 => 'where',
                2 => 'order',
                3 => 'offset',
                4 => 'limit',
            ],
            'page_size' => 25,
            'page_size_param' => null,
            'entity_class' => \Api\V1\Rest\ReporteRobo\ReporteRoboEntity::class,
            'collection_class' => \Api\V1\Rest\ReporteRobo\ReporteRoboCollection::class,
            'service_name' => 'reporteRobo',
        ],
        'Api\\V1\\Rest\\TarjetaCreditoClonada\\Controller' => [
            'listener' => \Api\V1\Rest\TarjetaCreditoClonada\TarjetaCreditoClonadaResource::class,
            'route_name' => 'api.rest.tarjeta-credito-clonada',
            'route_identifier_name' => 'tarjeta_credito_clonada_id',
            'collection_name' => 'tarjeta_credito_clonada',
            'entity_http_methods' => [
                0 => 'GET',
            ],
            'collection_http_methods' => [
                0 => 'GET',
            ],
            'collection_query_whitelist' => [
                0 => 'select',
                1 => 'where',
                2 => 'order',
                3 => 'offset',
                4 => 'limit',
            ],
            'page_size' => 25,
            'page_size_param' => null,
            'entity_class' => \Api\V1\Rest\TarjetaCreditoClonada\TarjetaCreditoClonadaEntity::class,
            'collection_class' => \Api\V1\Rest\TarjetaCreditoClonada\TarjetaCreditoClonadaCollection::class,
            'service_name' => 'tarjetaCreditoClonada',
        ],
        'Api\\V1\\Rest\\AsesoriaLegal\\Controller' => [
            'listener' => \Api\V1\Rest\AsesoriaLegal\AsesoriaLegalResource::class,
            'route_name' => 'api.rest.asesoria-legal',
            'route_identifier_name' => 'asesoria_legal_id',
            'collection_name' => 'asesoria_legal',
            'entity_http_methods' => [
                0 => 'GET',
            ],
            'collection_http_methods' => [
                0 => 'GET',
            ],
            'collection_query_whitelist' => [
                0 => 'select',
                1 => 'where',
                2 => 'order',
                3 => 'offset',
                4 => 'limit',
            ],
            'page_size' => 25,
            'page_size_param' => null,
            'entity_class' => \Api\V1\Rest\AsesoriaLegal\AsesoriaLegalEntity::class,
            'collection_class' => \Api\V1\Rest\AsesoriaLegal\AsesoriaLegalCollection::class,
            'service_name' => 'asesoriaLegal',
        ],
        'Api\\V1\\Rest\\AsistenciaMedica\\Controller' => [
            'listener' => \Api\V1\Rest\AsistenciaMedica\AsistenciaMedicaResource::class,
            'route_name' => 'api.rest.asistencia-medica',
            'route_identifier_name' => 'asistencia_medica_id',
            'collection_name' => 'asistencia_medica',
            'entity_http_methods' => [
                0 => 'GET',
            ],
            'collection_http_methods' => [
                0 => 'GET',
            ],
            'collection_query_whitelist' => [
                0 => 'select',
                1 => 'where',
                2 => 'order',
                3 => 'offset',
                4 => 'limit',
            ],
            'page_size' => 25,
            'page_size_param' => null,
            'entity_class' => \Api\V1\Rest\AsistenciaMedica\AsistenciaMedicaEntity::class,
            'collection_class' => \Api\V1\Rest\AsistenciaMedica\AsistenciaMedicaCollection::class,
            'service_name' => 'asistenciaMedica',
        ],
        'Api\\V1\\Rest\\Emergencias\\Controller' => [
            'listener' => \Api\V1\Rest\Emergencias\EmergenciasResource::class,
            'route_name' => 'api.rest.emergencias',
            'route_identifier_name' => 'emergencias_id',
            'collection_name' => 'emergencias',
            'entity_http_methods' => [
                0 => 'GET',
            ],
            'collection_http_methods' => [
                0 => 'GET',
            ],
            'collection_query_whitelist' => [
                0 => 'select',
                1 => 'where',
                2 => 'order',
                3 => 'offset',
                4 => 'limit',
            ],
            'page_size' => 25,
            'page_size_param' => null,
            'entity_class' => \Api\V1\Rest\Emergencias\EmergenciasEntity::class,
            'collection_class' => \Api\V1\Rest\Emergencias\EmergenciasCollection::class,
            'service_name' => 'emergencias',
        ],
        'Api\\V1\\Rest\\PoliciaFederal\\Controller' => [
            'listener' => \Api\V1\Rest\PoliciaFederal\PoliciaFederalResource::class,
            'route_name' => 'api.rest.policia-federal',
            'route_identifier_name' => 'policia_federal_id',
            'collection_name' => 'policia_federal',
            'entity_http_methods' => [
                0 => 'GET',
            ],
            'collection_http_methods' => [
                0 => 'GET',
            ],
            'collection_query_whitelist' => [
                0 => 'select',
                1 => 'where',
                2 => 'order',
                3 => 'offset',
                4 => 'limit',
            ],
            'page_size' => 25,
            'page_size_param' => null,
            'entity_class' => \Api\V1\Rest\PoliciaFederal\PoliciaFederalEntity::class,
            'collection_class' => \Api\V1\Rest\PoliciaFederal\PoliciaFederalCollection::class,
            'service_name' => 'policiaFederal',
        ],
        'Api\\V1\\Rest\\DenunciaAnonima\\Controller' => [
            'listener' => \Api\V1\Rest\DenunciaAnonima\DenunciaAnonimaResource::class,
            'route_name' => 'api.rest.denuncia-anonima',
            'route_identifier_name' => 'denuncia_anonima_id',
            'collection_name' => 'denuncia_anonima',
            'entity_http_methods' => [
                0 => 'GET',
            ],
            'collection_http_methods' => [
                0 => 'GET',
            ],
            'collection_query_whitelist' => [
                0 => 'select',
                1 => 'where',
                2 => 'order',
                3 => 'offset',
                4 => 'limit',
            ],
            'page_size' => 25,
            'page_size_param' => null,
            'entity_class' => \Api\V1\Rest\DenunciaAnonima\DenunciaAnonimaEntity::class,
            'collection_class' => \Api\V1\Rest\DenunciaAnonima\DenunciaAnonimaCollection::class,
            'service_name' => 'denunciaAnonima',
        ],
        'Api\\V1\\Rest\\InformacionTuristica\\Controller' => [
            'listener' => \Api\V1\Rest\InformacionTuristica\InformacionTuristicaResource::class,
            'route_name' => 'api.rest.informacion-turistica',
            'route_identifier_name' => 'informacion_turistica_id',
            'collection_name' => 'informacion_turistica',
            'entity_http_methods' => [
                0 => 'GET',
            ],
            'collection_http_methods' => [
                0 => 'GET',
            ],
            'collection_query_whitelist' => [
                0 => 'select',
                1 => 'where',
                2 => 'order',
                3 => 'offset',
                4 => 'limit',
            ],
            'page_size' => 25,
            'page_size_param' => null,
            'entity_class' => \Api\V1\Rest\InformacionTuristica\InformacionTuristicaEntity::class,
            'collection_class' => \Api\V1\Rest\InformacionTuristica\InformacionTuristicaCollection::class,
            'service_name' => 'informacionTuristica',
        ],
        'Api\\V1\\Rest\\InfoCovid\\Controller' => [
            'listener' => \Api\V1\Rest\InfoCovid\InfoCovidResource::class,
            'route_name' => 'api.rest.info-covid',
            'route_identifier_name' => 'info_covid_id',
            'collection_name' => 'info_covid',
            'entity_http_methods' => [
                0 => 'GET',
            ],
            'collection_http_methods' => [
                0 => 'GET',
            ],
            'collection_query_whitelist' => [
                0 => 'select',
                1 => 'where',
                2 => 'order',
                3 => 'offset',
                4 => 'limit',
            ],
            'page_size' => 25,
            'page_size_param' => null,
            'entity_class' => \Api\V1\Rest\InfoCovid\InfoCovidEntity::class,
            'collection_class' => \Api\V1\Rest\InfoCovid\InfoCovidCollection::class,
            'service_name' => 'infoCovid',
        ],
        'Api\\V1\\Rest\\CallCenter\\Controller' => [
            'listener' => \Api\V1\Rest\CallCenter\CallCenterResource::class,
            'route_name' => 'api.rest.call-center',
            'route_identifier_name' => 'call_center_id',
            'collection_name' => 'call_center',
            'entity_http_methods' => [],
            'collection_http_methods' => [
                0 => 'GET',
            ],
            'collection_query_whitelist' => [
                0 => 'select',
                1 => 'where',
                2 => 'order',
                3 => 'offset',
                4 => 'limit',
            ],
            'page_size' => 25,
            'page_size_param' => null,
            'entity_class' => \Api\V1\Rest\CallCenter\CallCenterEntity::class,
            'collection_class' => \Api\V1\Rest\CallCenter\CallCenterCollection::class,
            'service_name' => 'callCenter',
        ],
        'Api\\V1\\Rest\\MedidasPrevencion\\Controller' => [
            'listener' => \Api\V1\Rest\MedidasPrevencion\MedidasPrevencionResource::class,
            'route_name' => 'api.rest.medidas-prevencion',
            'route_identifier_name' => 'medidas_prevencion_id',
            'collection_name' => 'medidas_prevencion',
            'entity_http_methods' => [
                0 => 'GET',
            ],
            'collection_http_methods' => [
                0 => 'GET',
            ],
            'collection_query_whitelist' => [
                0 => 'select',
                1 => 'where',
                2 => 'order',
                3 => 'offset',
                4 => 'limit',
            ],
            'page_size' => 25,
            'page_size_param' => null,
            'entity_class' => \Api\V1\Rest\MedidasPrevencion\MedidasPrevencionEntity::class,
            'collection_class' => \Api\V1\Rest\MedidasPrevencion\MedidasPrevencionCollection::class,
            'service_name' => 'medidasPrevencion',
        ],
        'Api\\V1\\Rest\\PruebasCovid\\Controller' => [
            'listener' => \Api\V1\Rest\PruebasCovid\PruebasCovidResource::class,
            'route_name' => 'api.rest.pruebas-covid',
            'route_identifier_name' => 'pruebas_covid_id',
            'collection_name' => 'pruebas_covid',
            'entity_http_methods' => [
                0 => 'GET',
                1 => 'PATCH',
                2 => 'PUT',
                3 => 'DELETE',
            ],
            'collection_http_methods' => [
                0 => 'GET',
                1 => 'POST',
            ],
            'collection_query_whitelist' => [],
            'page_size' => 25,
            'page_size_param' => null,
            'entity_class' => \Api\V1\Rest\PruebasCovid\PruebasCovidEntity::class,
            'collection_class' => \Api\V1\Rest\PruebasCovid\PruebasCovidCollection::class,
            'service_name' => 'pruebasCovid',
        ],
        'Api\\V1\\Rest\\CertificacionSanitaria\\Controller' => [
            'listener' => \Api\V1\Rest\CertificacionSanitaria\CertificacionSanitariaResource::class,
            'route_name' => 'api.rest.certificacion-sanitaria',
            'route_identifier_name' => 'certificacion_sanitaria_id',
            'collection_name' => 'certificacion_sanitaria',
            'entity_http_methods' => [
                0 => 'GET',
            ],
            'collection_http_methods' => [
                0 => 'GET',
            ],
            'collection_query_whitelist' => [
                0 => 'select',
                1 => 'where',
                2 => 'order',
                3 => 'offset',
                4 => 'limit',
            ],
            'page_size' => 25,
            'page_size_param' => null,
            'entity_class' => \Api\V1\Rest\CertificacionSanitaria\CertificacionSanitariaEntity::class,
            'collection_class' => \Api\V1\Rest\CertificacionSanitaria\CertificacionSanitariaCollection::class,
            'service_name' => 'certificacionSanitaria',
        ],
        'Api\\V1\\Rest\\ConsuladosYEmbajadas\\Controller' => [
            'listener' => \Api\V1\Rest\ConsuladosYEmbajadas\ConsuladosYEmbajadasResource::class,
            'route_name' => 'api.rest.consulados-y-embajadas',
            'route_identifier_name' => 'consulados_y_embajadas_id',
            'collection_name' => 'consulados_y_embajadas',
            'entity_http_methods' => [
                0 => 'GET',
            ],
            'collection_http_methods' => [
                0 => 'GET',
            ],
            'collection_query_whitelist' => [
                0 => 'select',
                1 => 'where',
                2 => 'order',
                3 => 'offset',
                4 => 'limit',
            ],
            'page_size' => 25,
            'page_size_param' => null,
            'entity_class' => \Api\V1\Rest\ConsuladosYEmbajadas\ConsuladosYEmbajadasEntity::class,
            'collection_class' => \Api\V1\Rest\ConsuladosYEmbajadas\ConsuladosYEmbajadasCollection::class,
            'service_name' => 'consuladosYEmbajadas',
        ],
        'Api\\V1\\Rest\\Fiscalias\\Controller' => [
            'listener' => \Api\V1\Rest\Fiscalias\FiscaliasResource::class,
            'route_name' => 'api.rest.fiscalias',
            'route_identifier_name' => 'fiscalias_id',
            'collection_name' => 'fiscalias',
            'entity_http_methods' => [
                0 => 'GET',
            ],
            'collection_http_methods' => [
                0 => 'GET',
            ],
            'collection_query_whitelist' => [
                0 => 'select',
                1 => 'where',
                2 => 'order',
                3 => 'offset',
                4 => 'limit',
            ],
            'page_size' => 25,
            'page_size_param' => null,
            'entity_class' => \Api\V1\Rest\Fiscalias\FiscaliasEntity::class,
            'collection_class' => \Api\V1\Rest\Fiscalias\FiscaliasCollection::class,
            'service_name' => 'fiscalias',
        ],
        'Api\\V1\\Rest\\Nacionalidades\\Controller' => [
            'listener' => \Api\V1\Rest\Nacionalidades\NacionalidadesResource::class,
            'route_name' => 'api.rest.nacionalidades',
            'route_identifier_name' => 'nacionalidades_id',
            'collection_name' => 'nacionalidades',
            'entity_http_methods' => [],
            'collection_http_methods' => [
                0 => 'GET',
            ],
            'collection_query_whitelist' => [
                0 => 'select',
                1 => 'where',
                2 => 'order',
                3 => 'offset',
                4 => 'limit',
            ],
            'page_size' => 25,
            'page_size_param' => null,
            'entity_class' => \Api\V1\Rest\Nacionalidades\NacionalidadesEntity::class,
            'collection_class' => \Api\V1\Rest\Nacionalidades\NacionalidadesCollection::class,
            'service_name' => 'nacionalidades',
        ],
        'Api\\V1\\Rest\\Hospitales\\Controller' => [
            'listener' => \Api\V1\Rest\Hospitales\HospitalesResource::class,
            'route_name' => 'api.rest.hospitales',
            'route_identifier_name' => 'hospitales_id',
            'collection_name' => 'hospitales',
            'entity_http_methods' => [
                0 => 'GET',
            ],
            'collection_http_methods' => [
                0 => 'GET',
            ],
            'collection_query_whitelist' => [
                0 => 'select',
                1 => 'where',
                2 => 'order',
                3 => 'offset',
                4 => 'limit',
            ],
            'page_size' => 25,
            'page_size_param' => null,
            'entity_class' => \Api\V1\Rest\Hospitales\HospitalesEntity::class,
            'collection_class' => \Api\V1\Rest\Hospitales\HospitalesCollection::class,
            'service_name' => 'hospitales',
        ],
        'Api\\V1\\Rest\\Generos\\Controller' => [
            'listener' => \Api\V1\Rest\Generos\GenerosResource::class,
            'route_name' => 'api.rest.generos',
            'route_identifier_name' => 'generos_id',
            'collection_name' => 'generos',
            'entity_http_methods' => [
                0 => 'GET',
            ],
            'collection_http_methods' => [
                0 => 'GET',
            ],
            'collection_query_whitelist' => [
                0 => 'select',
                1 => 'where',
                2 => 'order',
                3 => 'offset',
                4 => 'limit',
            ],
            'page_size' => 25,
            'page_size_param' => null,
            'entity_class' => \Api\V1\Rest\Generos\GenerosEntity::class,
            'collection_class' => \Api\V1\Rest\Generos\GenerosCollection::class,
            'service_name' => 'generos',
        ],
        'Api\\V1\\Rest\\NumeroCallCenter\\Controller' => [
            'listener' => \Api\V1\Rest\NumeroCallCenter\NumeroCallCenterResource::class,
            'route_name' => 'api.rest.numero-call-center',
            'route_identifier_name' => 'numero_call_center_id',
            'collection_name' => 'numero_call_center',
            'entity_http_methods' => [],
            'collection_http_methods' => [
                0 => 'GET',
            ],
            'collection_query_whitelist' => [
                0 => 'select',
                1 => 'where',
                2 => 'order',
                3 => 'offset',
                4 => 'limit',
            ],
            'page_size' => 25,
            'page_size_param' => null,
            'entity_class' => \Api\V1\Rest\NumeroCallCenter\NumeroCallCenterEntity::class,
            'collection_class' => \Api\V1\Rest\NumeroCallCenter\NumeroCallCenterCollection::class,
            'service_name' => 'numeroCallCenter',
        ],
        'Api\\V1\\Rest\\PrestadoresServicios\\Controller' => [
            'listener' => \Api\V1\Rest\PrestadoresServicios\PrestadoresServiciosResource::class,
            'route_name' => 'api.rest.prestadores-servicios',
            'route_identifier_name' => 'prestadores_servicios_id',
            'collection_name' => 'prestadores_servicios',
            'entity_http_methods' => [
                0 => 'GET',
            ],
            'collection_http_methods' => [
                0 => 'GET',
            ],
            'collection_query_whitelist' => [
                0 => 'select',
                1 => 'where',
                2 => 'order',
                3 => 'offset',
                4 => 'limit',
            ],
            'page_size' => 25,
            'page_size_param' => null,
            'entity_class' => \Api\V1\Rest\PrestadoresServicios\PrestadoresServiciosEntity::class,
            'collection_class' => \Api\V1\Rest\PrestadoresServicios\PrestadoresServiciosCollection::class,
            'service_name' => 'prestadoresServicios',
        ],
        'Api\\V1\\Rest\\DestinosTuristicos\\Controller' => [
            'listener' => \Api\V1\Rest\DestinosTuristicos\DestinosTuristicosResource::class,
            'route_name' => 'api.rest.destinos-turisticos',
            'route_identifier_name' => 'destinos_turisticos_id',
            'collection_name' => 'destinos_turisticos',
            'entity_http_methods' => [
                0 => 'GET',
            ],
            'collection_http_methods' => [
                0 => 'GET',
            ],
            'collection_query_whitelist' => [
                0 => 'select',
                1 => 'where',
                2 => 'order',
                3 => 'offset',
                4 => 'limit',
            ],
            'page_size' => 25,
            'page_size_param' => null,
            'entity_class' => \Api\V1\Rest\DestinosTuristicos\DestinosTuristicosEntity::class,
            'collection_class' => \Api\V1\Rest\DestinosTuristicos\DestinosTuristicosCollection::class,
            'service_name' => 'destinosTuristicos',
        ],
        'Api\\V1\\Rest\\MotivosQueja\\Controller' => [
            'listener' => \Api\V1\Rest\MotivosQueja\MotivosQuejaResource::class,
            'route_name' => 'api.rest.motivos-queja',
            'route_identifier_name' => 'motivos_queja_id',
            'collection_name' => 'motivos_queja',
            'entity_http_methods' => [
                0 => 'GET',
                1 => 'PATCH',
                2 => 'PUT',
                3 => 'DELETE',
            ],
            'collection_http_methods' => [
                0 => 'GET',
                1 => 'POST',
            ],
            'collection_query_whitelist' => [],
            'page_size' => 25,
            'page_size_param' => null,
            'entity_class' => \Api\V1\Rest\MotivosQueja\MotivosQuejaEntity::class,
            'collection_class' => \Api\V1\Rest\MotivosQueja\MotivosQuejaCollection::class,
            'service_name' => 'motivosQueja',
        ],
        'Api\\V1\\Rest\\Footer\\Controller' => [
            'listener' => \Api\V1\Rest\Footer\FooterResource::class,
            'route_name' => 'api.rest.footer',
            'route_identifier_name' => 'footer_id',
            'collection_name' => 'footer',
            'entity_http_methods' => [
                0 => 'GET',
            ],
            'collection_http_methods' => [
                0 => 'GET',
            ],
            'collection_query_whitelist' => [
                0 => 'select',
                1 => 'where',
                2 => 'order',
                3 => 'offset',
                4 => 'limit',
            ],
            'page_size' => 25,
            'page_size_param' => null,
            'entity_class' => \Api\V1\Rest\Footer\FooterEntity::class,
            'collection_class' => \Api\V1\Rest\Footer\FooterCollection::class,
            'service_name' => 'footer',
        ],
        'Api\\V1\\Rest\\Idiomas\\Controller' => [
            'listener' => \Api\V1\Rest\Idiomas\IdiomasResource::class,
            'route_name' => 'api.rest.idiomas',
            'route_identifier_name' => 'idiomas_id',
            'collection_name' => 'idiomas',
            'entity_http_methods' => [
                0 => 'GET',
                1 => 'PATCH',
                2 => 'PUT',
                3 => 'DELETE',
            ],
            'collection_http_methods' => [
                0 => 'GET',
                1 => 'POST',
            ],
            'collection_query_whitelist' => [],
            'page_size' => 25,
            'page_size_param' => null,
            'entity_class' => \Api\V1\Rest\Idiomas\IdiomasEntity::class,
            'collection_class' => \Api\V1\Rest\Idiomas\IdiomasCollection::class,
            'service_name' => 'idiomas',
        ],
        'Api\\V1\\Rest\\Login\\Controller' => [
            'listener' => \Api\V1\Rest\Login\LoginResource::class,
            'route_name' => 'api.rest.login',
            'route_identifier_name' => 'login_id',
            'collection_name' => 'login',
            'entity_http_methods' => [],
            'collection_http_methods' => [
                0 => 'POST',
                1 => 'GET',
            ],
            'collection_query_whitelist' => [],
            'page_size' => 25,
            'page_size_param' => null,
            'entity_class' => \Api\V1\Rest\Login\LoginEntity::class,
            'collection_class' => \Api\V1\Rest\Login\LoginCollection::class,
            'service_name' => 'login',
        ],
        'Api\\V1\\Rest\\Registro\\Controller' => [
            'listener' => \Api\V1\Rest\Registro\RegistroResource::class,
            'route_name' => 'api.rest.registro',
            'route_identifier_name' => 'registro_id',
            'collection_name' => 'registro',
            'entity_http_methods' => [],
            'collection_http_methods' => [
                0 => 'POST',
            ],
            'collection_query_whitelist' => [],
            'page_size' => 25,
            'page_size_param' => null,
            'entity_class' => \Api\V1\Rest\Registro\RegistroEntity::class,
            'collection_class' => \Api\V1\Rest\Registro\RegistroCollection::class,
            'service_name' => 'registro',
        ],
        'Api\\V1\\Rest\\FiscaliasIcono\\Controller' => [
            'listener' => \Api\V1\Rest\FiscaliasIcono\FiscaliasIconoResource::class,
            'route_name' => 'api.rest.fiscalias-icono',
            'route_identifier_name' => 'fiscalias_icono_id',
            'collection_name' => 'fiscalias_icono',
            'entity_http_methods' => [],
            'collection_http_methods' => [
                0 => 'GET',
            ],
            'collection_query_whitelist' => [
                0 => 'select',
                1 => 'where',
                2 => 'order',
                3 => 'offset',
                4 => 'limit',
            ],
            'page_size' => 25,
            'page_size_param' => null,
            'entity_class' => \Api\V1\Rest\FiscaliasIcono\FiscaliasIconoEntity::class,
            'collection_class' => \Api\V1\Rest\FiscaliasIcono\FiscaliasIconoCollection::class,
            'service_name' => 'fiscaliasIcono',
        ],
        'Api\\V1\\Rest\\AsesoriaLegalForm\\Controller' => [
            'listener' => \Api\V1\Rest\AsesoriaLegalForm\AsesoriaLegalFormResource::class,
            'route_name' => 'api.rest.asesoria-legal-form',
            'route_identifier_name' => 'asesoria_legal_form_id',
            'collection_name' => 'asesoria_legal_form',
            'entity_http_methods' => [],
            'collection_http_methods' => [
                0 => 'GET',
            ],
            'collection_query_whitelist' => [],
            'page_size' => 25,
            'page_size_param' => null,
            'entity_class' => \Api\V1\Rest\AsesoriaLegalForm\AsesoriaLegalFormEntity::class,
            'collection_class' => \Api\V1\Rest\AsesoriaLegalForm\AsesoriaLegalFormCollection::class,
            'service_name' => 'asesoriaLegalForm',
        ],
        'Api\\V1\\Rest\\QuejasForm\\Controller' => [
            'listener' => \Api\V1\Rest\QuejasForm\QuejasFormResource::class,
            'route_name' => 'api.rest.quejas-form',
            'route_identifier_name' => 'quejas_form_id',
            'collection_name' => 'quejas_form',
            'entity_http_methods' => [
                0 => 'GET',
            ],
            'collection_http_methods' => [
                0 => 'GET',
            ],
            'collection_query_whitelist' => [
                0 => 'select',
                1 => 'where',
                2 => 'order',
                3 => 'offset',
                4 => 'limit',
            ],
            'page_size' => 25,
            'page_size_param' => null,
            'entity_class' => \Api\V1\Rest\QuejasForm\QuejasFormEntity::class,
            'collection_class' => \Api\V1\Rest\QuejasForm\QuejasFormCollection::class,
            'service_name' => 'quejasForm',
        ],
        'Api\\V1\\Rest\\Inicio\\Controller' => [
            'listener' => \Api\V1\Rest\Inicio\InicioResource::class,
            'route_name' => 'api.rest.inicio',
            'route_identifier_name' => 'inicio_id',
            'collection_name' => 'inicio',
            'entity_http_methods' => [],
            'collection_http_methods' => [
                0 => 'GET',
            ],
            'collection_query_whitelist' => [
                0 => 'select',
                1 => 'where',
                2 => 'order',
                3 => 'offset',
                4 => 'limit',
            ],
            'page_size' => 25,
            'page_size_param' => null,
            'entity_class' => \Api\V1\Rest\Inicio\InicioEntity::class,
            'collection_class' => \Api\V1\Rest\Inicio\InicioCollection::class,
            'service_name' => 'inicio',
        ],
        'Api\\V1\\Rest\\ReporteTrazabilidad\\Controller' => [
            'listener' => \Api\V1\Rest\ReporteTrazabilidad\ReporteTrazabilidadResource::class,
            'route_name' => 'api.rest.reporte-trazabilidad',
            'route_identifier_name' => 'reporte_trazabilidad_id',
            'collection_name' => 'reporte_trazabilidad',
            'entity_http_methods' => [
                0 => 'GET',
            ],
            'collection_http_methods' => [
                0 => 'GET',
                1 => 'POST',
            ],
            'collection_query_whitelist' => [
                0 => 'select',
                1 => 'where',
                2 => 'order',
                3 => 'offset',
                4 => 'limit',
            ],
            'page_size' => 25,
            'page_size_param' => null,
            'entity_class' => \Api\V1\Rest\ReporteTrazabilidad\ReporteTrazabilidadEntity::class,
            'collection_class' => \Api\V1\Rest\ReporteTrazabilidad\ReporteTrazabilidadCollection::class,
            'service_name' => 'reporteTrazabilidad',
        ],
        'Api\\V1\\Rest\\ValidateUid\\Controller' => [
            'listener' => \Api\V1\Rest\ValidateUid\ValidateUidResource::class,
            'route_name' => 'api.rest.validate-uid',
            'route_identifier_name' => 'validate_uid_id',
            'collection_name' => 'validate_uid',
            'entity_http_methods' => [
                0 => 'GET',
            ],
            'collection_http_methods' => [
                0 => 'GET',
            ],
            'collection_query_whitelist' => [
                0 => 'select',
                1 => 'where',
                2 => 'order',
                3 => 'offset',
                4 => 'limit',
            ],
            'page_size' => 25,
            'page_size_param' => null,
            'entity_class' => \Api\V1\Rest\ValidateUid\ValidateUidEntity::class,
            'collection_class' => \Api\V1\Rest\ValidateUid\ValidateUidCollection::class,
            'service_name' => 'validateUid',
        ],
        'Api\\V1\\Rest\\UsuariosRedesSociales\\Controller' => [
            'listener' => \Api\V1\Rest\UsuariosRedesSociales\UsuariosRedesSocialesResource::class,
            'route_name' => 'api.rest.usuarios-redes-sociales',
            'route_identifier_name' => 'usuarios_redes_sociales_id',
            'collection_name' => 'usuarios_redes_sociales',
            'entity_http_methods' => [
                0 => 'GET',
            ],
            'collection_http_methods' => [
                0 => 'GET',
            ],
            'collection_query_whitelist' => [
                0 => 'select',
                1 => 'where',
                2 => 'order',
                3 => 'offset',
                4 => 'limit',
            ],
            'page_size' => 25,
            'page_size_param' => null,
            'entity_class' => \Api\V1\Rest\UsuariosRedesSociales\UsuariosRedesSocialesEntity::class,
            'collection_class' => \Api\V1\Rest\UsuariosRedesSociales\UsuariosRedesSocialesCollection::class,
            'service_name' => 'usuariosRedesSociales',
        ],
        'Api\\V1\\Rest\\Banner\\Controller' => [
            'listener' => \Api\V1\Rest\Banner\BannerResource::class,
            'route_name' => 'api.rest.banner',
            'route_identifier_name' => 'banner_id',
            'collection_name' => 'banner',
            'entity_http_methods' => [],
            'collection_http_methods' => [
                0 => 'GET',
            ],
            'collection_query_whitelist' => [
                0 => 'select',
                1 => 'where',
                2 => 'order',
                3 => 'offset',
                4 => 'limit',
            ],
            'page_size' => 25,
            'page_size_param' => null,
            'entity_class' => \Api\V1\Rest\Banner\BannerEntity::class,
            'collection_class' => \Api\V1\Rest\Banner\BannerCollection::class,
            'service_name' => 'banner',
        ],
        'Api\\V1\\Rest\\AccesosDirectos\\Controller' => [
            'listener' => \Api\V1\Rest\AccesosDirectos\AccesosDirectosResource::class,
            'route_name' => 'api.rest.accesos-directos',
            'route_identifier_name' => 'accesos_directos_id',
            'collection_name' => 'accesos_directos',
            'entity_http_methods' => [],
            'collection_http_methods' => [
                0 => 'GET',
            ],
            'collection_query_whitelist' => [
                0 => 'select',
                1 => 'where',
                2 => 'order',
                3 => 'offset',
                4 => 'limit',
            ],
            'page_size' => 25,
            'page_size_param' => null,
            'entity_class' => \Api\V1\Rest\AccesosDirectos\AccesosDirectosEntity::class,
            'collection_class' => \Api\V1\Rest\AccesosDirectos\AccesosDirectosCollection::class,
            'service_name' => 'accesosDirectos',
        ],
        'Api\\V1\\Rest\\MenuPublico\\Controller' => [
            'listener' => \Api\V1\Rest\MenuPublico\MenuPublicoResource::class,
            'route_name' => 'api.rest.menu-publico',
            'route_identifier_name' => 'menu_publico_id',
            'collection_name' => 'menu_publico',
            'entity_http_methods' => [],
            'collection_http_methods' => [
                0 => 'GET',
            ],
            'collection_query_whitelist' => [
                0 => 'select',
                1 => 'where',
                2 => 'order',
                3 => 'offset',
                4 => 'limit',
            ],
            'page_size' => 25,
            'page_size_param' => null,
            'entity_class' => \Api\V1\Rest\MenuPublico\MenuPublicoEntity::class,
            'collection_class' => \Api\V1\Rest\MenuPublico\MenuPublicoCollection::class,
            'service_name' => 'menuPublico',
        ],
        'Api\\V1\\Rest\\Etiquetas\\Controller' => [
            'listener' => \Api\V1\Rest\Etiquetas\EtiquetasResource::class,
            'route_name' => 'api.rest.etiquetas',
            'route_identifier_name' => 'etiquetas_id',
            'collection_name' => 'etiquetas',
            'entity_http_methods' => [
                0 => 'GET',
                1 => 'PATCH',
                2 => 'PUT',
                3 => 'DELETE',
            ],
            'collection_http_methods' => [
                0 => 'GET',
                1 => 'POST',
            ],
            'collection_query_whitelist' => [],
            'page_size' => 25,
            'page_size_param' => null,
            'entity_class' => \Api\V1\Rest\Etiquetas\EtiquetasEntity::class,
            'collection_class' => \Api\V1\Rest\Etiquetas\EtiquetasCollection::class,
            'service_name' => 'etiquetas',
        ],
    ],
    'api-tools-content-negotiation' => [
        'controllers' => [
            'Api\\V1\\Rest\\Authentication\\Controller' => 'Json',
            'Api\\V1\\Rest\\Refresh\\Controller' => 'Json',
            'Api\\V1\\Rest\\Users\\Controller' => 'Json',
            'Api\\V1\\Rest\\UsersPrivileges\\Controller' => 'Json',
            'Api\\V1\\Rest\\Profiles\\Controller' => 'Json',
            'Api\\V1\\Rest\\ProfilesPrivileges\\Controller' => 'Json',
            'Api\\V1\\Rest\\Menus\\Controller' => 'Json',
            'Api\\V1\\Rest\\States\\Controller' => 'Json',
            'Api\\V1\\Rest\\Municipalities\\Controller' => 'Json',
            'Api\\V1\\Rest\\Neighborhoods\\Controller' => 'Json',
            'Api\\V1\\Rest\\Employees\\Controller' => 'Json',
            'Api\\V1\\Rest\\AcercaDe\\Controller' => 'Json',
            'Api\\V1\\Rest\\Recomendaciones\\Controller' => 'Json',
            'Api\\V1\\Rest\\AvisoPrivacidad\\Controller' => 'Json',
            'Api\\V1\\Rest\\TerminosYCondiciones\\Controller' => 'Json',
            'Api\\V1\\Rest\\RoboExtravioPasaporte\\Controller' => 'Json',
            'Api\\V1\\Rest\\QuejasContraPrestadores\\Controller' => 'Json',
            'Api\\V1\\Rest\\QuejasFraudeCibernetico\\Controller' => 'Json',
            'Api\\V1\\Rest\\ReporteRobo\\Controller' => 'Json',
            'Api\\V1\\Rest\\TarjetaCreditoClonada\\Controller' => 'Json',
            'Api\\V1\\Rest\\AsesoriaLegal\\Controller' => 'Json',
            'Api\\V1\\Rest\\AsistenciaMedica\\Controller' => 'Json',
            'Api\\V1\\Rest\\Emergencias\\Controller' => 'Json',
            'Api\\V1\\Rest\\PoliciaFederal\\Controller' => 'Json',
            'Api\\V1\\Rest\\DenunciaAnonima\\Controller' => 'Json',
            'Api\\V1\\Rest\\InformacionTuristica\\Controller' => 'Json',
            'Api\\V1\\Rest\\InfoCovid\\Controller' => 'Json',
            'Api\\V1\\Rest\\CallCenter\\Controller' => 'Json',
            'Api\\V1\\Rest\\MedidasPrevencion\\Controller' => 'Json',
            'Api\\V1\\Rest\\PruebasCovid\\Controller' => 'Json',
            'Api\\V1\\Rest\\CertificacionSanitaria\\Controller' => 'Json',
            'Api\\V1\\Rest\\ConsuladosYEmbajadas\\Controller' => 'Json',
            'Api\\V1\\Rest\\Fiscalias\\Controller' => 'Json',
            'Api\\V1\\Rest\\Nacionalidades\\Controller' => 'Json',
            'Api\\V1\\Rest\\Hospitales\\Controller' => 'Json',
            'Api\\V1\\Rest\\Generos\\Controller' => 'Json',
            'Api\\V1\\Rest\\NumeroCallCenter\\Controller' => 'Json',
            'Api\\V1\\Rest\\PrestadoresServicios\\Controller' => 'Json',
            'Api\\V1\\Rest\\DestinosTuristicos\\Controller' => 'Json',
            'Api\\V1\\Rest\\MotivosQueja\\Controller' => 'Json',
            'Api\\V1\\Rest\\Footer\\Controller' => 'Json',
            'Api\\V1\\Rest\\Idiomas\\Controller' => 'Json',
            'Api\\V1\\Rest\\Login\\Controller' => 'Json',
            'Api\\V1\\Rest\\Registro\\Controller' => 'Json',
            'Api\\V1\\Rest\\FiscaliasIcono\\Controller' => 'Json',
            'Api\\V1\\Rest\\AsesoriaLegalForm\\Controller' => 'Json',
            'Api\\V1\\Rest\\QuejasForm\\Controller' => 'Json',
            'Api\\V1\\Rest\\Inicio\\Controller' => 'Json',
            'Api\\V1\\Rest\\ReporteTrazabilidad\\Controller' => 'Json',
            'Api\\V1\\Rest\\ValidateUid\\Controller' => 'Json',
            'Api\\V1\\Rest\\UsuariosRedesSociales\\Controller' => 'Json',
            'Api\\V1\\Rest\\Banner\\Controller' => 'Json',
            'Api\\V1\\Rest\\AccesosDirectos\\Controller' => 'Json',
            'Api\\V1\\Rest\\MenuPublico\\Controller' => 'Json',
            'Api\\V1\\Rest\\Etiquetas\\Controller' => 'Json',
        ],
        'accept_whitelist' => [
            'Api\\V1\\Rest\\Authentication\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\Refresh\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\Users\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\UsersPrivileges\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\Profiles\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\ProfilesPrivileges\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\Menus\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\States\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\Municipalities\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\Neighborhoods\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\Employees\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\AcercaDe\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\Recomendaciones\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\AvisoPrivacidad\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\TerminosYCondiciones\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\RoboExtravioPasaporte\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\QuejasContraPrestadores\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\QuejasFraudeCibernetico\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\ReporteRobo\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\TarjetaCreditoClonada\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\AsesoriaLegal\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\AsistenciaMedica\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\Emergencias\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\PoliciaFederal\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\DenunciaAnonima\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\InformacionTuristica\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\InfoCovid\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\CallCenter\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\MedidasPrevencion\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\PruebasCovid\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\CertificacionSanitaria\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\ConsuladosYEmbajadas\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\Fiscalias\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\Nacionalidades\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\Hospitales\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\Generos\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\NumeroCallCenter\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\PrestadoresServicios\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\DestinosTuristicos\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\MotivosQueja\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\Footer\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\Idiomas\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\Login\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\Registro\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\FiscaliasIcono\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\AsesoriaLegalForm\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\QuejasForm\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\Inicio\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\ReporteTrazabilidad\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\ValidateUid\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\UsuariosRedesSociales\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\Banner\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\AccesosDirectos\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\MenuPublico\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\Etiquetas\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
        ],
        'content_type_whitelist' => [
            'Api\\V1\\Rest\\Authentication\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\Refresh\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\Users\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\UsersPrivileges\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\Profiles\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\ProfilesPrivileges\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\Menus\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\States\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\Municipalities\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\Neighborhoods\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\Employees\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\AcercaDe\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\Recomendaciones\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\AvisoPrivacidad\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\TerminosYCondiciones\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\RoboExtravioPasaporte\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\QuejasContraPrestadores\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\QuejasFraudeCibernetico\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\ReporteRobo\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\TarjetaCreditoClonada\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\AsesoriaLegal\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\AsistenciaMedica\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\Emergencias\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\PoliciaFederal\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\DenunciaAnonima\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\InformacionTuristica\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\InfoCovid\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\CallCenter\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\MedidasPrevencion\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\PruebasCovid\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\CertificacionSanitaria\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\ConsuladosYEmbajadas\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\Fiscalias\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\Nacionalidades\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\Hospitales\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\Generos\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\NumeroCallCenter\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\PrestadoresServicios\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\DestinosTuristicos\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\MotivosQueja\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\Footer\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\Idiomas\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\Login\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\Registro\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\FiscaliasIcono\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\AsesoriaLegalForm\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\QuejasForm\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\Inicio\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\ReporteTrazabilidad\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\ValidateUid\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\UsuariosRedesSociales\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\Banner\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\AccesosDirectos\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\MenuPublico\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
            'Api\\V1\\Rest\\Etiquetas\\Controller' => [
                0 => 'application/vnd.api.v1+json',
                1 => 'application/json',
            ],
        ],
    ],
    'api-tools-hal' => [
        'metadata_map' => [
            \Api\V1\Rest\Authentication\AuthenticationEntity::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.authentication',
                'route_identifier_name' => 'authentication_id',
                'hydrator' => \Laminas\Hydrator\ArraySerializableHydrator::class,
            ],
            \Api\V1\Rest\Authentication\AuthenticationCollection::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.authentication',
                'route_identifier_name' => 'authentication_id',
                'is_collection' => true,
            ],
            \Api\V1\Rest\Refresh\RefreshEntity::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.refresh',
                'route_identifier_name' => 'refresh_id',
                'hydrator' => \Laminas\Hydrator\ArraySerializableHydrator::class,
            ],
            \Api\V1\Rest\Refresh\RefreshCollection::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.refresh',
                'route_identifier_name' => 'refresh_id',
                'is_collection' => true,
            ],
            \Api\V1\Rest\Users\UsersEntity::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.users',
                'route_identifier_name' => 'users_id',
                'hydrator' => \Laminas\Hydrator\ArraySerializableHydrator::class,
            ],
            \Api\V1\Rest\Users\UsersCollection::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.users',
                'route_identifier_name' => 'users_id',
                'is_collection' => true,
            ],
            \Api\V1\Rest\UsersPrivileges\UsersPrivilegesEntity::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.users-privileges',
                'route_identifier_name' => 'users_privileges_id',
                'hydrator' => \Laminas\Hydrator\ArraySerializableHydrator::class,
            ],
            \Api\V1\Rest\UsersPrivileges\UsersPrivilegesCollection::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.users-privileges',
                'route_identifier_name' => 'users_privileges_id',
                'is_collection' => true,
            ],
            \Api\V1\Rest\Profiles\ProfilesEntity::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.profiles',
                'route_identifier_name' => 'profiles_id',
                'hydrator' => \Laminas\Hydrator\ArraySerializableHydrator::class,
            ],
            \Api\V1\Rest\Profiles\ProfilesCollection::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.profiles',
                'route_identifier_name' => 'profiles_id',
                'is_collection' => true,
            ],
            \Api\V1\Rest\ProfilesPrivileges\ProfilesPrivilegesEntity::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.profiles-privileges',
                'route_identifier_name' => 'profiles_privileges_id',
                'hydrator' => \Laminas\Hydrator\ArraySerializableHydrator::class,
            ],
            \Api\V1\Rest\ProfilesPrivileges\ProfilesPrivilegesCollection::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.profiles-privileges',
                'route_identifier_name' => 'profiles_privileges_id',
                'is_collection' => true,
            ],
            \Api\V1\Rest\Menus\MenusEntity::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.menus',
                'route_identifier_name' => 'menus_id',
                'hydrator' => \Laminas\Hydrator\ArraySerializableHydrator::class,
            ],
            \Api\V1\Rest\Menus\MenusCollection::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.menus',
                'route_identifier_name' => 'menus_id',
                'is_collection' => true,
            ],
            \Api\V1\Rest\States\StatesEntity::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.states',
                'route_identifier_name' => 'states_id',
                'hydrator' => \Laminas\Hydrator\ArraySerializableHydrator::class,
            ],
            \Api\V1\Rest\States\StatesCollection::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.states',
                'route_identifier_name' => 'states_id',
                'is_collection' => true,
            ],
            \Api\V1\Rest\Municipalities\MunicipalitiesEntity::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.municipalities',
                'route_identifier_name' => 'municipalities_id',
                'hydrator' => \Laminas\Hydrator\ArraySerializableHydrator::class,
            ],
            \Api\V1\Rest\Municipalities\MunicipalitiesCollection::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.municipalities',
                'route_identifier_name' => 'municipalities_id',
                'is_collection' => true,
            ],
            \Api\V1\Rest\Neighborhoods\NeighborhoodsEntity::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.neighborhoods',
                'route_identifier_name' => 'neighborhoods_id',
                'hydrator' => \Laminas\Hydrator\ArraySerializableHydrator::class,
            ],
            \Api\V1\Rest\Neighborhoods\NeighborhoodsCollection::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.neighborhoods',
                'route_identifier_name' => 'neighborhoods_id',
                'is_collection' => true,
            ],
            \Api\V1\Rest\Employees\EmployeesEntity::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.employees',
                'route_identifier_name' => 'employees_id',
                'hydrator' => \Laminas\Hydrator\ArraySerializableHydrator::class,
            ],
            \Api\V1\Rest\Employees\EmployeesCollection::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.employees',
                'route_identifier_name' => 'employees_id',
                'is_collection' => true,
            ],
            \Api\V1\Rest\AcercaDe\AcercaDeEntity::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.acerca-de',
                'route_identifier_name' => 'acerca_de_id',
                'hydrator' => \Laminas\Hydrator\ArraySerializableHydrator::class,
            ],
            \Api\V1\Rest\AcercaDe\AcercaDeCollection::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.acerca-de',
                'route_identifier_name' => 'acerca_de_id',
                'is_collection' => true,
            ],
            \Api\V1\Rest\Recomendaciones\RecomendacionesEntity::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.recomendaciones',
                'route_identifier_name' => 'recomendaciones_id',
                'hydrator' => \Laminas\Hydrator\ArraySerializableHydrator::class,
            ],
            \Api\V1\Rest\Recomendaciones\RecomendacionesCollection::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.recomendaciones',
                'route_identifier_name' => 'recomendaciones_id',
                'is_collection' => true,
            ],
            \Api\V1\Rest\AvisoPrivacidad\AvisoPrivacidadEntity::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.aviso-privacidad',
                'route_identifier_name' => 'aviso_privacidad_id',
                'hydrator' => \Laminas\Hydrator\ArraySerializableHydrator::class,
            ],
            \Api\V1\Rest\AvisoPrivacidad\AvisoPrivacidadCollection::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.aviso-privacidad',
                'route_identifier_name' => 'aviso_privacidad_id',
                'is_collection' => true,
            ],
            \Api\V1\Rest\TerminosYCondiciones\TerminosYCondicionesEntity::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.terminos-y-condiciones',
                'route_identifier_name' => 'terminos_y_condiciones_id',
                'hydrator' => \Laminas\Hydrator\ArraySerializableHydrator::class,
            ],
            \Api\V1\Rest\TerminosYCondiciones\TerminosYCondicionesCollection::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.terminos-y-condiciones',
                'route_identifier_name' => 'terminos_y_condiciones_id',
                'is_collection' => true,
            ],
            \Api\V1\Rest\RoboExtravioPasaporte\RoboExtravioPasaporteEntity::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.robo-extravio-pasaporte',
                'route_identifier_name' => 'robo_extravio_pasaporte_id',
                'hydrator' => \Laminas\Hydrator\ArraySerializableHydrator::class,
            ],
            \Api\V1\Rest\RoboExtravioPasaporte\RoboExtravioPasaporteCollection::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.robo-extravio-pasaporte',
                'route_identifier_name' => 'robo_extravio_pasaporte_id',
                'is_collection' => true,
            ],
            \Api\V1\Rest\QuejasContraPrestadores\QuejasContraPrestadoresEntity::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.quejas-contra-prestadores',
                'route_identifier_name' => 'quejas_contra_prestadores_id',
                'hydrator' => \Laminas\Hydrator\ArraySerializableHydrator::class,
            ],
            \Api\V1\Rest\QuejasContraPrestadores\QuejasContraPrestadoresCollection::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.quejas-contra-prestadores',
                'route_identifier_name' => 'quejas_contra_prestadores_id',
                'is_collection' => true,
            ],
            \Api\V1\Rest\QuejasFraudeCibernetico\QuejasFraudeCiberneticoEntity::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.quejas-fraude-cibernetico',
                'route_identifier_name' => 'quejas_fraude_cibernetico_id',
                'hydrator' => \Laminas\Hydrator\ArraySerializableHydrator::class,
            ],
            \Api\V1\Rest\QuejasFraudeCibernetico\QuejasFraudeCiberneticoCollection::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.quejas-fraude-cibernetico',
                'route_identifier_name' => 'quejas_fraude_cibernetico_id',
                'is_collection' => true,
            ],
            \Api\V1\Rest\ReporteRobo\ReporteRoboEntity::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.reporte-robo',
                'route_identifier_name' => 'reporte_robo_id',
                'hydrator' => \Laminas\Hydrator\ArraySerializableHydrator::class,
            ],
            \Api\V1\Rest\ReporteRobo\ReporteRoboCollection::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.reporte-robo',
                'route_identifier_name' => 'reporte_robo_id',
                'is_collection' => true,
            ],
            \Api\V1\Rest\TarjetaCreditoClonada\TarjetaCreditoClonadaEntity::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.tarjeta-credito-clonada',
                'route_identifier_name' => 'tarjeta_credito_clonada_id',
                'hydrator' => \Laminas\Hydrator\ArraySerializableHydrator::class,
            ],
            \Api\V1\Rest\TarjetaCreditoClonada\TarjetaCreditoClonadaCollection::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.tarjeta-credito-clonada',
                'route_identifier_name' => 'tarjeta_credito_clonada_id',
                'is_collection' => true,
            ],
            \Api\V1\Rest\AsesoriaLegal\AsesoriaLegalEntity::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.asesoria-legal',
                'route_identifier_name' => 'asesoria_legal_id',
                'hydrator' => \Laminas\Hydrator\ArraySerializableHydrator::class,
            ],
            \Api\V1\Rest\AsesoriaLegal\AsesoriaLegalCollection::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.asesoria-legal',
                'route_identifier_name' => 'asesoria_legal_id',
                'is_collection' => true,
            ],
            \Api\V1\Rest\AsistenciaMedica\AsistenciaMedicaEntity::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.asistencia-medica',
                'route_identifier_name' => 'asistencia_medica_id',
                'hydrator' => \Laminas\Hydrator\ArraySerializableHydrator::class,
            ],
            \Api\V1\Rest\AsistenciaMedica\AsistenciaMedicaCollection::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.asistencia-medica',
                'route_identifier_name' => 'asistencia_medica_id',
                'is_collection' => true,
            ],
            \Api\V1\Rest\Emergencias\EmergenciasEntity::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.emergencias',
                'route_identifier_name' => 'emergencias_id',
                'hydrator' => \Laminas\Hydrator\ArraySerializableHydrator::class,
            ],
            \Api\V1\Rest\Emergencias\EmergenciasCollection::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.emergencias',
                'route_identifier_name' => 'emergencias_id',
                'is_collection' => true,
            ],
            \Api\V1\Rest\PoliciaFederal\PoliciaFederalEntity::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.policia-federal',
                'route_identifier_name' => 'policia_federal_id',
                'hydrator' => \Laminas\Hydrator\ArraySerializableHydrator::class,
            ],
            \Api\V1\Rest\PoliciaFederal\PoliciaFederalCollection::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.policia-federal',
                'route_identifier_name' => 'policia_federal_id',
                'is_collection' => true,
            ],
            \Api\V1\Rest\DenunciaAnonima\DenunciaAnonimaEntity::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.denuncia-anonima',
                'route_identifier_name' => 'denuncia_anonima_id',
                'hydrator' => \Laminas\Hydrator\ArraySerializableHydrator::class,
            ],
            \Api\V1\Rest\DenunciaAnonima\DenunciaAnonimaCollection::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.denuncia-anonima',
                'route_identifier_name' => 'denuncia_anonima_id',
                'is_collection' => true,
            ],
            \Api\V1\Rest\InformacionTuristica\InformacionTuristicaEntity::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.informacion-turistica',
                'route_identifier_name' => 'informacion_turistica_id',
                'hydrator' => \Laminas\Hydrator\ArraySerializableHydrator::class,
            ],
            \Api\V1\Rest\InformacionTuristica\InformacionTuristicaCollection::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.informacion-turistica',
                'route_identifier_name' => 'informacion_turistica_id',
                'is_collection' => true,
            ],
            \Api\V1\Rest\InfoCovid\InfoCovidEntity::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.info-covid',
                'route_identifier_name' => 'info_covid_id',
                'hydrator' => \Laminas\Hydrator\ArraySerializableHydrator::class,
            ],
            \Api\V1\Rest\InfoCovid\InfoCovidCollection::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.info-covid',
                'route_identifier_name' => 'info_covid_id',
                'is_collection' => true,
            ],
            \Api\V1\Rest\CallCenter\CallCenterEntity::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.call-center',
                'route_identifier_name' => 'call_center_id',
                'hydrator' => \Laminas\Hydrator\ArraySerializableHydrator::class,
            ],
            \Api\V1\Rest\CallCenter\CallCenterCollection::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.call-center',
                'route_identifier_name' => 'call_center_id',
                'is_collection' => true,
            ],
            \Api\V1\Rest\MedidasPrevencion\MedidasPrevencionEntity::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.medidas-prevencion',
                'route_identifier_name' => 'medidas_prevencion_id',
                'hydrator' => \Laminas\Hydrator\ArraySerializableHydrator::class,
            ],
            \Api\V1\Rest\MedidasPrevencion\MedidasPrevencionCollection::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.medidas-prevencion',
                'route_identifier_name' => 'medidas_prevencion_id',
                'is_collection' => true,
            ],
            \Api\V1\Rest\PruebasCovid\PruebasCovidEntity::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.pruebas-covid',
                'route_identifier_name' => 'pruebas_covid_id',
                'hydrator' => \Laminas\Hydrator\ArraySerializableHydrator::class,
            ],
            \Api\V1\Rest\PruebasCovid\PruebasCovidCollection::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.pruebas-covid',
                'route_identifier_name' => 'pruebas_covid_id',
                'is_collection' => true,
            ],
            \Api\V1\Rest\CertificacionSanitaria\CertificacionSanitariaEntity::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.certificacion-sanitaria',
                'route_identifier_name' => 'certificacion_sanitaria_id',
                'hydrator' => \Laminas\Hydrator\ArraySerializableHydrator::class,
            ],
            \Api\V1\Rest\CertificacionSanitaria\CertificacionSanitariaCollection::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.certificacion-sanitaria',
                'route_identifier_name' => 'certificacion_sanitaria_id',
                'is_collection' => true,
            ],
            \Api\V1\Rest\ConsuladosYEmbajadas\ConsuladosYEmbajadasEntity::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.consulados-y-embajadas',
                'route_identifier_name' => 'consulados_y_embajadas_id',
                'hydrator' => \Laminas\Hydrator\ArraySerializableHydrator::class,
            ],
            \Api\V1\Rest\ConsuladosYEmbajadas\ConsuladosYEmbajadasCollection::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.consulados-y-embajadas',
                'route_identifier_name' => 'consulados_y_embajadas_id',
                'is_collection' => true,
            ],
            \Api\V1\Rest\Fiscalias\FiscaliasEntity::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.fiscalias',
                'route_identifier_name' => 'fiscalias_id',
                'hydrator' => \Laminas\Hydrator\ArraySerializableHydrator::class,
            ],
            \Api\V1\Rest\Fiscalias\FiscaliasCollection::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.fiscalias',
                'route_identifier_name' => 'fiscalias_id',
                'is_collection' => true,
            ],
            \Api\V1\Rest\Nacionalidades\NacionalidadesEntity::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.nacionalidades',
                'route_identifier_name' => 'nacionalidades_id',
                'hydrator' => \Laminas\Hydrator\ArraySerializableHydrator::class,
            ],
            \Api\V1\Rest\Nacionalidades\NacionalidadesCollection::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.nacionalidades',
                'route_identifier_name' => 'nacionalidades_id',
                'is_collection' => true,
            ],
            \Api\V1\Rest\Hospitales\HospitalesEntity::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.hospitales',
                'route_identifier_name' => 'hospitales_id',
                'hydrator' => \Laminas\Hydrator\ArraySerializableHydrator::class,
            ],
            \Api\V1\Rest\Hospitales\HospitalesCollection::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.hospitales',
                'route_identifier_name' => 'hospitales_id',
                'is_collection' => true,
            ],
            \Api\V1\Rest\Generos\GenerosEntity::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.generos',
                'route_identifier_name' => 'generos_id',
                'hydrator' => \Laminas\Hydrator\ArraySerializableHydrator::class,
            ],
            \Api\V1\Rest\Generos\GenerosCollection::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.generos',
                'route_identifier_name' => 'generos_id',
                'is_collection' => true,
            ],
            \Api\V1\Rest\NumeroCallCenter\NumeroCallCenterEntity::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.numero-call-center',
                'route_identifier_name' => 'numero_call_center_id',
                'hydrator' => \Laminas\Hydrator\ArraySerializableHydrator::class,
            ],
            \Api\V1\Rest\NumeroCallCenter\NumeroCallCenterCollection::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.numero-call-center',
                'route_identifier_name' => 'numero_call_center_id',
                'is_collection' => true,
            ],
            \Api\V1\Rest\PrestadoresServicios\PrestadoresServiciosEntity::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.prestadores-servicios',
                'route_identifier_name' => 'prestadores_servicios_id',
                'hydrator' => \Laminas\Hydrator\ArraySerializableHydrator::class,
            ],
            \Api\V1\Rest\PrestadoresServicios\PrestadoresServiciosCollection::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.prestadores-servicios',
                'route_identifier_name' => 'prestadores_servicios_id',
                'is_collection' => true,
            ],
            \Api\V1\Rest\DestinosTuristicos\DestinosTuristicosEntity::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.destinos-turisticos',
                'route_identifier_name' => 'destinos_turisticos_id',
                'hydrator' => \Laminas\Hydrator\ArraySerializableHydrator::class,
            ],
            \Api\V1\Rest\DestinosTuristicos\DestinosTuristicosCollection::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.destinos-turisticos',
                'route_identifier_name' => 'destinos_turisticos_id',
                'is_collection' => true,
            ],
            \Api\V1\Rest\MotivosQueja\MotivosQuejaEntity::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.motivos-queja',
                'route_identifier_name' => 'motivos_queja_id',
                'hydrator' => \Laminas\Hydrator\ArraySerializableHydrator::class,
            ],
            \Api\V1\Rest\MotivosQueja\MotivosQuejaCollection::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.motivos-queja',
                'route_identifier_name' => 'motivos_queja_id',
                'is_collection' => true,
            ],
            \Api\V1\Rest\Footer\FooterEntity::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.footer',
                'route_identifier_name' => 'footer_id',
                'hydrator' => \Laminas\Hydrator\ArraySerializableHydrator::class,
            ],
            \Api\V1\Rest\Footer\FooterCollection::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.footer',
                'route_identifier_name' => 'footer_id',
                'is_collection' => true,
            ],
            \Api\V1\Rest\Idiomas\IdiomasEntity::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.idiomas',
                'route_identifier_name' => 'idiomas_id',
                'hydrator' => \Laminas\Hydrator\ArraySerializableHydrator::class,
            ],
            \Api\V1\Rest\Idiomas\IdiomasCollection::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.idiomas',
                'route_identifier_name' => 'idiomas_id',
                'is_collection' => true,
            ],
            \Api\V1\Rest\Login\LoginEntity::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.login',
                'route_identifier_name' => 'login_id',
                'hydrator' => \Laminas\Hydrator\ArraySerializableHydrator::class,
            ],
            \Api\V1\Rest\Login\LoginCollection::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.login',
                'route_identifier_name' => 'login_id',
                'is_collection' => true,
            ],
            \Api\V1\Rest\Registro\RegistroEntity::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.registro',
                'route_identifier_name' => 'registro_id',
                'hydrator' => \Laminas\Hydrator\ArraySerializableHydrator::class,
            ],
            \Api\V1\Rest\Registro\RegistroCollection::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.registro',
                'route_identifier_name' => 'registro_id',
                'is_collection' => true,
            ],
            \Api\V1\Rest\FiscaliasIcono\FiscaliasIconoEntity::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.fiscalias-icono',
                'route_identifier_name' => 'fiscalias_icono_id',
                'hydrator' => \Laminas\Hydrator\ArraySerializableHydrator::class,
            ],
            \Api\V1\Rest\FiscaliasIcono\FiscaliasIconoCollection::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.fiscalias-icono',
                'route_identifier_name' => 'fiscalias_icono_id',
                'is_collection' => true,
            ],
            \Api\V1\Rest\AsesoriaLegalForm\AsesoriaLegalFormEntity::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.asesoria-legal-form',
                'route_identifier_name' => 'asesoria_legal_form_id',
                'hydrator' => \Laminas\Hydrator\ArraySerializableHydrator::class,
            ],
            \Api\V1\Rest\AsesoriaLegalForm\AsesoriaLegalFormCollection::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.asesoria-legal-form',
                'route_identifier_name' => 'asesoria_legal_form_id',
                'is_collection' => true,
            ],
            \Api\V1\Rest\QuejasForm\QuejasFormEntity::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.quejas-form',
                'route_identifier_name' => 'quejas_form_id',
                'hydrator' => \Laminas\Hydrator\ArraySerializableHydrator::class,
            ],
            \Api\V1\Rest\QuejasForm\QuejasFormCollection::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.quejas-form',
                'route_identifier_name' => 'quejas_form_id',
                'is_collection' => true,
            ],
            \Api\V1\Rest\Inicio\InicioEntity::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.inicio',
                'route_identifier_name' => 'inicio_id',
                'hydrator' => \Laminas\Hydrator\ArraySerializableHydrator::class,
            ],
            \Api\V1\Rest\Inicio\InicioCollection::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.inicio',
                'route_identifier_name' => 'inicio_id',
                'is_collection' => true,
            ],
            \Api\V1\Rest\ReporteTrazabilidad\ReporteTrazabilidadEntity::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.reporte-trazabilidad',
                'route_identifier_name' => 'reporte_trazabilidad_id',
                'hydrator' => \Laminas\Hydrator\ArraySerializableHydrator::class,
            ],
            \Api\V1\Rest\ReporteTrazabilidad\ReporteTrazabilidadCollection::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.reporte-trazabilidad',
                'route_identifier_name' => 'reporte_trazabilidad_id',
                'is_collection' => true,
            ],
            \Api\V1\Rest\ValidateUid\ValidateUidEntity::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.validate-uid',
                'route_identifier_name' => 'validate_uid_id',
                'hydrator' => \Laminas\Hydrator\ArraySerializableHydrator::class,
            ],
            \Api\V1\Rest\ValidateUid\ValidateUidCollection::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.validate-uid',
                'route_identifier_name' => 'validate_uid_id',
                'is_collection' => true,
            ],
            \Api\V1\Rest\UsuariosRedesSociales\UsuariosRedesSocialesEntity::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.usuarios-redes-sociales',
                'route_identifier_name' => 'usuarios_redes_sociales_id',
                'hydrator' => \Laminas\Hydrator\ArraySerializableHydrator::class,
            ],
            \Api\V1\Rest\UsuariosRedesSociales\UsuariosRedesSocialesCollection::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.usuarios-redes-sociales',
                'route_identifier_name' => 'usuarios_redes_sociales_id',
                'is_collection' => true,
            ],
            \Api\V1\Rest\Banner\BannerEntity::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.banner',
                'route_identifier_name' => 'banner_id',
                'hydrator' => \Laminas\Hydrator\ArraySerializableHydrator::class,
            ],
            \Api\V1\Rest\Banner\BannerCollection::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.banner',
                'route_identifier_name' => 'banner_id',
                'is_collection' => true,
            ],
            \Api\V1\Rest\AccesosDirectos\AccesosDirectosEntity::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.accesos-directos',
                'route_identifier_name' => 'accesos_directos_id',
                'hydrator' => \Laminas\Hydrator\ArraySerializableHydrator::class,
            ],
            \Api\V1\Rest\AccesosDirectos\AccesosDirectosCollection::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.accesos-directos',
                'route_identifier_name' => 'accesos_directos_id',
                'is_collection' => true,
            ],
            \Api\V1\Rest\MenuPublico\MenuPublicoEntity::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.menu-publico',
                'route_identifier_name' => 'menu_publico_id',
                'hydrator' => \Laminas\Hydrator\ArraySerializableHydrator::class,
            ],
            \Api\V1\Rest\MenuPublico\MenuPublicoCollection::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.menu-publico',
                'route_identifier_name' => 'menu_publico_id',
                'is_collection' => true,
            ],
            \Api\V1\Rest\Etiquetas\EtiquetasEntity::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.etiquetas',
                'route_identifier_name' => 'etiquetas_id',
                'hydrator' => \Laminas\Hydrator\ArraySerializableHydrator::class,
            ],
            \Api\V1\Rest\Etiquetas\EtiquetasCollection::class => [
                'entity_identifier_name' => 'id',
                'route_name' => 'api.rest.etiquetas',
                'route_identifier_name' => 'etiquetas_id',
                'is_collection' => true,
            ],
        ],
    ],
    'api-tools-content-validation' => [
        'Api\\V1\\Rest\\Refresh\\Controller' => [
            'input_filter' => 'Api\\V1\\Rest\\Refresh\\Validator',
        ],
        'Api\\V1\\Rest\\Authentication\\Controller' => [
            'input_filter' => 'Api\\V1\\Rest\\Authentication\\Validator',
        ],
        'Api\\V1\\Rest\\Users\\Controller' => [
            'input_filter' => 'Api\\V1\\Rest\\Users\\Validator',
        ],
        'Api\\V1\\Rest\\Profiles\\Controller' => [
            'input_filter' => 'Api\\V1\\Rest\\Profiles\\Validator',
        ],
        'Api\\V1\\Rest\\Employees\\Controller' => [
            'input_filter' => 'Api\\V1\\Rest\\Employees\\Validator',
        ],
        'Api\\V1\\Rest\\Login\\Controller' => [
            'input_filter' => 'Api\\V1\\Rest\\Login\\Validator',
        ],
        'Api\\V1\\Rest\\Registro\\Controller' => [
            'input_filter' => 'Api\\V1\\Rest\\Registro\\Validator',
        ],
        'Api\\V1\\Rest\\AsesoriaLegalForm\\Controller' => [
            'input_filter' => 'Api\\V1\\Rest\\AsesoriaLegalForm\\Validator',
        ],
        'Api\\V1\\Rest\\QuejasForm\\Controller' => [
            'input_filter' => 'Api\\V1\\Rest\\QuejasForm\\Validator',
        ],
        'Api\\V1\\Rest\\ReporteTrazabilidad\\Controller' => [
            'input_filter' => 'Api\\V1\\Rest\\ReporteTrazabilidad\\Validator',
        ],
    ],
    'input_filter_specs' => [
        'Api\\V1\\Rest\\Refresh\\Validator' => [],
        'Api\\V1\\Rest\\Authentication\\Validator' => [
            0 => [
                'required' => false,
                'validators' => [
                    0 => [
                        'name' => \Laminas\Validator\StringLength::class,
                        'options' => [
                            'max' => '255',
                        ],
                    ],
                ],
                'filters' => [
                    0 => [
                        'name' => \Laminas\Filter\StringTrim::class,
                        'options' => [],
                    ],
                ],
                'name' => 'frmUserAuthentication',
                'description' => 'Username',
                'field_type' => 'string',
            ],
            1 => [
                'required' => false,
                'validators' => [
                    0 => [
                        'name' => \Laminas\Validator\StringLength::class,
                        'options' => [
                            'max' => '50',
                        ],
                    ],
                ],
                'filters' => [
                    0 => [
                        'name' => \Laminas\Filter\StringTrim::class,
                        'options' => [],
                    ],
                ],
                'name' => 'frmPasswordAuthentication',
                'description' => 'User\'s password',
                'field_type' => 'string',
            ],
            2 => [
                'required' => false,
                'validators' => [
                    0 => [
                        'name' => \Laminas\Validator\StringLength::class,
                        'options' => [
                            'max' => '100',
                        ],
                    ],
                ],
                'filters' => [
                    0 => [
                        'name' => \Laminas\Filter\StringTrim::class,
                        'options' => [],
                    ],
                ],
                'name' => 'frmUidAuthentication',
                'description' => 'User\'s UID acording social network',
                'field_type' => 'string',
            ],
            3 => [
                'required' => false,
                'validators' => [],
                'filters' => [
                    0 => [
                        'name' => \Laminas\Filter\StringTrim::class,
                        'options' => [],
                    ],
                ],
                'name' => 'frmIdSocialNetworkAuthentication',
                'description' => 'Social Network ID',
                'field_type' => 'integer',
            ],
        ],
        'Api\\V1\\Rest\\Users\\Validator' => [
            0 => [
                'required' => false,
                'validators' => [
                    0 => [
                        'name' => \Laminas\Validator\Digits::class,
                        'options' => [],
                    ],
                    1 => [
                        'name' => \Laminas\Validator\GreaterThan::class,
                        'options' => [
                            'min' => '0',
                        ],
                    ],
                ],
                'filters' => [
                    0 => [
                        'name' => \Laminas\Filter\StringTrim::class,
                        'options' => [],
                    ],
                    1 => [
                        'name' => \Laminas\Filter\StripTags::class,
                        'options' => [],
                    ],
                ],
                'name' => 'frmIdCiudadanoUsuario',
                'description' => 'Citizen ID',
                'field_type' => 'int',
            ],
            1 => [
                'required' => false,
                'validators' => [
                    0 => [
                        'name' => \Laminas\Validator\Digits::class,
                        'options' => [],
                    ],
                    1 => [
                        'name' => \Laminas\Validator\GreaterThan::class,
                        'options' => [
                            'min' => '0',
                        ],
                    ],
                ],
                'filters' => [
                    0 => [
                        'name' => \Laminas\Filter\StringTrim::class,
                        'options' => [],
                    ],
                    1 => [
                        'name' => \Laminas\Filter\StripTags::class,
                        'options' => [],
                    ],
                ],
                'name' => 'frmIdPerfilUsuario',
                'description' => 'Profile ID',
                'field_type' => 'int',
            ],
            2 => [
                'required' => false,
                'validators' => [
                    0 => [
                        'name' => \Laminas\Validator\StringLength::class,
                        'options' => [
                            'max' => '255',
                        ],
                    ],
                ],
                'filters' => [
                    0 => [
                        'name' => \Laminas\Filter\StringTrim::class,
                        'options' => [],
                    ],
                    1 => [
                        'name' => \Laminas\Filter\StripTags::class,
                        'options' => [],
                    ],
                ],
                'name' => 'frmIdNombreUsuarioUsuario',
                'description' => 'User name',
                'field_type' => 'string',
            ],
            3 => [
                'required' => false,
                'validators' => [
                    0 => [
                        'name' => \Laminas\Validator\StringLength::class,
                        'options' => [
                            'max' => '100',
                        ],
                    ],
                ],
                'filters' => [
                    0 => [
                        'name' => \Laminas\Filter\StringTrim::class,
                        'options' => [],
                    ],
                ],
                'name' => 'frmPasswordUsuario',
                'description' => 'User password',
                'field_type' => 'string',
            ],
            4 => [
                'required' => false,
                'validators' => [
                    0 => [
                        'name' => \Laminas\Validator\IsCountable::class,
                        'options' => [],
                    ],
                ],
                'filters' => [],
                'name' => 'frmPrivilegesUser',
                'description' => 'Set of privileges ID for the user',
                'field_type' => 'array',
            ],
        ],
        'Api\\V1\\Rest\\Profiles\\Validator' => [
            0 => [
                'required' => false,
                'validators' => [
                    0 => [
                        'name' => \Laminas\Validator\StringLength::class,
                        'options' => [
                            'max' => '30',
                        ],
                    ],
                ],
                'filters' => [
                    0 => [
                        'name' => \Laminas\Filter\StringTrim::class,
                        'options' => [],
                    ],
                    1 => [
                        'name' => \Laminas\Filter\StripTags::class,
                        'options' => [],
                    ],
                ],
                'name' => 'frmNameProfile',
                'description' => 'Profile name',
                'field_type' => 'string',
            ],
            1 => [
                'required' => false,
                'validators' => [
                    0 => [
                        'name' => \Laminas\Validator\IsCountable::class,
                        'options' => [],
                    ],
                ],
                'filters' => [],
                'name' => 'frmPrivilegesProfile',
                'description' => 'List of privileges',
                'field_type' => 'array',
            ],
        ],
        'Api\\V1\\Rest\\Committees\\Validator' => [
            0 => [
                'required' => false,
                'validators' => [
                    0 => [
                        'name' => \Laminas\Validator\Digits::class,
                        'options' => [],
                    ],
                    1 => [
                        'name' => \Laminas\Validator\GreaterThan::class,
                        'options' => [
                            'min' => '0',
                        ],
                    ],
                ],
                'filters' => [
                    0 => [
                        'name' => \Laminas\Filter\StringTrim::class,
                        'options' => [],
                    ],
                    1 => [
                        'name' => \Laminas\Filter\StripTags::class,
                        'options' => [],
                    ],
                ],
                'name' => 'frmElectoralProcessIdCommittee',
                'description' => 'Electoral process ID of the committee',
                'field_type' => 'int',
            ],
            1 => [
                'required' => false,
                'validators' => [
                    0 => [
                        'name' => \Laminas\Validator\Digits::class,
                        'options' => [],
                    ],
                    1 => [
                        'name' => \Laminas\Validator\GreaterThan::class,
                        'options' => [
                            'min' => '0',
                        ],
                    ],
                ],
                'filters' => [
                    0 => [
                        'name' => \Laminas\Filter\StringTrim::class,
                        'options' => [],
                    ],
                    1 => [
                        'name' => \Laminas\Filter\StripTags::class,
                        'options' => [],
                    ],
                ],
                'name' => 'frmSectionIdCommittee',
                'description' => 'Section ID of the committee',
                'field_type' => 'int',
            ],
            2 => [
                'required' => false,
                'validators' => [
                    0 => [
                        'name' => \Laminas\Validator\StringLength::class,
                        'options' => [
                            'max' => '10',
                            'min' => '10',
                        ],
                    ],
                ],
                'filters' => [
                    0 => [
                        'name' => \Laminas\Filter\StringTrim::class,
                        'options' => [],
                    ],
                    1 => [
                        'name' => \Laminas\Filter\StripTags::class,
                        'options' => [],
                    ],
                ],
                'name' => 'frmRegistrationDateCommittee',
                'description' => 'Date in which the committee was registered',
                'field_type' => 'string',
            ],
            3 => [
                'required' => false,
                'validators' => [
                    0 => [
                        'name' => \Laminas\Validator\StringLength::class,
                        'options' => [
                            'max' => '8',
                            'min' => '5',
                        ],
                    ],
                ],
                'filters' => [
                    0 => [
                        'name' => \Laminas\Filter\StringTrim::class,
                        'options' => [],
                    ],
                    1 => [
                        'name' => \Laminas\Filter\StripTags::class,
                        'options' => [],
                    ],
                ],
                'description' => 'Time in which the committee was registered',
                'name' => 'frmRegistrationTimeCommittee',
                'field_type' => 'string',
            ],
            4 => [
                'required' => false,
                'validators' => [
                    0 => [
                        'name' => \Laminas\Validator\Digits::class,
                        'options' => [],
                    ],
                    1 => [
                        'name' => \Laminas\Validator\GreaterThan::class,
                        'options' => [
                            'min' => '0',
                        ],
                    ],
                ],
                'filters' => [
                    0 => [
                        'name' => \Laminas\Filter\StringTrim::class,
                        'options' => [],
                    ],
                    1 => [
                        'name' => \Laminas\Filter\StripTags::class,
                        'options' => [],
                    ],
                ],
                'name' => 'frmStepCommittee',
                'description' => 'Step in which a user left wahile creating or editing a committee',
                'field_type' => 'int',
            ],
        ],
        'Api\\V1\\Rest\\CommitteeMembers\\Validator' => [
            0 => [
                'required' => false,
                'validators' => [
                    0 => [
                        'name' => \Laminas\Validator\Digits::class,
                        'options' => [],
                    ],
                    1 => [
                        'name' => \Laminas\Validator\GreaterThan::class,
                        'options' => [
                            'min' => '0',
                        ],
                    ],
                ],
                'filters' => [
                    0 => [
                        'name' => \Laminas\Filter\StringTrim::class,
                        'options' => [],
                    ],
                    1 => [
                        'name' => \Laminas\Filter\StripTags::class,
                        'options' => [],
                    ],
                ],
                'name' => 'frmIdCommitteeMember',
                'description' => 'Committee member ID',
                'field_type' => 'int',
            ],
            1 => [
                'required' => false,
                'validators' => [
                    0 => [
                        'name' => \Laminas\Validator\Digits::class,
                        'options' => [],
                    ],
                    1 => [
                        'name' => \Laminas\Validator\GreaterThan::class,
                        'options' => [
                            'min' => '0',
                        ],
                    ],
                ],
                'filters' => [
                    0 => [
                        'name' => \Laminas\Filter\StringTrim::class,
                        'options' => [],
                    ],
                    1 => [
                        'name' => \Laminas\Filter\StripTags::class,
                        'options' => [],
                    ],
                ],
                'name' => 'frmJobPositionIdCommitteeMember',
                'description' => 'Job position of the member',
                'field_type' => 'int',
            ],
            2 => [
                'required' => false,
                'validators' => [
                    0 => [
                        'name' => \Laminas\Validator\Digits::class,
                        'options' => [],
                    ],
                    1 => [
                        'name' => \Laminas\Validator\GreaterThan::class,
                        'options' => [
                            'min' => '0',
                        ],
                    ],
                ],
                'filters' => [
                    0 => [
                        'name' => \Laminas\Filter\StringTrim::class,
                        'options' => [],
                    ],
                    1 => [
                        'name' => \Laminas\Filter\StripTags::class,
                        'options' => [],
                    ],
                ],
                'name' => 'frmElectoralProcessIdCommitteeMember',
                'description' => 'Electoral process ID',
                'field_type' => 'int',
            ],
            3 => [
                'required' => false,
                'validators' => [
                    0 => [
                        'name' => \Laminas\Validator\Digits::class,
                        'options' => [],
                    ],
                    1 => [
                        'name' => \Laminas\Validator\GreaterThan::class,
                        'options' => [
                            'min' => '0',
                        ],
                    ],
                ],
                'filters' => [
                    0 => [
                        'name' => \Laminas\Filter\StringTrim::class,
                        'options' => [],
                    ],
                    1 => [
                        'name' => \Laminas\Filter\StripTags::class,
                        'options' => [],
                    ],
                ],
                'name' => 'frmCommitteeIdCommitteeMember',
                'description' => 'Committee ID',
                'field_type' => 'int',
            ],
            4 => [
                'required' => false,
                'validators' => [
                    0 => [
                        'name' => \Laminas\Validator\Digits::class,
                        'options' => [],
                    ],
                    1 => [
                        'name' => \Laminas\Validator\GreaterThan::class,
                        'options' => [
                            'min' => '0',
                        ],
                    ],
                ],
                'filters' => [
                    0 => [
                        'name' => \Laminas\Filter\StringTrim::class,
                        'options' => [],
                    ],
                    1 => [
                        'name' => \Laminas\Filter\StripTags::class,
                        'options' => [],
                    ],
                ],
                'name' => 'frmCitizenIdCommitteeMember',
                'description' => 'Citizen ID',
                'field_type' => 'int',
            ],
        ],
        'Api\\V1\\Rest\\Citizens\\Validator' => [
            0 => [
                'required' => false,
                'validators' => [
                    0 => [
                        'name' => \Laminas\Validator\StringLength::class,
                        'options' => [
                            'min' => '18',
                            'max' => '18',
                        ],
                    ],
                ],
                'filters' => [
                    0 => [
                        'name' => \Laminas\Filter\StringTrim::class,
                        'options' => [],
                    ],
                    1 => [
                        'name' => \Laminas\Filter\StripTags::class,
                        'options' => [],
                    ],
                ],
                'name' => 'frmVoterIdCitizen',
                'description' => 'Voter ID',
                'field_type' => 'int',
            ],
            1 => [
                'required' => false,
                'validators' => [
                    0 => [
                        'name' => \Laminas\Validator\StringLength::class,
                        'options' => [
                            'max' => '30',
                        ],
                    ],
                ],
                'filters' => [
                    0 => [
                        'name' => \Laminas\Filter\StringTrim::class,
                        'options' => [],
                    ],
                    1 => [
                        'name' => \Laminas\Filter\StripTags::class,
                        'options' => [],
                    ],
                ],
                'name' => 'frmNameCitizen',
                'description' => 'Citizen\'s name',
                'field_type' => 'string',
            ],
            2 => [
                'required' => false,
                'validators' => [
                    0 => [
                        'name' => \Laminas\Validator\StringLength::class,
                        'options' => [
                            'max' => '30',
                        ],
                    ],
                ],
                'filters' => [
                    0 => [
                        'name' => \Laminas\Filter\StringTrim::class,
                        'options' => [],
                    ],
                    1 => [
                        'name' => \Laminas\Filter\StripTags::class,
                        'options' => [],
                    ],
                ],
                'name' => 'frmLastNameCitizen',
                'description' => 'Last name',
                'field_type' => 'string',
            ],
            3 => [
                'required' => false,
                'validators' => [
                    0 => [
                        'name' => \Laminas\Validator\StringLength::class,
                        'options' => [
                            'min' => '0',
                        ],
                    ],
                ],
                'filters' => [
                    0 => [
                        'name' => \Laminas\Filter\StringTrim::class,
                        'options' => [],
                    ],
                    1 => [
                        'name' => \Laminas\Filter\StripTags::class,
                        'options' => [],
                    ],
                ],
                'name' => 'frmMaternalSurnameCitizen',
                'description' => 'Maternal surname',
                'field_type' => 'string',
            ],
            4 => [
                'required' => false,
                'validators' => [
                    0 => [
                        'name' => \Laminas\Validator\StringLength::class,
                        'options' => [
                            'max' => '10',
                            'min' => '10',
                        ],
                    ],
                ],
                'filters' => [
                    0 => [
                        'name' => \Laminas\Filter\StringTrim::class,
                        'options' => [],
                    ],
                    1 => [
                        'name' => \Laminas\Filter\StripTags::class,
                        'options' => [],
                    ],
                ],
                'name' => 'frmPhoneCitizen',
                'description' => 'Citizen\'s phone',
                'field_type' => 'string',
            ],
            5 => [
                'required' => false,
                'validators' => [
                    0 => [
                        'name' => \Laminas\Validator\StringLength::class,
                        'options' => [
                            'max' => '10',
                            'min' => '10',
                        ],
                    ],
                ],
                'filters' => [
                    0 => [
                        'name' => \Laminas\Filter\StringTrim::class,
                        'options' => [],
                    ],
                    1 => [
                        'name' => \Laminas\Filter\StripTags::class,
                        'options' => [],
                    ],
                ],
                'name' => 'frmCellPhoneCitizen',
                'description' => 'Citizen\'s cell phone',
                'field_type' => 'string',
            ],
            6 => [
                'required' => false,
                'validators' => [
                    0 => [
                        'name' => \Laminas\Validator\StringLength::class,
                        'options' => [
                            'max' => '255',
                        ],
                    ],
                ],
                'filters' => [
                    0 => [
                        'name' => \Laminas\Filter\StringTrim::class,
                        'options' => [],
                    ],
                    1 => [
                        'name' => \Laminas\Filter\StripTags::class,
                        'options' => [],
                    ],
                ],
                'name' => 'frmEmailAddressCitizen',
                'description' => 'Citizen\'s email address',
                'field_type' => 'string',
            ],
            7 => [
                'required' => false,
                'validators' => [
                    0 => [
                        'name' => \Laminas\Validator\Digits::class,
                        'options' => [],
                    ],
                    1 => [
                        'name' => \Laminas\Validator\GreaterThan::class,
                        'options' => [
                            'min' => '0',
                        ],
                    ],
                ],
                'filters' => [
                    0 => [
                        'name' => \Laminas\Filter\StringTrim::class,
                        'options' => [],
                    ],
                    1 => [
                        'name' => \Laminas\Filter\StripTags::class,
                        'options' => [],
                    ],
                ],
                'name' => 'frmNeighborhoodIdCitizen',
                'description' => 'ID of the neighborhood',
                'field_type' => 'int',
            ],
            8 => [
                'required' => false,
                'validators' => [
                    0 => [
                        'name' => \Laminas\Validator\StringLength::class,
                        'options' => [
                            'max' => '40',
                        ],
                    ],
                ],
                'filters' => [
                    0 => [
                        'name' => \Laminas\Filter\StringTrim::class,
                        'options' => [],
                    ],
                    1 => [
                        'name' => \Laminas\Filter\StripTags::class,
                        'options' => [],
                    ],
                ],
                'name' => 'frmStreetCitizen',
                'description' => 'Citizen\'s street',
                'field_type' => 'string',
            ],
            9 => [
                'required' => false,
                'validators' => [
                    0 => [
                        'name' => \Laminas\Validator\StringLength::class,
                        'options' => [
                            'max' => '15',
                        ],
                    ],
                ],
                'filters' => [
                    0 => [
                        'name' => \Laminas\Filter\StringTrim::class,
                        'options' => [],
                    ],
                    1 => [
                        'name' => \Laminas\Filter\StripTags::class,
                        'options' => [],
                    ],
                ],
                'name' => 'frmOutdoorNumberCitizen',
                'description' => 'Outdoor number',
                'field_type' => 'string',
            ],
            10 => [
                'required' => false,
                'validators' => [
                    0 => [
                        'name' => \Laminas\Validator\StringLength::class,
                        'options' => [
                            'max' => '15',
                        ],
                    ],
                ],
                'filters' => [
                    0 => [
                        'name' => \Laminas\Filter\StringTrim::class,
                        'options' => [],
                    ],
                    1 => [
                        'name' => \Laminas\Filter\StripTags::class,
                        'options' => [],
                    ],
                ],
                'name' => 'frmInteriorNumberCitizen',
                'description' => 'Interior number',
                'field_type' => 'string',
            ],
            11 => [
                'required' => false,
                'validators' => [
                    0 => [
                        'name' => \Laminas\Validator\StringLength::class,
                        'options' => [
                            'max' => '10',
                            'min' => '10',
                        ],
                    ],
                ],
                'filters' => [
                    0 => [
                        'name' => \Laminas\Filter\StringTrim::class,
                        'options' => [],
                    ],
                ],
                'name' => 'frmDateOfBirthCitizen',
                'description' => 'Date of birth',
                'field_type' => 'string',
            ],
            12 => [
                'required' => false,
                'validators' => [
                    0 => [
                        'name' => \Laminas\Validator\Digits::class,
                        'options' => [],
                    ],
                    1 => [
                        'name' => \Laminas\Validator\GreaterThan::class,
                        'options' => [
                            'min' => '0',
                        ],
                    ],
                ],
                'filters' => [
                    0 => [
                        'name' => \Laminas\Filter\StringTrim::class,
                        'options' => [],
                    ],
                ],
                'name' => 'frmJobPositionIdCitizen',
                'description' => 'Job position ID',
                'field_type' => 'int',
            ],
            13 => [
                'required' => false,
                'validators' => [
                    0 => [
                        'name' => \Laminas\Validator\StringLength::class,
                        'options' => [
                            'max' => '100',
                        ],
                    ],
                ],
                'filters' => [
                    0 => [
                        'name' => \Laminas\Filter\StringTrim::class,
                        'options' => [],
                    ],
                    1 => [
                        'name' => \Laminas\Filter\StripTags::class,
                        'options' => [],
                    ],
                ],
                'name' => 'frmSignatureCitizen',
                'description' => 'Name of the file to save the signature image',
                'field_type' => 'string',
            ],
            14 => [
                'required' => false,
                'validators' => [
                    0 => [
                        'name' => \Laminas\Validator\StringLength::class,
                        'options' => [
                            'max' => '100',
                        ],
                    ],
                ],
                'filters' => [
                    0 => [
                        'name' => \Laminas\Filter\StringTrim::class,
                        'options' => [],
                    ],
                    1 => [
                        'name' => \Laminas\Filter\StripTags::class,
                        'options' => [],
                    ],
                ],
                'name' => 'frmFrontIneCitizen',
                'description' => 'Name of the file to save the image of front INE',
                'field_type' => 'string',
            ],
            15 => [
                'required' => false,
                'validators' => [
                    0 => [
                        'name' => \Laminas\Validator\StringLength::class,
                        'options' => [
                            'max' => '100',
                        ],
                    ],
                ],
                'filters' => [
                    0 => [
                        'name' => \Laminas\Filter\StringTrim::class,
                        'options' => [],
                    ],
                    1 => [
                        'name' => \Laminas\Filter\StripTags::class,
                        'options' => [],
                    ],
                ],
                'name' => 'frmBackIneCitizen',
                'description' => 'Name of the file to save the image of back INE',
                'field_type' => 'string',
            ],
            16 => [
                'required' => false,
                'validators' => [],
                'filters' => [
                    0 => [
                        'name' => \Laminas\Filter\StringTrim::class,
                        'options' => [],
                    ],
                ],
                'description' => 'Image of signature in base64 format',
                'name' => 'frmSignatureBase64Citizen',
                'field_type' => 'string',
            ],
            17 => [
                'required' => false,
                'validators' => [],
                'filters' => [
                    0 => [
                        'name' => \Laminas\Filter\StringTrim::class,
                        'options' => [],
                    ],
                ],
                'description' => 'Image of front INE in base64 format',
                'name' => 'frmFrontIneBase64Citizen',
                'field_type' => 'string',
            ],
            18 => [
                'required' => false,
                'validators' => [],
                'filters' => [
                    0 => [
                        'name' => \Laminas\Filter\StringTrim::class,
                        'options' => [],
                    ],
                ],
                'description' => 'Image of signature in base64 format',
                'name' => 'frmBackIneBase64Citizen',
                'field_type' => 'string',
            ],
            19 => [
                'required' => false,
                'validators' => [
                    0 => [
                        'name' => \Laminas\Validator\StringLength::class,
                        'options' => [
                            'max' => '10',
                        ],
                    ],
                ],
                'filters' => [
                    0 => [
                        'name' => \Laminas\Filter\StringTrim::class,
                        'options' => [],
                    ],
                    1 => [
                        'name' => \Laminas\Filter\StripTags::class,
                        'options' => [],
                    ],
                ],
                'name' => 'frmSectionNameCitizen',
                'description' => 'Section Name of Citizen',
                'field_type' => 'string',
            ],
        ],
        'Api\\V1\\Rest\\Storage\\Validator' => [
            0 => [
                'required' => false,
                'validators' => [
                    0 => [
                        'name' => \Laminas\Validator\StringLength::class,
                        'options' => [
                            'max' => '45',
                        ],
                    ],
                ],
                'filters' => [
                    0 => [
                        'name' => \Laminas\Filter\StringTrim::class,
                        'options' => [],
                    ],
                    1 => [
                        'name' => \Laminas\Filter\StripTags::class,
                        'options' => [],
                    ],
                ],
                'name' => 'frmAppKeyDropbox',
                'description' => 'App key from dropbox account',
                'field_type' => 'string',
            ],
            1 => [
                'required' => false,
                'validators' => [
                    0 => [
                        'name' => \Laminas\Validator\StringLength::class,
                        'options' => [
                            'max' => '45',
                        ],
                    ],
                ],
                'filters' => [
                    0 => [
                        'name' => \Laminas\Filter\StringTrim::class,
                        'options' => [],
                    ],
                    1 => [
                        'name' => \Laminas\Filter\StripTags::class,
                        'options' => [],
                    ],
                ],
                'name' => 'frmAppSecretDropbox',
                'description' => 'App secret from dropbox account',
                'field_type' => 'string',
            ],
            2 => [
                'required' => false,
                'validators' => [
                    0 => [
                        'name' => \Laminas\Validator\StringLength::class,
                        'options' => [
                            'max' => '100',
                        ],
                    ],
                ],
                'filters' => [
                    0 => [
                        'name' => \Laminas\Filter\StringTrim::class,
                        'options' => [],
                    ],
                    1 => [
                        'name' => \Laminas\Filter\StripTags::class,
                        'options' => [],
                    ],
                ],
                'name' => 'frmRootPathDropbox',
                'description' => 'Root path for all apps files',
                'field_type' => 'string',
            ],
            3 => [
                'required' => false,
                'validators' => [
                    0 => [
                        'name' => \Laminas\Validator\StringLength::class,
                        'options' => [
                            'max' => '100',
                        ],
                    ],
                ],
                'filters' => [
                    0 => [
                        'name' => \Laminas\Filter\StringTrim::class,
                        'options' => [],
                    ],
                    1 => [
                        'name' => \Laminas\Filter\StripTags::class,
                        'options' => [],
                    ],
                ],
                'name' => 'frmRefreshTokenDropbox',
                'description' => 'Refresh token from dropbox',
                'field_type' => 'string',
            ],
            4 => [
                'required' => false,
                'validators' => [
                    0 => [
                        'name' => \Laminas\Validator\StringLength::class,
                        'options' => [
                            'max' => '500',
                        ],
                    ],
                ],
                'filters' => [
                    0 => [
                        'name' => \Laminas\Filter\StringTrim::class,
                        'options' => [],
                    ],
                    1 => [
                        'name' => \Laminas\Filter\StripTags::class,
                        'options' => [],
                    ],
                ],
                'name' => 'frmAccessTokenDropbox',
                'description' => 'Access token from dropbox',
                'field_type' => 'string',
            ],
            5 => [
                'required' => false,
                'validators' => [
                    0 => [
                        'name' => \Laminas\Validator\StringLength::class,
                        'options' => [
                            'max' => '100',
                        ],
                    ],
                ],
                'filters' => [
                    0 => [
                        'name' => \Laminas\Filter\StringTrim::class,
                        'options' => [],
                    ],
                    1 => [
                        'name' => \Laminas\Filter\StripTags::class,
                        'options' => [],
                    ],
                ],
                'name' => 'frmAccessCodeDropbox',
                'description' => 'Access code from dropbox',
                'field_type' => 'string',
            ],
        ],
        'Api\\V1\\Rest\\UsersSections\\Validator' => [
            0 => [
                'required' => false,
                'validators' => [
                    0 => [
                        'name' => \Laminas\Validator\Digits::class,
                        'options' => [],
                    ],
                    1 => [
                        'name' => \Laminas\Validator\GreaterThan::class,
                        'options' => [
                            'min' => '0',
                        ],
                    ],
                ],
                'filters' => [
                    0 => [
                        'name' => \Laminas\Filter\StringTrim::class,
                        'options' => [],
                    ],
                    1 => [
                        'name' => \Laminas\Filter\StripTags::class,
                        'options' => [],
                    ],
                ],
                'name' => 'frmSectionalAssignmentIdUserSection',
                'description' => 'Sectional assignment for section privileges',
                'field_type' => 'int',
            ],
            1 => [
                'required' => false,
                'validators' => [
                    0 => [
                        'name' => \Laminas\Validator\Digits::class,
                        'options' => [],
                    ],
                    1 => [
                        'name' => \Laminas\Validator\GreaterThan::class,
                        'options' => [
                            'min' => '0',
                        ],
                    ],
                ],
                'filters' => [
                    0 => [
                        'name' => \Laminas\Filter\StringTrim::class,
                        'options' => [],
                    ],
                    1 => [
                        'name' => \Laminas\Filter\StripTags::class,
                        'options' => [],
                    ],
                ],
                'name' => 'frmStateIdUserSection',
                'description' => 'State assigned for section privileges',
                'field_type' => 'int',
            ],
            2 => [
                'required' => false,
                'validators' => [
                    0 => [
                        'name' => \Laminas\Validator\IsCountable::class,
                        'options' => [],
                    ],
                ],
                'filters' => [],
                'description' => 'List of local districts assigned to the user',
                'name' => 'frmLocalDistrictsUserSection',
                'field_type' => 'array',
            ],
            3 => [
                'required' => false,
                'validators' => [
                    0 => [
                        'name' => \Laminas\Validator\IsCountable::class,
                        'options' => [],
                    ],
                ],
                'filters' => [],
                'name' => 'frmFederalDistrictsUserSection',
                'description' => 'List of federal districts assigned to the user',
                'field_type' => 'array',
            ],
            4 => [
                'required' => false,
                'validators' => [
                    0 => [
                        'name' => \Laminas\Validator\IsCountable::class,
                        'options' => [],
                    ],
                ],
                'filters' => [],
                'name' => 'frmMunicipalitiesUserSection',
                'description' => 'List of municipalities assigned to the user',
                'field_type' => 'array',
            ],
            5 => [
                'required' => false,
                'validators' => [
                    0 => [
                        'name' => \Laminas\Validator\IsCountable::class,
                        'options' => [],
                    ],
                ],
                'filters' => [],
                'name' => 'frmSectionsUserSection',
                'description' => 'List of sections assigned to the user',
                'field_type' => 'array',
            ],
        ],
        'Api\\V1\\Rest\\CommitteeMembersReport\\Validator' => [
            0 => [
                'required' => false,
                'validators' => [
                    0 => [
                        'name' => \Laminas\Validator\Digits::class,
                        'options' => [],
                    ],
                    1 => [
                        'name' => \Laminas\Validator\GreaterThan::class,
                        'options' => [
                            'min' => '1',
                            'inclusive' => true,
                        ],
                    ],
                ],
                'filters' => [],
                'name' => 'frmIdReportType',
                'description' => 'ID of a report type: general or user',
                'field_type' => 'int',
            ],
            1 => [
                'required' => false,
                'validators' => [
                    0 => [
                        'name' => \Laminas\Validator\Digits::class,
                        'options' => [],
                    ],
                    1 => [
                        'name' => \Laminas\Validator\GreaterThan::class,
                        'options' => [
                            'min' => '1',
                            'inclusive' => true,
                        ],
                    ],
                ],
                'filters' => [],
                'name' => 'frmIdElectoralProcess',
                'description' => 'ID of the electoral process to consult',
                'field_type' => 'int',
            ],
            2 => [
                'required' => false,
                'validators' => [
                    0 => [
                        'name' => \Laminas\Validator\Digits::class,
                        'options' => [],
                    ],
                    1 => [
                        'name' => \Laminas\Validator\GreaterThan::class,
                        'options' => [
                            'min' => '1',
                            'inclusive' => true,
                        ],
                    ],
                ],
                'filters' => [],
                'name' => 'frmIdState',
                'description' => 'ID of the state to consult',
                'field_type' => 'int',
            ],
            3 => [
                'required' => false,
                'validators' => [
                    0 => [
                        'name' => \Laminas\Validator\Digits::class,
                        'options' => [],
                    ],
                    1 => [
                        'name' => \Laminas\Validator\GreaterThan::class,
                        'options' => [
                            'min' => '1',
                            'inclusive' => true,
                        ],
                    ],
                ],
                'filters' => [],
                'name' => 'frmIdUsuario',
                'description' => 'ID of the user',
                'field_type' => 'int',
            ],
            4 => [
                'required' => false,
                'validators' => [
                    0 => [
                        'name' => \Laminas\Validator\Digits::class,
                        'options' => [],
                    ],
                    1 => [
                        'name' => \Laminas\Validator\GreaterThan::class,
                        'options' => [
                            'min' => '1',
                            'inclusive' => true,
                        ],
                    ],
                ],
                'filters' => [],
                'name' => 'frmIdSectionalAssignment',
                'description' => 'ID of the sectional assignment',
                'field_type' => 'int',
            ],
            5 => [
                'required' => false,
                'validators' => [
                    0 => [
                        'name' => \Laminas\Validator\IsCountable::class,
                        'options' => [],
                    ],
                ],
                'filters' => [],
                'name' => 'frmLocalDistricts',
                'description' => 'Set of local districts to consult',
                'field_type' => 'array',
            ],
            6 => [
                'required' => false,
                'validators' => [
                    0 => [
                        'name' => \Laminas\Validator\IsCountable::class,
                        'options' => [],
                    ],
                ],
                'filters' => [],
                'name' => 'frmFederalDistricts',
                'description' => 'Federal districts to consult',
                'field_type' => 'array',
            ],
            7 => [
                'required' => false,
                'validators' => [],
                'filters' => [],
                'name' => 'frmNameReportType',
                'description' => 'Report type name',
                'field_type' => 'string',
            ],
            8 => [
                'required' => false,
                'validators' => [],
                'filters' => [],
                'name' => 'frmNameElectoralProcess',
                'description' => 'Electoral process name',
                'field_type' => 'string',
            ],
            9 => [
                'required' => false,
                'validators' => [],
                'filters' => [],
                'name' => 'frmNameState',
                'description' => 'State name',
                'field_type' => 'string',
            ],
            10 => [
                'required' => false,
                'validators' => [],
                'filters' => [],
                'name' => 'frmNameUser',
                'description' => 'User name',
                'field_type' => 'string',
            ],
            11 => [
                'required' => false,
                'validators' => [],
                'filters' => [],
                'name' => 'frmNameSectionalAssignment',
                'description' => 'Sectional assignment name',
                'field_type' => 'string',
            ],
        ],
        'Api\\V1\\Rest\\Employees\\Validator' => [
            0 => [
                'required' => false,
                'validators' => [],
                'filters' => [],
                'name' => 'frmNombreEmpleado',
                'description' => 'Employee´s name',
                'field_type' => 'string',
            ],
            1 => [
                'required' => false,
                'validators' => [],
                'filters' => [],
                'name' => 'frmApellidosEmpleado',
                'description' => 'Last Name',
                'field_type' => 'string',
            ],
            2 => [
                'required' => false,
                'validators' => [],
                'filters' => [],
                'name' => 'frmApellidoMaternoEmpleado',
                'description' => 'Maternal Surname',
                'field_type' => 'string',
            ],
            3 => [
                'required' => false,
                'validators' => [],
                'filters' => [],
                'name' => 'frmTelefonoEmpleado',
                'description' => 'Employee\'s Phone',
                'field_type' => 'string',
            ],
            4 => [
                'required' => false,
                'validators' => [],
                'filters' => [],
                'name' => 'frmCorreoElectronicoEmpleado',
                'description' => 'Emmployee´s email address',
                'field_type' => 'string',
            ],
            5 => [
                'required' => false,
                'validators' => [],
                'filters' => [],
                'name' => 'frmIdColoniaEmpleado',
                'description' => 'ID of the neighborhood',
                'field_type' => 'int',
            ],
            6 => [
                'required' => false,
                'validators' => [],
                'filters' => [],
                'name' => 'frmCalleEmpleado',
                'description' => 'Employee\'s street',
                'field_type' => 'string',
            ],
            7 => [
                'required' => false,
                'validators' => [],
                'filters' => [],
                'name' => 'frmNumeroExteriorEmpleado',
                'description' => 'Employee\'s Outdoor Number',
                'field_type' => 'string',
            ],
            8 => [
                'required' => false,
                'validators' => [],
                'filters' => [],
                'name' => 'frmNumeroInteriorEmpleado',
                'description' => 'Employee\'s Interior Number',
                'field_type' => 'string',
            ],
            9 => [
                'required' => false,
                'validators' => [],
                'filters' => [],
                'name' => 'frmFechaNacimientoEmpleado',
                'description' => 'Date of birth',
                'field_type' => 'string',
            ],
            10 => [
                'required' => false,
                'validators' => [],
                'filters' => [],
                'name' => 'frmIdPuestoEmpleado',
                'description' => 'Job position ID',
                'field_type' => 'int',
            ],
            11 => [
                'required' => false,
                'validators' => [],
                'filters' => [],
                'name' => 'frmSignatureEmployee',
                'description' => 'Name of the file to save the signature image',
                'field_type' => 'string',
            ],
            12 => [
                'required' => false,
                'validators' => [],
                'filters' => [],
                'name' => 'frmSignatureBase64Employee',
                'description' => 'Image of signature in base64 format',
                'field_type' => 'string',
            ],
        ],
        'Api\\V1\\Rest\\Registro\\Validator' => [
            0 => [
                'required' => false,
                'validators' => [],
                'filters' => [
                    0 => [
                        'name' => \Laminas\Filter\StringTrim::class,
                        'options' => [],
                    ],
                ],
                'name' => 'frmCorreo',
                'description' => 'Nombre de usuario a registrar, puede ser el correo electronico o un nickname',
                'field_type' => 'string',
            ],
            1 => [
                'required' => false,
                'validators' => [],
                'filters' => [
                    0 => [
                        'name' => \Laminas\Filter\StringTrim::class,
                        'options' => [],
                    ],
                ],
                'name' => 'frmContraseña',
                'description' => 'Contraseña para registro del usuario',
                'field_type' => 'string',
            ],
            2 => [
                'required' => false,
                'validators' => [],
                'filters' => [
                    0 => [
                        'name' => \Laminas\Filter\StringTrim::class,
                        'options' => [],
                    ],
                ],
                'name' => 'frmNombre',
                'description' => 'Nombre del usuario a registrar',
                'field_type' => 'string',
            ],
            3 => [
                'required' => false,
                'validators' => [],
                'filters' => [
                    0 => [
                        'name' => \Laminas\Filter\StringTrim::class,
                        'options' => [],
                    ],
                ],
                'name' => 'frmApellidos',
                'description' => 'Apellidos del usuario a registrar',
                'field_type' => 'string',
            ],
            4 => [
                'required' => false,
                'validators' => [],
                'filters' => [
                    0 => [
                        'name' => \Laminas\Filter\StringTrim::class,
                        'options' => [],
                    ],
                ],
                'name' => 'frmApellidoMaterno',
                'description' => 'Apellido materno del usuario',
                'field_type' => 'string',
            ],
            5 => [
                'required' => false,
                'validators' => [],
                'filters' => [
                    0 => [
                        'name' => \Laminas\Filter\StringTrim::class,
                        'options' => [],
                    ],
                ],
                'name' => 'frmIdGenero',
                'description' => 'Id del genero del usuario a registrar',
                'field_type' => 'integer',
            ],
            6 => [
                'required' => false,
                'validators' => [],
                'filters' => [
                    0 => [
                        'name' => \Laminas\Filter\StringTrim::class,
                        'options' => [],
                    ],
                ],
                'name' => 'frmFechaNacimiento',
                'description' => 'Fecha de nacimiento del usuario',
                'field_type' => 'string',
            ],
            7 => [
                'required' => false,
                'validators' => [],
                'filters' => [
                    0 => [
                        'name' => \Laminas\Filter\StringTrim::class,
                        'options' => [],
                    ],
                ],
                'name' => 'frmIdRedSocial',
                'description' => 'Id de la red social de registro',
                'field_type' => 'integer',
            ],
            8 => [
                'required' => false,
                'validators' => [],
                'filters' => [
                    0 => [
                        'name' => \Laminas\Filter\StringTrim::class,
                        'options' => [],
                    ],
                ],
                'name' => 'frmUidRedSocial',
                'description' => 'Uid de la red social',
                'field_type' => 'string',
            ],
        ],
        'Api\\V1\\Rest\\Login\\Validator' => [
            0 => [
                'required' => false,
                'validators' => [
                    0 => [
                        'name' => \Laminas\Validator\StringLength::class,
                        'options' => [
                            'max' => '255',
                        ],
                    ],
                ],
                'filters' => [
                    0 => [
                        'name' => \Laminas\Filter\StringTrim::class,
                        'options' => [],
                    ],
                ],
                'name' => 'frmCorreo',
                'description' => 'Nombre del usuario, puede ser correo electronico o nombre de usuario designado',
                'field_type' => 'string',
            ],
            1 => [
                'required' => false,
                'validators' => [],
                'filters' => [
                    0 => [
                        'name' => \Laminas\Filter\StringTrim::class,
                        'options' => [],
                    ],
                ],
                'name' => 'frmContraseña',
                'description' => 'Contraseña para iniciar sesion',
                'field_type' => 'string',
            ],
            2 => [
                'required' => false,
                'validators' => [
                    0 => [
                        'name' => \Laminas\Validator\StringLength::class,
                        'options' => [
                            'max' => '100',
                        ],
                    ],
                ],
                'filters' => [
                    0 => [
                        'name' => \Laminas\Filter\StringTrim::class,
                        'options' => [],
                    ],
                ],
                'name' => 'frmUidRedSocial',
                'description' => 'Uid de la red social del usuario para iniciar sesion',
                'field_type' => 'string',
            ],
        ],
        'Api\\V1\\Rest\\AsesoriaLegalForm\\Validator' => [
            0 => [
                'required' => false,
                'validators' => [],
                'filters' => [],
                'name' => 'frmNombreCompleto',
                'description' => 'Nombre completo del usuario',
                'field_type' => 'string',
            ],
            1 => [
                'required' => false,
                'validators' => [],
                'filters' => [],
                'name' => 'frmIdGenero',
                'description' => 'Genero del usuario que llena el formulario',
                'field_type' => 'integer',
            ],
            2 => [
                'required' => false,
                'validators' => [],
                'filters' => [],
                'name' => 'frmIdNacionalidad',
                'description' => 'Id de la nacionalidad del usuario',
                'field_type' => 'integer',
            ],
            3 => [
                'required' => false,
                'validators' => [],
                'filters' => [],
                'name' => 'frmNumeroTelefonico',
                'description' => 'Numerico telefonico del usuario',
                'field_type' => 'string',
            ],
            4 => [
                'required' => false,
                'validators' => [],
                'filters' => [],
                'name' => 'frmCorreoElectronico',
                'description' => 'Correo electronico del usuario',
                'field_type' => 'string',
            ],
            5 => [
                'required' => false,
                'validators' => [],
                'filters' => [],
                'name' => 'frmDestino',
                'description' => 'Destino actual del usuario',
                'field_type' => 'string',
            ],
            6 => [
                'required' => false,
                'validators' => [],
                'filters' => [],
                'name' => 'frmHotel',
                'description' => 'Hotel del usuario',
                'field_type' => 'string',
            ],
            7 => [
                'required' => false,
                'validators' => [],
                'filters' => [],
                'name' => 'frmNumeroHabitacion',
                'description' => 'Numero de habitacion donde esta hospedado el usuario',
                'field_type' => 'string',
            ],
            8 => [
                'required' => false,
                'validators' => [],
                'filters' => [],
                'name' => 'frmMensaje',
                'description' => 'Mensaje que desea enviar el usuario',
                'field_type' => 'string',
            ],
        ],
        'Api\\V1\\Rest\\QuejasForm\\Validator' => [
            0 => [
                'required' => false,
                'validators' => [],
                'filters' => [],
                'name' => 'frmNombre',
                'description' => 'Nombre del usuario',
                'field_type' => 'string',
            ],
            1 => [
                'required' => false,
                'validators' => [],
                'filters' => [],
                'name' => 'frmApellidos',
                'description' => 'Apellidos del usuario',
                'field_type' => 'string',
            ],
            2 => [
                'required' => false,
                'validators' => [],
                'filters' => [],
                'name' => 'frmApellidoMaterno',
                'description' => 'Apellido materno usuario',
                'field_type' => 'string',
            ],
            3 => [
                'required' => false,
                'validators' => [],
                'filters' => [],
                'name' => 'frmIdNacionalidad',
                'description' => 'Id de la nacionalidad del usuario',
                'field_type' => 'integer',
            ],
            4 => [
                'required' => false,
                'validators' => [],
                'filters' => [],
                'name' => 'frmIdGenero',
                'description' => 'Id genero del usuario',
                'field_type' => 'integer',
            ],
            5 => [
                'required' => false,
                'validators' => [],
                'filters' => [],
                'name' => 'frmEdad',
                'description' => 'Edad del usuario',
                'field_type' => 'integer',
            ],
            6 => [
                'required' => false,
                'validators' => [],
                'filters' => [],
                'name' => 'frmTotalPersonasAfectadas',
                'description' => 'Numero total de personas afectadas para la queja',
                'field_type' => 'string',
            ],
            7 => [
                'required' => false,
                'validators' => [],
                'filters' => [],
                'name' => 'frmNumeroTelefonico',
                'description' => 'Numero telefonico del usuario',
                'field_type' => 'string',
            ],
            8 => [
                'required' => false,
                'validators' => [],
                'filters' => [],
                'name' => 'frmCorreoElectronico',
                'description' => 'Correo electronico del usuario',
                'field_type' => 'string',
            ],
            9 => [
                'required' => false,
                'validators' => [],
                'filters' => [],
                'name' => 'frmLugarAlojamiento',
                'description' => 'Lugar de alojamiento del usuario',
                'field_type' => 'string',
            ],
            10 => [
                'required' => false,
                'validators' => [],
                'filters' => [],
                'name' => 'frmFechaLlegada',
                'description' => 'Fecha de llegada al destino',
                'field_type' => 'string',
            ],
            11 => [
                'required' => false,
                'validators' => [],
                'filters' => [],
                'name' => 'frmFechaRegreso',
                'description' => 'Fecha de regreso desde el destino',
                'field_type' => 'string',
            ],
            12 => [
                'required' => false,
                'validators' => [],
                'filters' => [],
                'name' => 'frmIdPrestadorServicios',
                'description' => 'Id del prestador de servicios para la queja',
                'field_type' => 'integer',
            ],
            13 => [
                'required' => false,
                'validators' => [],
                'filters' => [],
                'name' => 'frmNombrePrestadorServicios',
                'description' => 'Nombre del prestador de servicios en dado caso que no exista en el listado',
                'field_type' => 'string',
            ],
            14 => [
                'required' => false,
                'validators' => [],
                'filters' => [],
                'name' => 'frmIdDestinoPrestadorServicios',
                'description' => 'Id del destino donde se encuentra el prestador de servicios',
                'field_type' => 'integer',
            ],
            15 => [
                'required' => false,
                'validators' => [],
                'filters' => [],
                'name' => 'frmNombreNuevoDestino',
                'description' => 'Nombre del nuevo destino donde se encuentra el prestador de servicios',
                'field_type' => 'string',
            ],
            16 => [
                'required' => false,
                'validators' => [],
                'filters' => [],
                'name' => 'frmIdMotivo',
                'description' => 'Id del motivo de queja',
                'field_type' => 'integer',
            ],
            17 => [
                'required' => false,
                'validators' => [],
                'filters' => [],
                'name' => 'frmDescripcionHechos',
                'description' => 'Descripcion de los hechos de la queja',
                'field_type' => 'string',
            ],
            18 => [
                'required' => false,
                'validators' => [],
                'filters' => [],
                'name' => 'frmFechaSuceso',
                'description' => 'Fecha en la que sucedieron los hechos',
                'field_type' => 'string',
            ],
            19 => [
                'required' => false,
                'validators' => [],
                'filters' => [],
                'name' => 'frmIdQuejaPresentada',
                'description' => 'Id para afirmar o negar si se presento la queja ante profeco',
                'field_type' => 'integer',
            ],
            20 => [
                'required' => false,
                'validators' => [],
                'filters' => [],
                'name' => 'frmNumeroDenunciaProfeco',
                'description' => 'Numero de la denuncia ante la PROFECO',
                'field_type' => 'string',
            ],
            21 => [
                'required' => false,
                'validators' => [],
                'filters' => [],
                'name' => 'frmEvidencia',
                'description' => 'Archivos de evidencias para la queja',
                'field_type' => 'array',
            ],
        ],
        'Api\\V1\\Rest\\ReporteTrazabilidad\\Validator' => [
            0 => [
                'required' => false,
                'validators' => [],
                'filters' => [],
                'name' => 'frmNombreTuristaTrazabilidad',
                'description' => 'Nombre completo del turista que relleno el formulario',
                'field_type' => 'string',
            ],
            1 => [
                'required' => false,
                'validators' => [],
                'filters' => [],
                'name' => 'frmCorreoElectronicoTrazabilidad',
                'description' => 'Correo electrónico capturado en el formulario',
                'field_type' => 'string',
            ],
            2 => [
                'required' => false,
                'validators' => [],
                'filters' => [],
                'name' => 'frmFormularioTrazabilidad',
                'description' => 'Nombre del formulario del cual proviene el registro',
                'field_type' => 'string',
            ],
            3 => [
                'required' => false,
                'validators' => [],
                'filters' => [],
                'name' => 'frmEstatusTrazabilidad',
                'description' => 'Estatus que retorna el envió de los datos del formulario hacia la api del cliente',
                'field_type' => 'string',
            ],
        ],
    ],
];
